/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.scan.api.configurator.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ow2.util.scan.api.IAnnotationVisitor;
import org.ow2.util.scan.api.configurator.BasicConfigurator;
import org.ow2.util.scan.api.configurator.IFieldConfigurator;
import org.ow2.util.scan.api.configurator.metadata.specific.AnnotationVisitorDispatcher;
import org.ow2.util.scan.api.configurator.metadata.specific.ISpecificClassConfigurator;
import org.ow2.util.scan.api.configurator.metadata.specific.ISpecificFieldConfigurator;
import org.ow2.util.scan.api.metadata.IClassMetadata;
import org.ow2.util.scan.api.metadata.IFieldMetadata;
import org.ow2.util.scan.api.metadata.IMethodMetadata;
import org.ow2.util.scan.api.metadata.structures.JAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldMetadataConfigurator<C extends IClassMetadata<C, M, F>, M extends IMethodMetadata<C, M, F>, F extends IFieldMetadata<C, M, F>>
extends BasicConfigurator
implements IFieldConfigurator {
    private F fieldMetadata;
    private List<ISpecificFieldConfigurator> specificFieldConfiguratorList;

    protected F getFieldMetadata() {
        return this.fieldMetadata;
    }

    public FieldMetadataConfigurator(F fieldMetadata) {
        this.fieldMetadata = fieldMetadata;
        this.specificFieldConfiguratorList = new ArrayList();
    }

    public FieldMetadataConfigurator(F fieldMetadata, List<ISpecificClassConfigurator<C, M, F>> specificClassConfiguratorList) {
        this.fieldMetadata = fieldMetadata;
        this.specificFieldConfiguratorList = new ArrayList();
        if (specificClassConfiguratorList != null) {
            Iterator i$ = specificClassConfiguratorList.iterator();
            while (i$.hasNext()) {
                ISpecificClassConfigurator specificClassConfigurator = (ISpecificClassConfigurator)i$.next();
                this.specificFieldConfiguratorList.add((Object)specificClassConfigurator.createSpecificFieldConfigurator(fieldMetadata));
            }
        }
    }

    @Override
    public IAnnotationVisitor getAnnotationVisitor(JAnnotation annotation) {
        ArrayList annotationVisitorList = new ArrayList();
        IAnnotationVisitor annotationVisitor = super.getAnnotationVisitor(annotation);
        if (annotationVisitor != null) {
            annotationVisitorList.add(annotationVisitor);
        }
        Iterator i$ = this.specificFieldConfiguratorList.iterator();
        while (i$.hasNext()) {
            ISpecificFieldConfigurator specificFieldConfigurator = (ISpecificFieldConfigurator)i$.next();
            annotationVisitor = specificFieldConfigurator.getAnnotationVisitor(annotation);
            if (annotationVisitor == null) continue;
            annotationVisitorList.add(annotationVisitor);
        }
        switch (annotationVisitorList.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (IAnnotationVisitor)annotationVisitorList.get(0);
            }
        }
        return new AnnotationVisitorDispatcher(annotationVisitorList);
    }

    @Override
    public void configurationComplete(Set<String> referencedClasses) {
        this.fieldMetadata.getClassMetadata().addStandardFieldMetadata(this.fieldMetadata);
        Iterator i$ = this.specificFieldConfiguratorList.iterator();
        while (i$.hasNext()) {
            ISpecificFieldConfigurator specificFieldConfigurator = (ISpecificFieldConfigurator)i$.next();
            specificFieldConfigurator.configurationComplete(referencedClasses);
        }
        super.configurationComplete(referencedClasses);
    }
}

