/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.scan.api.configurator.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ow2.util.scan.api.IAnnotationVisitor;
import org.ow2.util.scan.api.configurator.BasicConfigurator;
import org.ow2.util.scan.api.configurator.IMethodConfigurator;
import org.ow2.util.scan.api.configurator.metadata.specific.AnnotationVisitorDispatcher;
import org.ow2.util.scan.api.configurator.metadata.specific.ISpecificClassConfigurator;
import org.ow2.util.scan.api.configurator.metadata.specific.ISpecificMethodConfigurator;
import org.ow2.util.scan.api.metadata.IClassMetadata;
import org.ow2.util.scan.api.metadata.IFieldMetadata;
import org.ow2.util.scan.api.metadata.IMethodMetadata;
import org.ow2.util.scan.api.metadata.structures.JAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodMetadataConfigurator<C extends IClassMetadata<C, M, F>, M extends IMethodMetadata<C, M, F>, F extends IFieldMetadata<C, M, F>>
extends BasicConfigurator
implements IMethodConfigurator {
    private M methodMetadata;
    private List<ISpecificMethodConfigurator> specificMethodConfiguratorList;

    protected final M getMethodMetadata() {
        return this.methodMetadata;
    }

    public MethodMetadataConfigurator(M methodMetadata) {
        this.methodMetadata = methodMetadata;
        this.specificMethodConfiguratorList = new ArrayList();
    }

    public MethodMetadataConfigurator(M methodMetadata, List<ISpecificClassConfigurator<C, M, F>> specificClassConfiguratorList) {
        this.methodMetadata = methodMetadata;
        this.specificMethodConfiguratorList = new ArrayList();
        if (specificClassConfiguratorList != null) {
            Iterator i$ = specificClassConfiguratorList.iterator();
            while (i$.hasNext()) {
                ISpecificClassConfigurator specificClassConfigurator = (ISpecificClassConfigurator)i$.next();
                this.specificMethodConfiguratorList.add((Object)specificClassConfigurator.createSpecificMethodConfigurator(methodMetadata));
            }
        }
    }

    @Override
    public IAnnotationVisitor getAnnotationVisitor(JAnnotation annotation) {
        ArrayList annotationVisitorList = new ArrayList();
        IAnnotationVisitor annotationVisitor = super.getAnnotationVisitor(annotation);
        if (annotationVisitor != null) {
            annotationVisitorList.add(annotationVisitor);
        }
        Iterator i$ = this.specificMethodConfiguratorList.iterator();
        while (i$.hasNext()) {
            ISpecificMethodConfigurator specificMethodConfigurator = (ISpecificMethodConfigurator)i$.next();
            annotationVisitor = specificMethodConfigurator.getAnnotationVisitor(annotation);
            if (annotationVisitor == null) continue;
            annotationVisitorList.add(annotationVisitor);
        }
        switch (annotationVisitorList.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (IAnnotationVisitor)annotationVisitorList.get(0);
            }
        }
        return new AnnotationVisitorDispatcher(annotationVisitorList);
    }

    @Override
    public void configurationComplete(Set<String> referencedClasses) {
        this.methodMetadata.getClassMetadata().addStandardMethodMetadata(this.methodMetadata);
        Iterator i$ = this.specificMethodConfiguratorList.iterator();
        while (i$.hasNext()) {
            ISpecificMethodConfigurator specificMethodConfigurator = (ISpecificMethodConfigurator)i$.next();
            specificMethodConfigurator.configurationComplete(referencedClasses);
        }
    }
}

