/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOTransactionConfig;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.MuleObjectHelper;

public class EndpointReference {
    protected static final Log logger = LogFactory.getLog(EndpointReference.class);
    private String propertyName;
    private String endpointName;
    private String address;
    private String transformer;
    private String responseTransformer;
    private String createConnector;
    private Object object;
    private Map properties;
    private UMOFilter filter;
    private UMOTransactionConfig transactionConfig;

    public EndpointReference(String propertyName, String endpointName, String address, String transformer, String responseTransformer, String createConnector, Object object) {
        this.propertyName = propertyName;
        this.endpointName = endpointName;
        this.address = address;
        this.transformer = transformer;
        this.responseTransformer = responseTransformer;
        this.object = object;
        this.createConnector = createConnector;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public Object getObject() {
        return this.object;
    }

    public UMOTransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    public void setTransactionConfig(UMOTransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    public UMOFilter getFilter() {
        return this.filter;
    }

    public void setFilter(UMOFilter filter) {
        this.filter = filter;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public String getCreateConnector() {
        return this.createConnector;
    }

    public void setCreateConnector(String createConnector) {
        this.createConnector = createConnector;
    }

    public void resolveEndpoint() throws InitialisationException {
        try {
            UMOTransformer trans;
            MuleEndpoint ep = (MuleEndpoint)MuleManager.getInstance().lookupEndpoint(this.endpointName);
            if (ep == null) {
                throw new InitialisationException(CoreMessages.objectNotRegisteredWithManager("Endpoint '" + this.endpointName + "'"), (Object)this);
            }
            if (this.address != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Overloading endpoint uri for: " + this.endpointName + " from " + ep.getEndpointURI().toString() + " to " + this.address);
                }
                ep.setEndpointURI(new MuleEndpointURI(this.address));
            }
            if (this.createConnector != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Overloading createConnector property for endpoint: " + this.endpointName + " from " + ep.getCreateConnector() + " to " + this.createConnector);
                }
                ep.setCreateConnectorAsString(this.createConnector);
            }
            if (this.transformer != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Overloading Transformer for: " + this.endpointName + " from " + ep.getTransformer() + " to " + this.transformer);
                }
                trans = MuleObjectHelper.getTransformer(this.transformer, " ");
                ep.setTransformer(trans);
            }
            if (this.responseTransformer != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Overloading responseTransformer for: " + this.endpointName + " from " + ep.getResponseTransformer() + " to " + this.responseTransformer);
                }
                trans = MuleObjectHelper.getTransformer(this.responseTransformer, " ");
                ep.setResponseTransformer(trans);
            }
            if (this.filter != null) {
                ep.setFilter(this.filter);
            }
            if (this.properties != null) {
                ep.getProperties().putAll(this.properties);
            }
            if (this.transactionConfig != null) {
                ep.setTransactionConfig(this.transactionConfig);
            }
            ep.initialise();
            Method m = this.object.getClass().getMethod(this.propertyName, UMOEndpoint.class);
            if (m == null) {
                throw new InitialisationException(CoreMessages.methodWithParamsNotFoundOnObject(this.propertyName, UMOEndpoint.class, this.object.getClass()), (Object)this);
            }
            m.invoke(this.object, ep);
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InitialisationException(CoreMessages.cannotSetPropertyOnObjectWithParamType(this.propertyName, this.object.getClass(), UMOEndpoint.class), e, this);
        }
    }

    public String toString() {
        return "EndpointReference{propertyName='" + this.propertyName + "'" + ", endpointName='" + this.endpointName + "'" + ", address='" + this.address + "'" + ", transformer='" + this.transformer + "'" + ",  responseTransformer='" + this.responseTransformer + "'" + ", object=" + this.object + ", properties=" + this.properties + ", filter=" + this.filter + ", transactionConfig=" + this.transactionConfig + "}";
    }
}

