/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.routing.AbstractRouter;
import org.mule.routing.CorrelationPropertiesExtractor;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.UMOTransactionConfig;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.routing.UMOOutboundRouter;
import org.mule.util.ClassUtils;
import org.mule.util.StringMessageUtils;
import org.mule.util.SystemUtils;
import org.mule.util.properties.PropertyExtractor;

public abstract class AbstractOutboundRouter
extends AbstractRouter
implements UMOOutboundRouter {
    public static final int ENABLE_CORRELATION_IF_NOT_SET = 0;
    public static final int ENABLE_CORRELATION_ALWAYS = 1;
    public static final int ENABLE_CORRELATION_NEVER = 2;
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected List endpoints = new CopyOnWriteArrayList();
    protected String replyTo = null;
    protected int enableCorrelation = 0;
    protected PropertyExtractor propertyExtractor = new CorrelationPropertiesExtractor();
    protected UMOTransactionConfig transactionConfig;

    public void dispatch(UMOSession session, UMOMessage message, UMOEndpoint endpoint) throws UMOException {
        this.setMessageProperties(session, message, endpoint);
        if (this.logger.isDebugEnabled()) {
            try {
                this.logger.debug("Message being sent to: " + endpoint.getEndpointURI() + " Message payload: \n" + StringMessageUtils.truncate(message.getPayloadAsString(), 100, false));
            }
            catch (Exception e) {
                this.logger.debug("Message being sent to: " + endpoint.getEndpointURI() + " Message payload: \n(unable to retrieve payload: " + e.getMessage());
            }
        }
        session.dispatchEvent(message, endpoint);
        if (this.getRouterStatistics() != null && this.getRouterStatistics().isEnabled()) {
            this.getRouterStatistics().incrementRoutedMessage(endpoint);
        }
    }

    public UMOMessage send(UMOSession session, UMOMessage message, UMOEndpoint endpoint) throws UMOException {
        if (this.replyTo != null) {
            this.logger.debug("event was dispatched synchronously, but there is a ReplyTo endpoint set, so using asynchronous dispatch");
            this.dispatch(session, message, endpoint);
            return null;
        }
        this.setMessageProperties(session, message, endpoint);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Message being sent to: " + endpoint.getEndpointURI());
            this.logger.debug(message);
        }
        if (this.logger.isTraceEnabled()) {
            try {
                this.logger.trace("Message payload: \n" + message.getPayloadAsString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        UMOMessage result = session.sendEvent(message, endpoint);
        if (this.getRouterStatistics() != null && this.getRouterStatistics().isEnabled()) {
            this.getRouterStatistics().incrementRoutedMessage(endpoint);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Response message from sending to: " + endpoint.getEndpointURI());
            this.logger.debug(result);
        }
        if (this.logger.isTraceEnabled()) {
            try {
                this.logger.trace("Message payload: \n" + result.getPayloadAsString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    protected void setMessageProperties(UMOSession session, UMOMessage message, UMOEndpoint endpoint) {
        if (this.replyTo != null) {
            message.setReplyTo(this.replyTo);
            message.setProperty("MULE_REPLYTO_REQUESTOR", session.getComponent().getDescriptor().getName());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Setting replyTo=" + this.replyTo + " for outbound endpoint: " + endpoint.getEndpointURI());
            }
        }
        if (this.enableCorrelation != 2) {
            boolean correlationSet;
            boolean bl = correlationSet = message.getCorrelationId() != null;
            if (correlationSet && this.enableCorrelation == 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("CorrelationId is already set to '" + message.getCorrelationId() + "' , not setting it again");
                }
                return;
            }
            if (correlationSet) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("CorrelationId is already set to '" + message.getCorrelationId() + "', but router is configured to overwrite it");
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("No CorrelationId is set on the message, will set a new Id");
            }
            Object o = this.propertyExtractor.getProperty("MULE_CORRELATION_ID", message);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Extracted correlation Id as: " + o);
            }
            String correlation = o.toString();
            if (this.logger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("Setting Correlation info on Outbound router for endpoint: ").append(endpoint.getEndpointURI());
                buf.append(SystemUtils.LINE_SEPARATOR).append("Id=").append(correlation);
                this.logger.debug(buf.toString());
            }
            message.setCorrelationId(correlation);
        }
    }

    public List getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List endpoints) {
        Iterator iterator = endpoints.iterator();
        while (iterator.hasNext()) {
            UMOEndpoint umoEndpoint = (UMOEndpoint)iterator.next();
            this.addEndpoint(umoEndpoint);
        }
    }

    public void addEndpoint(UMOEndpoint endpoint) {
        this.endpoints.add(endpoint);
    }

    public boolean removeEndpoint(UMOImmutableEndpoint endpoint) {
        return this.endpoints.remove(endpoint);
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo != null ? MuleManager.getInstance().lookupEndpointIdentifier(replyTo, replyTo) : null;
    }

    public int getEnableCorrelation() {
        return this.enableCorrelation;
    }

    public void setEnableCorrelation(int enableCorrelation) {
        this.enableCorrelation = enableCorrelation;
    }

    public void setEnableCorrelationAsString(String enableCorrelation) {
        if (enableCorrelation != null) {
            if (enableCorrelation.equals("ALWAYS")) {
                this.enableCorrelation = 1;
            } else if (enableCorrelation.equals("NEVER")) {
                this.enableCorrelation = 2;
            } else if (enableCorrelation.equals("IF_NOT_SET")) {
                this.enableCorrelation = 0;
            } else {
                throw new IllegalArgumentException("Value for enableCorrelation not recognised: " + enableCorrelation);
            }
        }
    }

    public PropertyExtractor getPropertyExtractor() {
        return this.propertyExtractor;
    }

    public void setPropertyExtractor(PropertyExtractor propertyExtractor) {
        this.propertyExtractor = propertyExtractor;
    }

    public void setPropertyExtractorAsString(String className) {
        try {
            this.propertyExtractor = (PropertyExtractor)ClassUtils.instanciateClass(className, null, this.getClass());
        }
        catch (Exception ex) {
            throw (IllegalArgumentException)new IllegalArgumentException("Couldn't instanciate property extractor class " + className).initCause(ex);
        }
    }

    public UMOTransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    public void setTransactionConfig(UMOTransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    public boolean isDynamicEndpoints() {
        return false;
    }
}

