#!/bin/sh

# Check if $JONAS_ROOT is set.
if [ -z "$JONAS_ROOT" ]; then
    echo Please set the JONAS_ROOT variable.
    exit
fi

# Check if $JONAS_BASE is set.
if [ -z "$JONAS_BASE" ]; then
    JONAS_BASE=$JONAS_ROOT
fi


export PATH=$JONAS_ROOT/bin:$PATH

# ---------------------------------------------
# Get arguments
# ---------------------------------------------
ARGS=

case "$1" in
  start)
    rm "$JONAS_BASE"/deploy/zz_jasmine-monitoring.xml
    jonas start -clean -Djonas.felix.configuration.file=config.properties &
    sleep 25
    echo
    echo Deploying JASMINe Monitoring ...
    cp "$JONAS_BASE"/repositories/url-internal/zz_jasmine-monitoring.xml "$JONAS_BASE"/deploy
    ;;
  stop)
    jonas stop
    ;;
  *)
    echo "usage : jasmine start | stop"
esac
