/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.commands;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.easybeans.component.smartclient.spi.SmartContextFactory;
import org.ow2.jasmine.event.messages.JasmineEventTimer;
import org.ow2.jasmine.monitoring.eventswitch.beans.JasmineEventTimerSLBRemote;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class PurgeDataBase {
    private static final String EJB_JNDI_NAME = "db-ejb/timer";
    private static JasmineEventTimerSLBRemote purgeEjb = null;
    private static final String DATE_FORMAT = "yyyy/MM/dd-HH:mm";
    private Format formatter;
    private static Log logger = LogFactory.getLog(PurgeDataBase.class);
    protected String[] arguments = null;
    protected String name = "purge";
    private Options options = null;
    private CommandLine commandLine = null;
    private long maxEntryAge;
    private int maxEntryNumber = -1;
    private Date executionStartDate = null;
    private long executionInterval;
    private boolean immediateExecution = true;
    private boolean executeOnAllServers = true;
    private String domainName;
    private String serverName;

    public PurgeDataBase() {
        this.setOptions();
        this.formatter = new SimpleDateFormat(DATE_FORMAT);
    }

    private void setOptions() {
        this.options = new Options();
        OptionGroup ageOrNumber = new OptionGroup();
        ageOrNumber.setRequired(true);
        Option option = this.getOption("maxAge");
        ageOrNumber.addOption(option);
        option = this.getOption("maxNumber");
        ageOrNumber.addOption(option);
        this.options.addOptionGroup(ageOrNumber);
        option = this.getOption("serverName");
        this.options.addOption(option);
        option = this.getOption("domainName");
        this.options.addOption(option);
        option = this.getOption("startDate");
        this.options.addOption(option);
        option = this.getOption("execPeriod");
        this.options.addOption(option);
    }

    private Option getOption(String optionName) {
        Option option = null;
        if (optionName.equals("maxAge")) {
            option = new Option("maxAge", "maxAge", true, "Entries older then maxAge will be purged");
            option.setRequired(false);
            option.setArgs(1);
            option.setArgName("max entry age");
        } else if (optionName.equals("maxNumber")) {
            option = new Option("maxNumber", "maxNumber", true, "Maximum number of entries that are not purged");
            option.setRequired(false);
            option.setArgs(1);
            option.setArgName("max entry number");
        } else if (optionName.equals("serverName")) {
            option = new Option("serverName", "serverName", true, "The entries that will be purged are related to this server");
            option.setRequired(false);
            option.setArgs(1);
            option.setArgName("server name");
        } else if (optionName.equals("domainName")) {
            option = new Option("domainName", "domainName", true, "The entries that will be purged are related to this domain");
            option.setRequired(false);
            option.setArgs(1);
            option.setArgName("domain name");
        } else if (optionName.equals("startDate")) {
            option = new Option("startDate", "startDate", true, "Date for purge to start");
            option.setRequired(false);
            option.setArgs(1);
            option.setArgName("start date");
        } else if (optionName.equals("execPeriod")) {
            option = new Option("execPeriod", "execPeriod", true, "Time interval for purge execution");
            option.setRequired(false);
            option.setArgs(1);
            option.setArgName("execution period");
        }
        return option;
    }

    private void setArgs(String[] args) throws ParseException, AlreadySelectedException, MissingOptionException, java.text.ParseException {
        BasicParser bp = new BasicParser();
        this.commandLine = bp.parse(this.options, args);
        if (this.commandLine.hasOption("maxAge")) {
            this.setMaxEntryAge(this.commandLine.getOptionValue("maxAge"));
        }
        if (this.commandLine.hasOption("maxNumber")) {
            this.setMaxEntryNumber(this.commandLine.getOptionValue("maxNumber"));
        }
        if (this.commandLine.hasOption("startDate")) {
            this.setExecutionStartDate(this.commandLine.getOptionValue("startDate"));
            this.immediateExecution = false;
        }
        if (this.commandLine.hasOption("execPeriod")) {
            this.setExecutionInterval(this.commandLine.getOptionValue("execPeriod"));
            this.immediateExecution = false;
        }
        if (this.commandLine.hasOption("serverName")) {
            this.setServerName(this.commandLine.getOptionValue("serverName"));
            this.executeOnAllServers = false;
        }
        if (this.commandLine.hasOption("domainName")) {
            this.setDomainName(this.commandLine.getOptionValue("domainName"));
            this.executeOnAllServers = false;
        }
    }

    private void exec() {
        JasmineEventTimer purgeTimer = this.initPurgeTimer();
        try {
            purgeEjb.configureTimer(purgeTimer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JasmineEventTimer initPurgeTimer() {
        JasmineEventTimer event = new JasmineEventTimer();
        event.setMaxEntryAge(this.getMaxEntryAge());
        event.setMaxEntryNumber(this.getMaxEntryNumber());
        event.setExecutionStartDate(this.getExecutionStartDate());
        event.setExecutionInterval(this.getExecutionInterval());
        if (this.getExecutionInterval() != 0L && this.getExecutionStartDate() == null) {
            this.setExecutionStartDate();
            event.setExecutionStartDate(this.getExecutionStartDate());
        }
        event.setExecuteOnAllServers(this.isExecuteOnAllServers());
        event.setImmediateExecution(this.isImmediateExecution());
        event.setDomainName(this.getDomainName());
        event.setServerName(this.getServerName());
        return event;
    }

    private long getMaxEntryAge() {
        return this.maxEntryAge;
    }

    private void setMaxEntryAge(String maxEntryAge_param) {
        try {
            this.maxEntryAge = this.getMilliSeconds(maxEntryAge_param);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private int getMaxEntryNumber() {
        return this.maxEntryNumber;
    }

    private void setMaxEntryNumber(String maxEntryNumber_param) {
        this.maxEntryNumber = new Integer(maxEntryNumber_param);
    }

    private Date getExecutionStartDate() {
        return this.executionStartDate;
    }

    private void setExecutionStartDate(String executionStartDate_param) throws java.text.ParseException {
        Date date = null;
        date = (Date)this.formatter.parseObject(executionStartDate_param);
        this.executionStartDate = date;
        System.out.println("Periodic execution starts : " + this.executionStartDate);
    }

    private void setExecutionStartDate() {
        this.executionStartDate = Calendar.getInstance().getTime();
        System.out.println("Periodic execution starts now : " + this.executionStartDate);
    }

    private long getExecutionInterval() {
        return this.executionInterval;
    }

    private void setExecutionInterval(String executionInterval_param) throws IllegalArgumentException {
        this.executionInterval = this.getMilliSeconds(executionInterval_param);
    }

    private boolean isExecuteOnAllServers() {
        return this.executeOnAllServers;
    }

    private boolean isImmediateExecution() {
        return this.immediateExecution;
    }

    private String getServerName() {
        return this.serverName;
    }

    private void setServerName(String serverName_param) {
        this.serverName = serverName_param;
    }

    private String getDomainName() {
        return this.domainName;
    }

    private void setDomainName(String domainName_param) {
        this.domainName = domainName_param;
    }

    private long getMilliSeconds(String duration) throws IllegalArgumentException {
        int beginIndex;
        duration = duration.toLowerCase();
        String daysMarquer = "d";
        String hoursMarquer = "h";
        String minutesMarquer = "m";
        long numberOfMilliSeconds = 0L;
        int numberOfDays = 0;
        int numberOfHours = 0;
        int numberOfMinutes = 0;
        int dayIndex = duration.indexOf(daysMarquer);
        int hoursIndex = duration.indexOf(hoursMarquer);
        int minutesIndex = duration.indexOf(minutesMarquer);
        if (dayIndex == -1 && hoursIndex == -1 && minutesIndex == -1) {
            throw new IllegalArgumentException("Duration " + duration + " is missformed. The correct form is daysDhoursHminutesM");
        }
        boolean orderOk = true;
        if (minutesIndex > 0 && (minutesIndex < dayIndex || minutesIndex < hoursIndex)) {
            orderOk = false;
        }
        if (hoursIndex > 0 && hoursIndex < dayIndex) {
            orderOk = false;
        }
        if (!orderOk) {
            throw new IllegalArgumentException("Duration " + duration + " is missformed. The correct form is daysDhoursHminutesM");
        }
        int index = duration.indexOf(daysMarquer);
        if (index > 0) {
            beginIndex = 0;
            String daysValue = duration.substring(beginIndex, index);
            duration = duration.substring(index + 1, duration.length());
            numberOfDays = new Integer(daysValue);
        }
        numberOfHours = 24 * numberOfDays;
        index = duration.indexOf(hoursMarquer);
        if (index > 0) {
            beginIndex = 0;
            String hoursValue = duration.substring(beginIndex, index);
            duration = duration.substring(index + 1, duration.length());
            numberOfHours += new Integer(hoursValue).intValue();
        }
        numberOfMinutes = 60 * numberOfHours;
        index = duration.indexOf(minutesMarquer);
        if (index > 0) {
            beginIndex = 0;
            String minutesValue = duration.substring(beginIndex, index);
            numberOfMinutes += new Integer(minutesValue).intValue();
        }
        numberOfMilliSeconds = 60000 * numberOfMinutes;
        return numberOfMilliSeconds;
    }

    private static void initEJBConnection() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", SmartContextFactory.class.getName());
        InitialContext context = new InitialContext(env);
        purgeEjb = (JasmineEventTimerSLBRemote)context.lookup(EJB_JNDI_NAME);
    }

    public static void main(String[] args) {
        PurgeDataBase purge = null;
        try {
            purge = new PurgeDataBase();
            if (args.length <= 1) {
                purge.help();
                System.exit(-1);
            }
            purge.setArgs(args);
            PurgeDataBase.initEJBConnection();
            purge.exec();
        }
        catch (AlreadySelectedException ase) {
            System.err.println("Error in purge command arguments: " + ase.getMessage());
            purge.help();
        }
        catch (java.text.ParseException pe) {
            System.err.println("Error in purge command arguments: " + pe.getMessage());
            purge.help();
        }
        catch (MissingOptionException mi) {
            System.err.println("Error in purge command arguments: " + mi.getMessage());
            purge.help();
        }
        catch (NamingException ne) {
            System.err.println("Cannot connect to the JASMINe server: " + ne.getMessage());
            ne.printStackTrace();
        }
        catch (IllegalArgumentException ia) {
            System.err.println("Error in purge command arguments: " + ia.getMessage());
            purge.help();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void help() {
        ClassLoader classL = Thread.currentThread().getContextClassLoader();
        InputStream in0 = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getHelpDoc());
        if (in0 != null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(in0));
            OutputStreamWriter out = new OutputStreamWriter(System.out);
            boolean goOn = true;
            char[] buf = new char[2048];
            while (goOn) {
                int read = in.read(buf);
                if (read > 0) {
                    out.write(buf, 0, read);
                    out.flush();
                    continue;
                }
                goOn = false;
                System.out.println();
            }
            if (in == null) return;
            try {
                in.close();
                return;
            }
            catch (IOException e) {
                logger.error((Object)"Error closing the BufferedReader", new Object[]{e});
            }
            return;
            catch (IOException e) {
                try {
                    logger.error((Object)"Error reading help", new Object[]{e});
                    if (in == null) return;
                }
                catch (Throwable throwable) {
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        logger.error((Object)"Error closing the BufferedReader", new Object[]{e2});
                    }
                    throw throwable;
                }
                try {
                    in.close();
                    return;
                }
                catch (IOException e3) {
                    logger.error((Object)"Error closing the BufferedReader", new Object[]{e3});
                }
                return;
            }
        }
        System.out.println("No help available.");
    }

    protected String getHelpDoc() {
        String classRadix = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1);
        String packName = this.getClass().getPackage().getName();
        String helpdoc = packName.substring(0, packName.lastIndexOf("."));
        helpdoc = helpdoc.replaceAll("[.]", "/") + "/helpdoc/" + classRadix + ".help";
        return helpdoc;
    }

    public String summary() {
        return "Purge JASMINe DataBase";
    }
}

