/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.commands;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.easybeans.component.smartclient.spi.SmartContextFactory;
import org.ow2.jasmine.event.messages.JasmineEventPurgeTask;
import org.ow2.jasmine.monitoring.eventswitch.beans.JasmineEventPurgeTaskSLBRemote;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class PurgeDataBase {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String EJB_JNDI_NAME = "db-ejb/purgetask";
    private static JasmineEventPurgeTaskSLBRemote purgeEjb = null;
    private static final String DATE_FORMAT = "yyyy/MM/dd-HH:mm";
    private Format formatter;
    protected String[] arguments = null;
    protected String name = "purge";
    private Options options = null;
    private CommandLine commandLine = null;
    private boolean createTask = false;
    private boolean listTasks = false;
    private boolean removeTask = false;
    private boolean pauseTask = false;
    private boolean startTask = false;
    private long taskId;
    private long maxEntryAge = -1L;
    private int maxEntryNumber = -1;
    private Date executionStartDate = null;
    private long executionInterval;
    private boolean immediateExecution = true;
    private boolean executeOnAllServers = true;
    private String domainName;
    private String serverName;

    public PurgeDataBase() {
        this.setOptions();
        this.formatter = new SimpleDateFormat(DATE_FORMAT);
    }

    private void setOptions() {
        this.options = new Options();
        OptionGroup action = new OptionGroup();
        action.setRequired(true);
        Option option = this.getOption("createTask");
        action.addOption(option);
        option = this.getOption("listTasks");
        action.addOption(option);
        option = this.getOption("removeTask");
        action.addOption(option);
        option = this.getOption("pauseTask");
        action.addOption(option);
        option = this.getOption("startTask");
        action.addOption(option);
        this.options.addOptionGroup(action);
        OptionGroup ageOrNumber = new OptionGroup();
        ageOrNumber.setRequired(false);
        option = this.getOption("maxAge");
        ageOrNumber.addOption(option);
        option = this.getOption("maxNumber");
        ageOrNumber.addOption(option);
        this.options.addOptionGroup(ageOrNumber);
        option = this.getOption("serverName");
        this.options.addOption(option);
        option = this.getOption("domainName");
        this.options.addOption(option);
        option = this.getOption("startDate");
        this.options.addOption(option);
        option = this.getOption("execPeriod");
        this.options.addOption(option);
    }

    private Option getOption(String optionName) {
        Option option = null;
        if (optionName.equals("maxAge")) {
            option = new Option("maxAge", "maxAge", true, "Entries older then maxAge will be purged");
            option.setRequired(false);
            option.setArgs(1);
            option.setArgName("max entry age");
        } else if (optionName.equals("maxNumber")) {
            option = new Option("maxNumber", "maxNumber", true, "Maximum number of entries that are not purged");
            option.setRequired(false);
            option.setArgs(1);
            option.setArgName("max entry number");
        } else if (optionName.equals("serverName")) {
            option = new Option("serverName", "serverName", true, "The entries that will be purged are related to this server");
            option.setRequired(false);
            option.setArgs(1);
            option.setArgName("server name");
        } else if (optionName.equals("domainName")) {
            option = new Option("domainName", "domainName", true, "The entries that will be purged are related to this domain");
            option.setRequired(false);
            option.setArgs(1);
            option.setArgName("domain name");
        } else if (optionName.equals("startDate")) {
            option = new Option("startDate", "startDate", true, "Date for purge to start");
            option.setRequired(false);
            option.setArgs(1);
            option.setArgName("start date");
        } else if (optionName.equals("execPeriod")) {
            option = new Option("execPeriod", "execPeriod", true, "Time interval for purge execution");
            option.setRequired(false);
            option.setArgs(1);
            option.setArgName("execution period");
        } else if (optionName.equals("createTask")) {
            option = new Option("createTask", "createTask", false, "Create purge task");
            option.setRequired(false);
        } else if (optionName.equals("listTasks")) {
            option = new Option("listTasks", "listTasks", false, "List tasks");
            option.setRequired(false);
        } else if (optionName.equals("removeTask")) {
            option = new Option("removeTask", "removeTask", true, "Remove Purge task");
            option.setRequired(false);
            option.setArgs(1);
            option.setArgName("taskId");
        } else if (optionName.equals("pauseTask")) {
            option = new Option("pauseTask", "pauseTask", true, "Pause purge task");
            option.setRequired(false);
            option.setArgs(1);
            option.setArgName("taskId");
        } else if (optionName.equals("startTask")) {
            option = new Option("startTask", "startTask", true, "Start purge task");
            option.setRequired(false);
            option.setArgs(1);
            option.setArgName("taskId");
        }
        return option;
    }

    private void setArgs(String[] args) throws ParseException, AlreadySelectedException, MissingOptionException, java.text.ParseException, IllegalArgumentException {
        String idString;
        BasicParser bp = new BasicParser();
        this.commandLine = bp.parse(this.options, args);
        if (this.commandLine.hasOption("createTask")) {
            this.createTask = true;
        }
        if (this.commandLine.hasOption("listTasks")) {
            this.listTasks = true;
        }
        if (this.commandLine.hasOption("removeTask")) {
            this.removeTask = true;
            idString = this.commandLine.getOptionValue("removeTask");
            this.setTaskId(idString);
        }
        if (this.commandLine.hasOption("pauseTask")) {
            this.pauseTask = true;
            idString = this.commandLine.getOptionValue("pauseTask");
            this.setTaskId(idString);
        }
        if (this.commandLine.hasOption("startTask")) {
            this.startTask = true;
            this.setTaskId(this.commandLine.getOptionValue("startTask"));
        }
        if (this.commandLine.hasOption("maxAge")) {
            this.setMaxEntryAge(this.commandLine.getOptionValue("maxAge"));
        }
        if (this.commandLine.hasOption("maxNumber")) {
            this.setMaxEntryNumber(this.commandLine.getOptionValue("maxNumber"));
        }
        if (this.commandLine.hasOption("startDate")) {
            this.setExecutionStartDate(this.commandLine.getOptionValue("startDate"));
            this.immediateExecution = false;
        }
        if (this.commandLine.hasOption("execPeriod")) {
            this.setExecutionInterval(this.commandLine.getOptionValue("execPeriod"));
            this.immediateExecution = false;
        }
        if (this.commandLine.hasOption("serverName")) {
            this.setServerName(this.commandLine.getOptionValue("serverName"));
            this.executeOnAllServers = false;
        }
        if (this.commandLine.hasOption("domainName")) {
            this.setDomainName(this.commandLine.getOptionValue("domainName"));
            this.executeOnAllServers = false;
        }
    }

    private void exec() throws IllegalArgumentException {
        if (this.isCreateTask()) {
            this.createPurgeTask();
        } else if (this.isListTasks()) {
            this.listTasks();
        } else if (this.isRemoveTask()) {
            this.removeTask();
        } else if (this.isPauseTask()) {
            this.pauseTask();
        } else if (this.isStartTask()) {
            this.startTask();
        }
    }

    private void createPurgeTask() throws IllegalArgumentException {
        JasmineEventPurgeTask purgeTaskInitial = this.initPurgeTask();
        JasmineEventPurgeTask purgeTask = null;
        purgeTask = purgeEjb.configurePurgeTask(purgeTaskInitial);
        long purgeTaskId = purgeTask.getId();
        System.out.println("\nCreated purge task:");
        System.out.println(this.putgeTaskInfo(purgeTask));
    }

    private void listTasks() {
        List purgeTasks = purgeEjb.listPurgeTasks();
        System.out.println("\nPurge tasks:");
        for (JasmineEventPurgeTask purgeTask : purgeTasks) {
            System.out.println(this.putgeTaskInfo(purgeTask));
        }
    }

    private void removeTask() {
        long removedTaskId = purgeEjb.removePurgeTask(this.taskId);
        if (removedTaskId > 0L) {
            System.out.println("\nRemoved purge task " + this.taskId);
        } else {
            System.out.println("\nTask " + this.taskId + " cannot be removed, does not exists !");
        }
    }

    private void pauseTask() {
        long purgedTaskId = purgeEjb.pausePurgeTask(this.taskId);
        if (purgedTaskId > 0L) {
            System.out.println("\nPaused task " + this.taskId);
        } else {
            System.out.println("\nTask " + this.taskId + " cannot be paused, does not exists !");
        }
    }

    private void startTask() {
        long startedTaskId = purgeEjb.startPurgeTask(this.taskId);
        if (startedTaskId > 0L) {
            System.out.println("\nStarted task " + this.taskId);
        } else {
            System.out.println("\nTask " + this.taskId + " cannot be started, does not exists !");
        }
    }

    private String putgeTaskInfo(JasmineEventPurgeTask purgeTask) {
        String info = new String();
        String id = "Id " + purgeTask.getId();
        boolean isStarted = purgeTask.isStarted();
        boolean isAllServer = purgeTask.isExecuteOnAllServers();
        String domainName = purgeTask.getDomainName();
        String serverName = purgeTask.getServerName();
        long maxAgeValue = purgeTask.getMaxEntryAge();
        long maxNumberValue = purgeTask.getMaxEntryNumber();
        String maxAge = maxAgeValue == 0L ? "; Max Age -" : "; Max Age " + new Long(maxAgeValue).toString();
        String maxNumber = maxNumberValue == 0L ? "; Max Number -" : "; Max Number " + new Long(maxNumberValue).toString();
        String startDate = "; Start Date " + purgeTask.getExecutionStartDate();
        String period = "; Period " + purgeTask.getExecutionInterval();
        Date lastExecutionDate = purgeTask.getLastExecutionDate();
        String lastExecutionString = lastExecutionDate != null ? lastExecutionDate.toString() : " ";
        String lastExecution = "; Last Execution " + lastExecutionString + " : " + purgeTask.getRemovedEvents() + " events";
        info = info + id;
        info = isStarted ? info + "; STARTED" : (purgeTask.getExecutionInterval() != 0L ? info + "; PAUSED " : info + ";        ");
        info = isAllServer ? info + "; all" : info + "; " + serverName + "/" + domainName;
        info = info + startDate + period + maxAge + maxNumber + lastExecution;
        return info;
    }

    private JasmineEventPurgeTask initPurgeTask() throws IllegalArgumentException {
        if (!this.validOptions()) {
            throw new IllegalArgumentException("Invalid purge criteria options.");
        }
        JasmineEventPurgeTask event = new JasmineEventPurgeTask();
        event.setMaxEntryAge(this.getMaxEntryAge());
        event.setMaxEntryNumber(this.getMaxEntryNumber());
        event.setExecutionStartDate(this.getExecutionStartDate());
        event.setExecutionInterval(this.getExecutionInterval());
        event.setExecuteOnAllServers(this.isExecuteOnAllServers());
        event.setDomainName(this.getDomainName());
        event.setServerName(this.getServerName());
        return event;
    }

    private boolean validOptions() {
        boolean valid = true;
        if (this.getMaxEntryNumber() < 0 && this.getMaxEntryAge() < 0L) {
            valid = false;
        }
        return valid;
    }

    private boolean isCreateTask() {
        return this.createTask;
    }

    private boolean isListTasks() {
        return this.listTasks;
    }

    public boolean isRemoveTask() {
        return this.removeTask;
    }

    public boolean isPauseTask() {
        return this.pauseTask;
    }

    public boolean isStartTask() {
        return this.startTask;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = new Long(taskId);
    }

    private long getMaxEntryAge() {
        return this.maxEntryAge;
    }

    private void setMaxEntryAge(String maxEntryAge_param) throws IllegalArgumentException {
        this.maxEntryAge = this.getMilliSeconds(maxEntryAge_param);
    }

    private int getMaxEntryNumber() {
        return this.maxEntryNumber;
    }

    private void setMaxEntryNumber(String maxEntryNumber_param) {
        this.maxEntryNumber = new Integer(maxEntryNumber_param);
    }

    private Date getExecutionStartDate() {
        return this.executionStartDate;
    }

    private void setExecutionStartDate(String executionStartDate_param) throws java.text.ParseException {
        Date date = null;
        date = (Date)this.formatter.parseObject(executionStartDate_param);
        this.executionStartDate = date;
        System.out.println("Periodic execution starts : " + this.executionStartDate);
    }

    private void setExecutionStartDate() {
        this.executionStartDate = Calendar.getInstance().getTime();
        System.out.println("Periodic execution starts now : " + this.executionStartDate);
    }

    private long getExecutionInterval() {
        return this.executionInterval;
    }

    private void setExecutionInterval(String executionInterval_param) throws IllegalArgumentException {
        this.executionInterval = this.getMilliSeconds(executionInterval_param);
    }

    private boolean isExecuteOnAllServers() {
        return this.executeOnAllServers;
    }

    private boolean isImmediateExecution() {
        return this.immediateExecution;
    }

    private String getServerName() {
        return this.serverName;
    }

    private void setServerName(String serverName_param) {
        this.serverName = serverName_param;
    }

    private String getDomainName() {
        return this.domainName;
    }

    private void setDomainName(String domainName_param) {
        this.domainName = domainName_param;
    }

    private long getMilliSeconds(String duration) throws IllegalArgumentException {
        int beginIndex;
        duration = duration.toLowerCase();
        String daysMarquer = "d";
        String hoursMarquer = "h";
        String minutesMarquer = "m";
        long numberOfMilliSeconds = 0L;
        int numberOfDays = 0;
        int numberOfHours = 0;
        int numberOfMinutes = 0;
        int dayIndex = duration.indexOf(daysMarquer);
        int hoursIndex = duration.indexOf(hoursMarquer);
        int minutesIndex = duration.indexOf(minutesMarquer);
        if (dayIndex == -1 && hoursIndex == -1 && minutesIndex == -1) {
            throw new IllegalArgumentException("Duration " + duration + " is missformed. The correct form is daysDhoursHminutesM");
        }
        boolean orderOk = true;
        if (minutesIndex > 0 && (minutesIndex < dayIndex || minutesIndex < hoursIndex)) {
            orderOk = false;
        }
        if (hoursIndex > 0 && hoursIndex < dayIndex) {
            orderOk = false;
        }
        if (!orderOk) {
            throw new IllegalArgumentException("Duration " + duration + " is missformed. The correct form is daysDhoursHminutesM");
        }
        int index = duration.indexOf(daysMarquer);
        if (index > 0) {
            beginIndex = 0;
            String daysValue = duration.substring(beginIndex, index);
            duration = duration.substring(index + 1, duration.length());
            numberOfDays = new Integer(daysValue);
        }
        numberOfHours = 24 * numberOfDays;
        index = duration.indexOf(hoursMarquer);
        if (index > 0) {
            beginIndex = 0;
            String hoursValue = duration.substring(beginIndex, index);
            duration = duration.substring(index + 1, duration.length());
            numberOfHours += new Integer(hoursValue).intValue();
        }
        numberOfMinutes = 60 * numberOfHours;
        index = duration.indexOf(minutesMarquer);
        if (index > 0) {
            beginIndex = 0;
            String minutesValue = duration.substring(beginIndex, index);
            numberOfMinutes += new Integer(minutesValue).intValue();
        }
        numberOfMilliSeconds = 60000 * numberOfMinutes;
        return numberOfMilliSeconds;
    }

    private static void initEJBConnection() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", SmartContextFactory.class.getName());
        InitialContext context = new InitialContext(env);
        purgeEjb = (JasmineEventPurgeTaskSLBRemote)context.lookup(EJB_JNDI_NAME);
    }

    public static void main(String[] args) {
        PurgeDataBase purge = null;
        try {
            purge = new PurgeDataBase();
            if (args.length <= 0) {
                purge.help();
                System.exit(-1);
            }
            purge.setArgs(args);
            PurgeDataBase.initEJBConnection();
            purge.exec();
        }
        catch (AlreadySelectedException ase) {
            System.err.println("Error in purge command arguments: " + ase.getMessage());
            purge.help();
        }
        catch (java.text.ParseException pe) {
            System.err.println("Error in purge command arguments: " + pe.getMessage());
            purge.help();
        }
        catch (MissingOptionException mi) {
            System.err.println("Error in purge command arguments: " + mi.getMessage());
            purge.help();
        }
        catch (NamingException ne) {
            System.err.println("Cannot connect to the JASMINe server: " + ne.getMessage());
            ne.printStackTrace();
        }
        catch (IllegalArgumentException ia) {
            System.err.println("Error in purge command arguments: " + ia.getMessage());
            purge.help();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void help() {
        ClassLoader classL = Thread.currentThread().getContextClassLoader();
        InputStream in0 = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getHelpDoc());
        if (in0 != null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(in0));
            OutputStreamWriter out = new OutputStreamWriter(System.out);
            boolean goOn = true;
            char[] buf = new char[2048];
            while (goOn) {
                int read = in.read(buf);
                if (read > 0) {
                    out.write(buf, 0, read);
                    out.flush();
                    continue;
                }
                goOn = false;
                System.out.println();
            }
            if (in == null) return;
            try {
                in.close();
                return;
            }
            catch (IOException e) {
                this.logger.error((Object)"Error closing the BufferedReader ", new Object[]{e});
            }
            return;
            catch (IOException e) {
                try {
                    this.logger.error((Object)"Error reading help ", new Object[]{e});
                    if (in == null) return;
                }
                catch (Throwable throwable) {
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        this.logger.error((Object)"Error closing the BufferedReader ", new Object[]{e2});
                    }
                    throw throwable;
                }
                try {
                    in.close();
                    return;
                }
                catch (IOException e3) {
                    this.logger.error((Object)"Error closing the BufferedReader ", new Object[]{e3});
                }
                return;
            }
        }
        System.out.println("No help available.");
    }

    protected String getHelpDoc() {
        String classRadix = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1);
        String packName = this.getClass().getPackage().getName();
        String helpdoc = packName.substring(0, packName.lastIndexOf("."));
        helpdoc = helpdoc.replaceAll("[.]", "/") + "/helpdoc/" + classRadix + ".help";
        return helpdoc;
    }

    public String summary() {
        return "Purge JASMINe DataBase";
    }
}

