/*
 * Decompiled with CFR 0.152.
 */
package com.werken.saxpath;

import com.werken.saxpath.XPathReader;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.saxpath.SAXPathException;
import org.saxpath.XPathSyntaxException;
import org.saxpath.conformance.ConformanceXPathHandler;

public class XPathReaderTest
extends TestCase {
    private ConformanceXPathHandler expected;
    private ConformanceXPathHandler actual;
    private XPathReader reader;
    private String text;
    private String[] paths = new String[]{"/foo/bar[@a='1' and @b='2']", "/foo/bar[@a='1' and @b!='2']", "//attribute::*[.!='crunchy']", "'//*[contains(string(text()),'yada yada')]'"};
    private String[] bogusPaths = new String[]{"chyld::foo", "foo/tacos()", "*:foo"};

    public XPathReaderTest(String name) {
        super(name);
    }

    private ConformanceXPathHandler actual() {
        return this.actual;
    }

    private void compare() {
        Assert.assertEquals(this.expected(), this.actual());
    }

    private ConformanceXPathHandler expected() {
        return this.expected;
    }

    private XPathReader getReader() {
        return this.reader;
    }

    private String getText() {
        return this.text;
    }

    private void setReader(XPathReader reader) {
        this.reader = reader;
    }

    private void setText(String text) {
        this.text = text;
    }

    public void setUp() {
        this.setReader(new XPathReader());
        this.setText(null);
        this.actual = new ConformanceXPathHandler();
        this.expected = new ConformanceXPathHandler();
        this.getReader().setXPathHandler(this.actual());
    }

    public void tearDown() {
        this.setReader(null);
        this.setText(null);
    }

    public void testAbsoluteLocationPath() {
        try {
            this.setText("/foo/bar/baz");
            this.getReader().setUpParse(this.getText());
            this.getReader().locationPath(true);
            this.expected().startAbsoluteLocationPath();
            this.expected().startNameStep(1, "", "foo");
            this.expected().endNameStep();
            this.expected().startNameStep(1, "", "bar");
            this.expected().endNameStep();
            this.expected().startNameStep(1, "", "baz");
            this.expected().endNameStep();
            this.expected().endAbsoluteLocationPath();
            this.compare();
        }
        catch (SAXPathException e) {
            Assert.fail(e.getMessage());
        }
    }

    public void testAllNodeStep() {
        try {
            this.setText("parent::node()");
            this.getReader().setUpParse(this.getText());
            this.getReader().step(true);
            this.expected().startAllNodeStep(3);
            this.expected().endAllNodeStep();
            this.compare();
        }
        catch (SAXPathException e) {
            Assert.fail(e.getMessage());
        }
    }

    public void testBogusPaths() {
        XPathReader reader = new XPathReader();
        System.err.println("Bogus Expressions");
        int i = 0;
        while (i < this.bogusPaths.length) {
            System.err.println("----------------------------------------");
            System.err.println(this.bogusPaths[i]);
            System.err.println("----------------------------------------");
            try {
                reader.parse(this.bogusPaths[i]);
                Assert.fail("Should have thrown XPathSyntaxException");
            }
            catch (XPathSyntaxException xPathSyntaxException) {
            }
            catch (SAXPathException e) {
                Assert.fail(e.getMessage());
            }
            catch (Exception e) {
                Assert.fail(e.getMessage());
            }
            ++i;
        }
    }

    public void testCommentNodeStep() {
        try {
            this.setText("parent::comment()");
            this.getReader().setUpParse(this.getText());
            this.getReader().step(true);
            this.expected().startCommentNodeStep(3);
            this.expected().endCommentNodeStep();
            this.compare();
        }
        catch (SAXPathException e) {
            Assert.fail(e.getMessage());
        }
    }

    public void testInvalidAxis() {
        XPathReader reader = new XPathReader();
        try {
            reader.parse("chyld::foo");
            Assert.fail("Should have thrown XPathSyntaxException");
        }
        catch (XPathSyntaxException xPathSyntaxException) {
        }
        catch (SAXPathException e) {
            Assert.fail(e.getMessage());
        }
    }

    public void testNameStepWithAxisAndPrefix() {
        try {
            this.setText("parent::foo:bar");
            this.getReader().setUpParse(this.getText());
            this.getReader().step(true);
            this.expected().startNameStep(3, "foo", "bar");
            this.expected().endNameStep();
            this.compare();
        }
        catch (SAXPathException e) {
            Assert.fail(e.getMessage());
        }
    }

    public void testNodeStepWithAxis() {
        try {
            this.setText("parent::node()");
            this.getReader().setUpParse(this.getText());
            this.getReader().step(true);
            this.expected().startAllNodeStep(3);
            this.expected().endAllNodeStep();
            this.compare();
        }
        catch (SAXPathException e) {
            Assert.fail(e.getMessage());
        }
    }

    public void testNumberPredicate() {
        try {
            this.setText("[1]");
            this.getReader().setUpParse(this.getText());
            this.getReader().predicate();
            this.expected().startPredicate();
            this.expected().startOrExpr();
            this.expected().startAndExpr();
            this.expected().startEqualityExpr();
            this.expected().startRelationalExpr();
            this.expected().startAdditiveExpr();
            this.expected().startMultiplicativeExpr();
            this.expected().startUnaryExpr();
            this.expected().startUnionExpr();
            this.expected().startPathExpr();
            this.expected().startFilterExpr();
            this.expected().number(1);
            this.expected().endFilterExpr();
            this.expected().endPathExpr();
            this.expected().endUnionExpr(false);
            this.expected().endUnaryExpr(0);
            this.expected().endMultiplicativeExpr(0);
            this.expected().endAdditiveExpr(0);
            this.expected().endRelationalExpr(0);
            this.expected().endEqualityExpr(0);
            this.expected().endAndExpr(false);
            this.expected().endOrExpr(false);
            this.expected().endPredicate();
            this.compare();
        }
        catch (SAXPathException e) {
            Assert.fail(e.getMessage());
        }
    }

    public void testPaths() {
        XPathReader reader = new XPathReader();
        System.err.println("Valid Expressions");
        int i = 0;
        while (i < this.paths.length) {
            System.err.println("----------------------------------------");
            System.err.println(this.paths[i]);
            System.err.println("----------------------------------------");
            try {
                reader.parse(this.paths[i]);
            }
            catch (SAXPathException e) {
                e.printStackTrace();
                Assert.fail(e.getMessage());
            }
            catch (Exception e) {
                Assert.fail(e.getMessage());
            }
            ++i;
        }
    }

    public void testProcessingInstructionStepNoName() {
        try {
            this.setText("parent::processing-instruction()");
            this.getReader().setUpParse(this.getText());
            this.getReader().step(true);
            this.expected().startProcessingInstructionNodeStep(3, "");
            this.expected().endProcessingInstructionNodeStep();
            this.compare();
        }
        catch (SAXPathException e) {
            Assert.fail(e.getMessage());
        }
    }

    public void testProcessingInstructionStepWithName() {
        try {
            this.setText("parent::processing-instruction('cheese')");
            this.getReader().setUpParse(this.getText());
            this.getReader().step(true);
            this.expected().startProcessingInstructionNodeStep(3, "cheese");
            this.expected().endProcessingInstructionNodeStep();
            this.compare();
        }
        catch (SAXPathException e) {
            Assert.fail(e.getMessage());
        }
    }

    public void testRelativeLocationPath() {
        try {
            this.setText("foo/bar/baz");
            this.getReader().setUpParse(this.getText());
            this.getReader().locationPath(false);
            this.expected().startRelativeLocationPath();
            this.expected().startNameStep(1, "", "foo");
            this.expected().endNameStep();
            this.expected().startNameStep(1, "", "bar");
            this.expected().endNameStep();
            this.expected().startNameStep(1, "", "baz");
            this.expected().endNameStep();
            this.expected().endRelativeLocationPath();
            this.compare();
        }
        catch (SAXPathException e) {
            Assert.fail(e.getMessage());
        }
    }

    public void testSimpleNameStep() {
        try {
            this.setText("foo");
            this.getReader().setUpParse(this.getText());
            this.getReader().step(true);
            this.expected().startNameStep(1, "", "foo");
            this.expected().endNameStep();
            this.compare();
        }
        catch (SAXPathException e) {
            Assert.fail(e.getMessage());
        }
    }

    public void testTextNodeStep() {
        try {
            this.setText("parent::text()");
            this.getReader().setUpParse(this.getText());
            this.getReader().step(true);
            this.expected().startTextNodeStep(3);
            this.expected().endTextNodeStep();
            this.compare();
        }
        catch (SAXPathException e) {
            Assert.fail(e.getMessage());
        }
    }

    public void testValidAxis() {
        XPathReader reader = new XPathReader();
        try {
            reader.parse("child::foo");
        }
        catch (SAXPathException e) {
            Assert.fail(e.getMessage());
        }
    }
}

