/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.StreamPumper;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class Cab
extends MatchingTask {
    private File cabFile;
    private File baseDir;
    private Vector filesets = new Vector();
    private boolean doCompress = true;
    private boolean doVerbose = false;
    private String cmdOptions;
    protected String archiveType = "cab";
    private FileUtils fileUtils = FileUtils.newFileUtils();

    public void setCabfile(File cabFile) {
        this.cabFile = cabFile;
    }

    public void setBasedir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setCompress(boolean compress) {
        this.doCompress = compress;
    }

    public void setVerbose(boolean verbose) {
        this.doVerbose = verbose;
    }

    public void setOptions(String options) {
        this.cmdOptions = options;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    protected void checkConfiguration() throws BuildException {
        if (this.baseDir == null && this.filesets.size() == 0) {
            throw new BuildException("basedir attribute or at least one nested filest is required!", this.getLocation());
        }
        if (this.baseDir != null && !this.baseDir.exists()) {
            throw new BuildException("basedir does not exist!", this.getLocation());
        }
        if (this.cabFile == null) {
            throw new BuildException("cabfile attribute must be set!", this.getLocation());
        }
    }

    protected ExecTask createExec() throws BuildException {
        ExecTask exec = (ExecTask)this.getProject().createTask("exec");
        exec.setOwningTarget(this.getOwningTarget());
        exec.setTaskName(this.getTaskName());
        exec.setDescription(this.getDescription());
        return exec;
    }

    protected boolean isUpToDate(Vector files) {
        boolean upToDate = true;
        int i = 0;
        while (i < files.size() && upToDate) {
            String file = files.elementAt(i).toString();
            if (this.fileUtils.resolveFile(this.baseDir, file).lastModified() > this.cabFile.lastModified()) {
                upToDate = false;
            }
            ++i;
        }
        return upToDate;
    }

    protected File createListFile(Vector files) throws IOException {
        File listFile = this.fileUtils.createTempFile("ant", "", null);
        listFile.deleteOnExit();
        PrintWriter writer = new PrintWriter(new FileOutputStream(listFile));
        int size = files.size();
        int i = 0;
        while (i < size) {
            writer.println('\"' + files.elementAt(i).toString() + '\"');
            ++i;
        }
        writer.close();
        return listFile;
    }

    protected void appendFiles(Vector files, DirectoryScanner ds) {
        String[] dsfiles = ds.getIncludedFiles();
        int i = 0;
        while (i < dsfiles.length) {
            files.addElement(dsfiles[i]);
            ++i;
        }
    }

    protected Vector getFileList() throws BuildException {
        Vector files = new Vector();
        if (this.baseDir != null) {
            this.appendFiles(files, super.getDirectoryScanner(this.baseDir));
        }
        int i = 0;
        while (i < this.filesets.size()) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            if (fs != null) {
                this.appendFiles(files, fs.getDirectoryScanner(this.getProject()));
            }
            ++i;
        }
        return files;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        this.checkConfiguration();
        Vector files = this.getFileList();
        if (this.isUpToDate(files)) {
            return;
        }
        this.log("Building " + this.archiveType + ": " + this.cabFile.getAbsolutePath());
        if (!Os.isFamily("windows")) {
            this.log("Using listcab/libcabinet", 3);
            StringBuffer sb = new StringBuffer();
            Enumeration fileEnum = files.elements();
            while (fileEnum.hasMoreElements()) {
                sb.append(fileEnum.nextElement()).append("\n");
            }
            sb.append("\n").append(this.cabFile.getAbsolutePath()).append("\n");
            try {
                Process p = Execute.launch(this.getProject(), new String[]{"listcab"}, null, this.baseDir != null ? this.baseDir : this.getProject().getBaseDir(), true);
                OutputStream out = p.getOutputStream();
                LogOutputStream outLog = new LogOutputStream(this, 3);
                LogOutputStream errLog = new LogOutputStream(this, 0);
                StreamPumper outPump = new StreamPumper(p.getInputStream(), outLog);
                StreamPumper errPump = new StreamPumper(p.getErrorStream(), errLog);
                new Thread(outPump).start();
                new Thread(errPump).start();
                out.write(sb.toString().getBytes());
                out.flush();
                out.close();
                int result = -99;
                try {
                    result = p.waitFor();
                    outPump.waitFor();
                    outLog.close();
                    errPump.waitFor();
                    errLog.close();
                }
                catch (InterruptedException ie) {
                    this.log("Thread interrupted: " + ie);
                }
                if (!Execute.isFailure(result)) return;
                this.log("Error executing listcab; error code: " + result);
                return;
            }
            catch (IOException ex) {
                String msg = "Problem creating " + this.cabFile + " " + ex.getMessage();
                throw new BuildException(msg, this.getLocation());
            }
        }
        try {
            File listFile = this.createListFile(files);
            ExecTask exec = this.createExec();
            File outFile = null;
            exec.setFailonerror(true);
            exec.setDir(this.baseDir);
            if (!this.doVerbose) {
                outFile = this.fileUtils.createTempFile("ant", "", null);
                outFile.deleteOnExit();
                exec.setOutput(outFile);
            }
            exec.setExecutable("cabarc");
            exec.createArg().setValue("-r");
            exec.createArg().setValue("-p");
            if (!this.doCompress) {
                exec.createArg().setValue("-m");
                exec.createArg().setValue("none");
            }
            if (this.cmdOptions != null) {
                exec.createArg().setLine(this.cmdOptions);
            }
            exec.createArg().setValue("n");
            exec.createArg().setFile(this.cabFile);
            exec.createArg().setValue("@" + listFile.getAbsolutePath());
            exec.execute();
            if (outFile != null) {
                outFile.delete();
            }
            listFile.delete();
            return;
        }
        catch (IOException ioe) {
            String msg = "Problem creating " + this.cabFile + " " + ioe.getMessage();
            throw new BuildException(msg, this.getLocation());
        }
    }
}

