/*
 * Decompiled with CFR 0.152.
 */
package org.drools.audit;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.drools.WorkingMemoryEventManager;
import org.drools.audit.WorkingMemoryLogger;
import org.drools.audit.event.LogEvent;
import org.drools.event.KnowledgeRuntimeEventManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingMemoryInMemoryLogger
extends WorkingMemoryLogger {
    private List<LogEvent> events = new ArrayList<LogEvent>();

    public WorkingMemoryInMemoryLogger() {
    }

    public WorkingMemoryInMemoryLogger(WorkingMemoryEventManager workingMemory) {
        super(workingMemory);
    }

    public WorkingMemoryInMemoryLogger(KnowledgeRuntimeEventManager session) {
        super(session);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.events = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.events);
    }

    public String getEvents() {
        XStream xstream = new XStream();
        StringWriter writer = new StringWriter();
        try {
            ObjectOutputStream out = xstream.createObjectOutputStream(writer);
            out.writeObject(this.events);
            out.close();
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to create event output: " + t.getMessage());
        }
        return writer.toString();
    }

    public void clear() {
        this.events.clear();
    }

    @Override
    public void logEventCreated(LogEvent logEvent) {
        this.events.add(logEvent);
    }

    public List<LogEvent> getLogEvents() {
        return this.events;
    }
}

