/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Date;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorCache;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.util.DateUtils;
import org.drools.util.MathUtils;

public class ComparableEvaluatorsDefinition
implements EvaluatorDefinition {
    private static final String[] SUPPORTED_IDS = new String[]{Operator.LESS.getOperatorString(), Operator.LESS_OR_EQUAL.getOperatorString(), Operator.GREATER.getOperatorString(), Operator.GREATER_OR_EQUAL.getOperatorString()};
    private EvaluatorCache evaluators = new EvaluatorCache(){
        private static final long serialVersionUID = 4782368623L;
        {
            this.addEvaluator(ValueType.BIG_DECIMAL_TYPE, Operator.LESS, BigDecimalLessEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BIG_DECIMAL_TYPE, Operator.LESS_OR_EQUAL, BigDecimalLessOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BIG_DECIMAL_TYPE, Operator.GREATER, BigDecimalGreaterEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BIG_DECIMAL_TYPE, Operator.GREATER_OR_EQUAL, BigDecimalGreaterOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BIG_INTEGER_TYPE, Operator.LESS, BigIntegerLessEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BIG_INTEGER_TYPE, Operator.LESS_OR_EQUAL, BigIntegerLessOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BIG_INTEGER_TYPE, Operator.GREATER, BigIntegerGreaterEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BIG_INTEGER_TYPE, Operator.GREATER_OR_EQUAL, BigIntegerGreaterOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BYTE_TYPE, Operator.LESS, ByteLessEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BYTE_TYPE, Operator.LESS_OR_EQUAL, ByteLessOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BYTE_TYPE, Operator.GREATER, ByteGreaterEvaluator.INSTANCE);
            this.addEvaluator(ValueType.BYTE_TYPE, Operator.GREATER_OR_EQUAL, ByteGreaterOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PBYTE_TYPE, Operator.LESS, ByteLessEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PBYTE_TYPE, Operator.LESS_OR_EQUAL, ByteLessOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PBYTE_TYPE, Operator.GREATER, ByteGreaterEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PBYTE_TYPE, Operator.GREATER_OR_EQUAL, ByteGreaterOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.CHAR_TYPE, Operator.LESS, CharacterLessEvaluator.INSTANCE);
            this.addEvaluator(ValueType.CHAR_TYPE, Operator.LESS_OR_EQUAL, CharacterLessOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.CHAR_TYPE, Operator.GREATER, CharacterGreaterEvaluator.INSTANCE);
            this.addEvaluator(ValueType.CHAR_TYPE, Operator.GREATER_OR_EQUAL, CharacterGreaterOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PCHAR_TYPE, Operator.LESS, CharacterLessEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PCHAR_TYPE, Operator.LESS_OR_EQUAL, CharacterLessOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PCHAR_TYPE, Operator.GREATER, CharacterGreaterEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PCHAR_TYPE, Operator.GREATER_OR_EQUAL, CharacterGreaterOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.DATE_TYPE, Operator.LESS, DateLessEvaluator.INSTANCE);
            this.addEvaluator(ValueType.DATE_TYPE, Operator.LESS_OR_EQUAL, DateLessOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.DATE_TYPE, Operator.GREATER, DateGreaterEvaluator.INSTANCE);
            this.addEvaluator(ValueType.DATE_TYPE, Operator.GREATER_OR_EQUAL, DateGreaterOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.DOUBLE_TYPE, Operator.LESS, DoubleLessEvaluator.INSTANCE);
            this.addEvaluator(ValueType.DOUBLE_TYPE, Operator.LESS_OR_EQUAL, DoubleLessOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.DOUBLE_TYPE, Operator.GREATER, DoubleGreaterEvaluator.INSTANCE);
            this.addEvaluator(ValueType.DOUBLE_TYPE, Operator.GREATER_OR_EQUAL, DoubleGreaterOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PDOUBLE_TYPE, Operator.LESS, DoubleLessEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PDOUBLE_TYPE, Operator.LESS_OR_EQUAL, DoubleLessOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PDOUBLE_TYPE, Operator.GREATER, DoubleGreaterEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PDOUBLE_TYPE, Operator.GREATER_OR_EQUAL, DoubleGreaterOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.FLOAT_TYPE, Operator.LESS, FloatLessEvaluator.INSTANCE);
            this.addEvaluator(ValueType.FLOAT_TYPE, Operator.LESS_OR_EQUAL, FloatLessOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.FLOAT_TYPE, Operator.GREATER, FloatGreaterEvaluator.INSTANCE);
            this.addEvaluator(ValueType.FLOAT_TYPE, Operator.GREATER_OR_EQUAL, FloatGreaterOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PFLOAT_TYPE, Operator.LESS, FloatLessEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PFLOAT_TYPE, Operator.LESS_OR_EQUAL, FloatLessOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PFLOAT_TYPE, Operator.GREATER, FloatGreaterEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PFLOAT_TYPE, Operator.GREATER_OR_EQUAL, FloatGreaterOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.INTEGER_TYPE, Operator.LESS, IntegerLessEvaluator.INSTANCE);
            this.addEvaluator(ValueType.INTEGER_TYPE, Operator.LESS_OR_EQUAL, IntegerLessOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.INTEGER_TYPE, Operator.GREATER, IntegerGreaterEvaluator.INSTANCE);
            this.addEvaluator(ValueType.INTEGER_TYPE, Operator.GREATER_OR_EQUAL, IntegerGreaterOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PINTEGER_TYPE, Operator.LESS, IntegerLessEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PINTEGER_TYPE, Operator.LESS_OR_EQUAL, IntegerLessOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PINTEGER_TYPE, Operator.GREATER, IntegerGreaterEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PINTEGER_TYPE, Operator.GREATER_OR_EQUAL, IntegerGreaterOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.LONG_TYPE, Operator.LESS, LongLessEvaluator.INSTANCE);
            this.addEvaluator(ValueType.LONG_TYPE, Operator.LESS_OR_EQUAL, LongLessOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.LONG_TYPE, Operator.GREATER, LongGreaterEvaluator.INSTANCE);
            this.addEvaluator(ValueType.LONG_TYPE, Operator.GREATER_OR_EQUAL, LongGreaterOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PLONG_TYPE, Operator.LESS, LongLessEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PLONG_TYPE, Operator.LESS_OR_EQUAL, LongLessOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PLONG_TYPE, Operator.GREATER, LongGreaterEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PLONG_TYPE, Operator.GREATER_OR_EQUAL, LongGreaterOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, Operator.LESS, ObjectLessEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, Operator.LESS_OR_EQUAL, ObjectLessOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, Operator.GREATER, ObjectGreaterEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, Operator.GREATER_OR_EQUAL, ObjectGreaterOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.SHORT_TYPE, Operator.LESS, ShortLessEvaluator.INSTANCE);
            this.addEvaluator(ValueType.SHORT_TYPE, Operator.LESS_OR_EQUAL, ShortLessOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.SHORT_TYPE, Operator.GREATER, ShortGreaterEvaluator.INSTANCE);
            this.addEvaluator(ValueType.SHORT_TYPE, Operator.GREATER_OR_EQUAL, ShortGreaterOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PSHORT_TYPE, Operator.LESS, ShortLessEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PSHORT_TYPE, Operator.LESS_OR_EQUAL, ShortLessOrEqualEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PSHORT_TYPE, Operator.GREATER, ShortGreaterEvaluator.INSTANCE);
            this.addEvaluator(ValueType.PSHORT_TYPE, Operator.GREATER_OR_EQUAL, ShortGreaterOrEqualEvaluator.INSTANCE);
        }
    };

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.evaluators = (EvaluatorCache)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.evaluators);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.evaluators.getEvaluator(type, operator);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.evaluators.getEvaluator(type, operator);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        return this.evaluators.getEvaluator(type, Operator.determineOperator(operatorId, isNegated));
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return false;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.FACT;
    }

    public boolean supportsType(ValueType type) {
        return this.evaluators.supportsType(type);
    }

    protected static class ObjectComparator
    implements Comparator {
        protected ObjectComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof Double || arg0 instanceof Float) {
                double val0 = ((Number)arg0).doubleValue();
                double val1 = 0.0;
                if (arg1 instanceof Number) {
                    val1 = ((Number)arg1).doubleValue();
                } else if (arg1 instanceof String) {
                    val1 = Double.parseDouble((String)arg1);
                } else {
                    throw new ClassCastException("Not possible to convert " + arg1.getClass() + " into a double value to compare it to " + arg0.getClass());
                }
                return val0 > val1 ? 1 : (val0 < val1 ? -1 : 0);
            }
            if (arg0 instanceof Number) {
                long val0 = ((Number)arg0).longValue();
                long val1 = 0L;
                if (arg1 instanceof Number) {
                    val1 = ((Number)arg1).longValue();
                } else if (arg1 instanceof String) {
                    val1 = Long.parseLong((String)arg1);
                } else {
                    throw new ClassCastException("Not possible to convert " + arg1.getClass() + " into a long value to compare it to " + arg0.getClass());
                }
                return val0 > val1 ? 1 : (val0 < val1 ? -1 : 0);
            }
            if (arg0 instanceof String) {
                try {
                    double val0 = Double.parseDouble((String)arg0);
                    double val1 = 0.0;
                    if (arg1 instanceof Number) {
                        val1 = ((Number)arg1).doubleValue();
                    } else if (arg1 instanceof String) {
                        val1 = Double.parseDouble((String)arg1);
                    } else {
                        throw new ClassCastException("Not possible to convert " + arg1.getClass() + " into a double value to compare it to " + arg0.getClass());
                    }
                    return val0 > val1 ? 1 : (val0 < val1 ? -1 : 0);
                }
                catch (NumberFormatException nfe) {
                    return ((String)arg0).compareTo(arg1.toString());
                }
            }
            try {
                return ((Comparable)arg0).compareTo(arg1);
            }
            catch (ClassCastException cce) {
                throw new ClassCastException("Not possible to compare a " + arg0.getClass() + " with a " + arg1.getClass());
            }
        }
    }

    public static class ShortGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new ShortGreaterOrEqualEvaluator();

        public ShortGreaterOrEqualEvaluator() {
            super(ValueType.PSHORT_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getShortValue(workingMemory, object1) >= object2.getShortValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right >= (long)context.declaration.getExtractor().getShortValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (long)context.extractor.getShortValue(workingMemory, right) >= ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getShortValue(workingMemory, object1) >= extractor2.getShortValue(workingMemory, object2);
        }

        public String toString() {
            return "Short >=";
        }
    }

    public static class ShortGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new ShortGreaterEvaluator();

        public ShortGreaterEvaluator() {
            super(ValueType.PSHORT_TYPE, Operator.GREATER);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getShortValue(workingMemory, object1) > object2.getShortValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right > (long)context.declaration.getExtractor().getShortValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (long)context.extractor.getShortValue(workingMemory, right) > ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getShortValue(workingMemory, object1) > extractor2.getShortValue(workingMemory, object2);
        }

        public String toString() {
            return "Short >";
        }
    }

    public static class ShortLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new ShortLessOrEqualEvaluator();

        public ShortLessOrEqualEvaluator() {
            super(ValueType.PSHORT_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getShortValue(workingMemory, object1) <= object2.getShortValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right <= (long)context.declaration.getExtractor().getShortValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (long)context.extractor.getShortValue(workingMemory, right) <= ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getShortValue(workingMemory, object1) <= extractor2.getShortValue(workingMemory, object2);
        }

        public String toString() {
            return "Boolean <=";
        }
    }

    public static class ShortLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new ShortLessEvaluator();

        public ShortLessEvaluator() {
            super(ValueType.PSHORT_TYPE, Operator.LESS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getShortValue(workingMemory, object1) < object2.getShortValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right < (long)context.declaration.getExtractor().getShortValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (long)context.extractor.getShortValue(workingMemory, right) < ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getShortValue(workingMemory, object1) < extractor2.getShortValue(workingMemory, object2);
        }

        public String toString() {
            return "Short <";
        }
    }

    public static class ObjectGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectGreaterOrEqualEvaluator();
        private static final ObjectComparator comparator = new ObjectComparator();

        public ObjectGreaterOrEqualEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor.getValue(workingMemory, object1);
            return comparator.compare(comp, object2.getValue()) >= 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            Comparable comp = (Comparable)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comparator.compare(comp, context.declaration.getExtractor().getValue(workingMemory, left)) >= 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            Comparable comp = (Comparable)context.extractor.getValue(workingMemory, right);
            return comparator.compare(comp, ((VariableRestriction.ObjectVariableContextEntry)context).left) >= 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor1.getValue(workingMemory, object1);
            return comparator.compare(comp, extractor2.getValue(workingMemory, object2)) >= 0;
        }

        public String toString() {
            return "Object >=";
        }
    }

    public static class ObjectGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectGreaterEvaluator();
        private static final ObjectComparator comparator = new ObjectComparator();

        public ObjectGreaterEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.GREATER);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor.getValue(workingMemory, object1);
            return comparator.compare(comp, object2.getValue()) > 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            Comparable comp = (Comparable)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comparator.compare(comp, context.declaration.getExtractor().getValue(workingMemory, left)) > 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            Comparable comp = (Comparable)context.extractor.getValue(workingMemory, right);
            return comparator.compare(comp, ((VariableRestriction.ObjectVariableContextEntry)context).left) > 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor1.getValue(workingMemory, object1);
            return comparator.compare(comp, extractor2.getValue(workingMemory, object2)) > 0;
        }

        public String toString() {
            return "Object >";
        }
    }

    public static class ObjectLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectLessOrEqualEvaluator();
        private static final ObjectComparator comparator = new ObjectComparator();

        public ObjectLessOrEqualEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor.getValue(workingMemory, object1);
            return comparator.compare(comp, object2.getValue()) <= 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            Comparable comp = (Comparable)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comparator.compare(comp, context.declaration.getExtractor().getValue(workingMemory, left)) <= 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            Comparable comp = (Comparable)context.extractor.getValue(workingMemory, right);
            return comparator.compare(comp, ((VariableRestriction.ObjectVariableContextEntry)context).left) <= 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor1.getValue(workingMemory, object1);
            return comparator.compare(comp, extractor2.getValue(workingMemory, object2)) <= 0;
        }

        public String toString() {
            return "Object <=";
        }
    }

    public static class ObjectLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ObjectLessEvaluator();
        private static final ObjectComparator comparator = new ObjectComparator();

        public ObjectLessEvaluator() {
            super(ValueType.OBJECT_TYPE, Operator.LESS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor.getValue(workingMemory, object1);
            return comparator.compare(comp, object2.getValue()) < 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            Comparable comp = (Comparable)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return comparator.compare(comp, context.declaration.getExtractor().getValue(workingMemory, left)) < 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            Comparable comp = (Comparable)context.extractor.getValue(workingMemory, right);
            return comparator.compare(comp, ((VariableRestriction.ObjectVariableContextEntry)context).left) < 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            Comparable comp = (Comparable)extractor1.getValue(workingMemory, object1);
            return comparator.compare(comp, extractor2.getValue(workingMemory, object2)) < 0;
        }

        public String toString() {
            return "Object <";
        }
    }

    public static class LongGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new LongGreaterOrEqualEvaluator();

        public LongGreaterOrEqualEvaluator() {
            super(ValueType.PLONG_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getLongValue(workingMemory, object1) >= object2.getLongValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right >= context.declaration.getExtractor().getLongValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return context.extractor.getLongValue(workingMemory, right) >= ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getLongValue(workingMemory, object1) >= extractor2.getLongValue(workingMemory, object2);
        }

        public String toString() {
            return "Long >=";
        }
    }

    public static class LongGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new LongGreaterEvaluator();

        public LongGreaterEvaluator() {
            super(ValueType.PLONG_TYPE, Operator.GREATER);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getLongValue(workingMemory, object1) > object2.getLongValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right > context.declaration.getExtractor().getLongValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return context.extractor.getLongValue(workingMemory, right) > ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getLongValue(workingMemory, object1) > extractor2.getLongValue(workingMemory, object2);
        }

        public String toString() {
            return "Long >";
        }
    }

    public static class LongLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new LongLessOrEqualEvaluator();

        public LongLessOrEqualEvaluator() {
            super(ValueType.PLONG_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getLongValue(workingMemory, object1) <= object2.getLongValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right <= context.declaration.getExtractor().getLongValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return context.extractor.getLongValue(workingMemory, right) <= ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getLongValue(workingMemory, object1) <= extractor2.getLongValue(workingMemory, object2);
        }

        public String toString() {
            return "Long <=";
        }
    }

    public static class LongLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new LongLessEvaluator();

        public LongLessEvaluator() {
            super(ValueType.PLONG_TYPE, Operator.LESS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getLongValue(workingMemory, object1) < object2.getLongValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right < context.declaration.getExtractor().getLongValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return context.extractor.getLongValue(workingMemory, right) < ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getLongValue(workingMemory, object1) < extractor2.getLongValue(workingMemory, object2);
        }

        public String toString() {
            return "Long <";
        }
    }

    public static class IntegerGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new IntegerGreaterOrEqualEvaluator();

        public IntegerGreaterOrEqualEvaluator() {
            super(ValueType.PINTEGER_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getIntValue(workingMemory, object1) >= object2.getIntValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right >= (long)context.declaration.getExtractor().getIntValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (long)context.extractor.getIntValue(workingMemory, right) >= ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getIntValue(workingMemory, object1) >= extractor2.getIntValue(workingMemory, object2);
        }

        public String toString() {
            return "Integer >=";
        }
    }

    public static class IntegerGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new IntegerGreaterEvaluator();

        public IntegerGreaterEvaluator() {
            super(ValueType.PINTEGER_TYPE, Operator.GREATER);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getIntValue(workingMemory, object1) > object2.getIntValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right > (long)context.declaration.getExtractor().getIntValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (long)context.extractor.getIntValue(workingMemory, right) > ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getIntValue(workingMemory, object1) > extractor2.getIntValue(workingMemory, object2);
        }

        public String toString() {
            return "Integer >";
        }
    }

    public static class IntegerLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new IntegerLessOrEqualEvaluator();

        public IntegerLessOrEqualEvaluator() {
            super(ValueType.PINTEGER_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getIntValue(workingMemory, object1) <= object2.getIntValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right <= (long)context.declaration.getExtractor().getIntValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (long)context.extractor.getIntValue(workingMemory, right) <= ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getIntValue(workingMemory, object1) <= extractor2.getIntValue(workingMemory, object2);
        }

        public String toString() {
            return "Integer <=";
        }
    }

    public static class IntegerLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new IntegerLessEvaluator();

        public IntegerLessEvaluator() {
            super(ValueType.PINTEGER_TYPE, Operator.LESS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getIntValue(workingMemory, object1) < object2.getIntValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right < (long)context.declaration.getExtractor().getIntValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (long)context.extractor.getIntValue(workingMemory, right) < ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getIntValue(workingMemory, object1) < extractor2.getIntValue(workingMemory, object2);
        }

        public String toString() {
            return "Integer <";
        }
    }

    public static class FloatGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new FloatGreaterOrEqualEvaluator();

        public FloatGreaterOrEqualEvaluator() {
            super(ValueType.PFLOAT_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getFloatValue(workingMemory, object1) >= object2.getFloatValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.DoubleVariableContextEntry)context).right >= (double)context.declaration.getExtractor().getFloatValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (double)context.extractor.getFloatValue(workingMemory, right) >= ((VariableRestriction.DoubleVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getFloatValue(workingMemory, object1) >= extractor2.getFloatValue(workingMemory, object2);
        }

        public String toString() {
            return "Float >=";
        }
    }

    public static class FloatGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new FloatGreaterEvaluator();

        public FloatGreaterEvaluator() {
            super(ValueType.PFLOAT_TYPE, Operator.GREATER);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getFloatValue(workingMemory, object1) > object2.getFloatValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.DoubleVariableContextEntry)context).right > (double)context.declaration.getExtractor().getFloatValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (double)context.extractor.getFloatValue(workingMemory, right) > ((VariableRestriction.DoubleVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getFloatValue(workingMemory, object1) > extractor2.getFloatValue(workingMemory, object2);
        }

        public String toString() {
            return "Float >";
        }
    }

    public static class FloatLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new FloatLessOrEqualEvaluator();

        public FloatLessOrEqualEvaluator() {
            super(ValueType.PFLOAT_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getFloatValue(workingMemory, object1) <= object2.getFloatValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.DoubleVariableContextEntry)context).right <= (double)context.declaration.getExtractor().getFloatValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (double)context.extractor.getFloatValue(workingMemory, right) <= ((VariableRestriction.DoubleVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getFloatValue(workingMemory, object1) <= extractor2.getFloatValue(workingMemory, object2);
        }

        public String toString() {
            return "Float <=";
        }
    }

    public static class FloatLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new FloatLessEvaluator();

        public FloatLessEvaluator() {
            super(ValueType.PFLOAT_TYPE, Operator.LESS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getFloatValue(workingMemory, object1) < object2.getFloatValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.DoubleVariableContextEntry)context).right < (double)context.declaration.getExtractor().getFloatValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (double)context.extractor.getFloatValue(workingMemory, right) < ((VariableRestriction.DoubleVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getFloatValue(workingMemory, object1) < extractor2.getFloatValue(workingMemory, object2);
        }

        public String toString() {
            return "Float <";
        }
    }

    public static class DoubleGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new DoubleGreaterOrEqualEvaluator();

        public DoubleGreaterOrEqualEvaluator() {
            super(ValueType.PDOUBLE_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getDoubleValue(workingMemory, object1) >= object2.getDoubleValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.DoubleVariableContextEntry)context).right >= context.declaration.getExtractor().getDoubleValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return context.extractor.getDoubleValue(workingMemory, right) >= ((VariableRestriction.DoubleVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getDoubleValue(workingMemory, object1) >= extractor2.getDoubleValue(workingMemory, object2);
        }

        public String toString() {
            return "Double >=";
        }
    }

    public static class DoubleGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DoubleGreaterEvaluator();

        public DoubleGreaterEvaluator() {
            super(ValueType.PDOUBLE_TYPE, Operator.GREATER);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getDoubleValue(workingMemory, object1) > object2.getDoubleValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.DoubleVariableContextEntry)context).right > context.declaration.getExtractor().getDoubleValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return context.extractor.getDoubleValue(workingMemory, right) > ((VariableRestriction.DoubleVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getDoubleValue(workingMemory, object1) > extractor2.getDoubleValue(workingMemory, object2);
        }

        public String toString() {
            return "Double >";
        }
    }

    public static class DoubleLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DoubleLessOrEqualEvaluator();

        public DoubleLessOrEqualEvaluator() {
            super(ValueType.PDOUBLE_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getDoubleValue(workingMemory, object1) <= object2.getDoubleValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.DoubleVariableContextEntry)context).right <= context.declaration.getExtractor().getDoubleValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return context.extractor.getDoubleValue(workingMemory, right) <= ((VariableRestriction.DoubleVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getDoubleValue(workingMemory, object1) <= extractor2.getDoubleValue(workingMemory, object2);
        }

        public String toString() {
            return "Double <=";
        }
    }

    public static class DoubleLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DoubleLessEvaluator();

        public DoubleLessEvaluator() {
            super(ValueType.PDOUBLE_TYPE, Operator.LESS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getDoubleValue(workingMemory, object1) < object2.getDoubleValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.DoubleVariableContextEntry)context).right < context.declaration.getExtractor().getDoubleValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return context.extractor.getDoubleValue(workingMemory, right) < ((VariableRestriction.DoubleVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getDoubleValue(workingMemory, object1) < extractor2.getDoubleValue(workingMemory, object2);
        }

        public String toString() {
            return "Double <";
        }
    }

    public static class DateGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new DateGreaterOrEqualEvaluator();

        public DateGreaterOrEqualEvaluator() {
            super(ValueType.DATE_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            Object value2;
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            Date value1 = (Date)extractor.getValue(workingMemory, object1);
            return value1.compareTo(DateUtils.getRightDate(value2 = object2.getValue())) >= 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            Date value1 = (Date)context.declaration.getExtractor().getValue(workingMemory, left);
            Object value2 = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            return DateUtils.getRightDate(value2).compareTo(value1) >= 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            Date value1 = (Date)((VariableRestriction.ObjectVariableContextEntry)context).left;
            Object value2 = context.extractor.getValue(workingMemory, right);
            return DateUtils.getRightDate(value2).compareTo(value1) >= 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            Date value1 = (Date)extractor1.getValue(workingMemory, object1);
            Date value2 = (Date)extractor2.getValue(workingMemory, object2);
            if (null == value2) {
                throw new NullPointerException(extractor2.toString());
            }
            return value1.compareTo(value2) >= 0;
        }

        public String toString() {
            return "Date >=";
        }
    }

    public static class DateGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DateGreaterEvaluator();

        public DateGreaterEvaluator() {
            super(ValueType.DATE_TYPE, Operator.GREATER);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            Object value2;
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            Date value1 = (Date)extractor.getValue(workingMemory, object1);
            return value1.compareTo(DateUtils.getRightDate(value2 = object2.getValue())) > 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            Date value1 = (Date)context.declaration.getExtractor().getValue(workingMemory, left);
            Object value2 = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            return DateUtils.getRightDate(value2).compareTo(value1) > 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            Date value1 = (Date)((VariableRestriction.ObjectVariableContextEntry)context).left;
            Object value2 = context.extractor.getValue(workingMemory, right);
            return DateUtils.getRightDate(value2).compareTo(value1) > 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            Date value1 = (Date)extractor1.getValue(workingMemory, object1);
            Date value2 = (Date)extractor2.getValue(workingMemory, object2);
            if (null == value2) {
                throw new NullPointerException(extractor2.toString());
            }
            return value1.compareTo(value2) > 0;
        }

        public String toString() {
            return "Date >";
        }
    }

    public static class DateLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DateLessOrEqualEvaluator();

        public DateLessOrEqualEvaluator() {
            super(ValueType.DATE_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            Object value2;
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            Date value1 = (Date)extractor.getValue(workingMemory, object1);
            return value1.compareTo(DateUtils.getRightDate(value2 = object2.getValue())) <= 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            Date value1 = (Date)context.declaration.getExtractor().getValue(workingMemory, left);
            Object value2 = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            return DateUtils.getRightDate(value2).compareTo(value1) <= 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            Date value1 = (Date)((VariableRestriction.ObjectVariableContextEntry)context).left;
            Object value2 = context.extractor.getValue(workingMemory, right);
            return DateUtils.getRightDate(value2).compareTo(value1) <= 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            Date value1 = (Date)extractor1.getValue(workingMemory, object1);
            Date value2 = (Date)extractor2.getValue(workingMemory, object2);
            if (null == value2) {
                throw new NullPointerException(extractor2.toString());
            }
            return value1.compareTo(value2) <= 0;
        }

        public String toString() {
            return "Date <=";
        }
    }

    public static class DateLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new DateLessEvaluator();

        public DateLessEvaluator() {
            super(ValueType.DATE_TYPE, Operator.LESS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            Object value2;
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            Date value1 = (Date)extractor.getValue(workingMemory, object1);
            return value1.compareTo(DateUtils.getRightDate(value2 = object2.getValue())) < 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            Date value1 = (Date)context.declaration.getExtractor().getValue(workingMemory, left);
            Object value2 = ((VariableRestriction.ObjectVariableContextEntry)context).right;
            return DateUtils.getRightDate(value2).compareTo(value1) < 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            Date value1 = (Date)((VariableRestriction.ObjectVariableContextEntry)context).left;
            Object value2 = context.extractor.getValue(workingMemory, right);
            return DateUtils.getRightDate(value2).compareTo(value1) < 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            Date value1 = (Date)extractor1.getValue(workingMemory, object1);
            Date value2 = (Date)extractor2.getValue(workingMemory, object2);
            if (null == value2) {
                throw new NullPointerException(extractor2.toString());
            }
            return value1.compareTo(value2) < 0;
        }

        public String toString() {
            return "Date <";
        }
    }

    public static class CharacterGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new CharacterGreaterOrEqualEvaluator();

        public CharacterGreaterOrEqualEvaluator() {
            super(ValueType.PCHAR_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getCharValue(workingMemory, object1) >= object2.getCharValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.CharVariableContextEntry)context).right >= context.declaration.getExtractor().getCharValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return context.extractor.getCharValue(workingMemory, right) >= ((VariableRestriction.CharVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getCharValue(workingMemory, object1) >= extractor2.getCharValue(workingMemory, object2);
        }

        public String toString() {
            return "Character >=";
        }
    }

    public static class CharacterGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new CharacterGreaterEvaluator();

        public CharacterGreaterEvaluator() {
            super(ValueType.PCHAR_TYPE, Operator.GREATER);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getCharValue(workingMemory, object1) > object2.getCharValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.CharVariableContextEntry)context).right > context.declaration.getExtractor().getCharValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return context.extractor.getCharValue(workingMemory, right) > ((VariableRestriction.CharVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getCharValue(workingMemory, object1) > extractor2.getCharValue(workingMemory, object2);
        }

        public String toString() {
            return "Character >";
        }
    }

    public static class CharacterLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new CharacterLessOrEqualEvaluator();

        public CharacterLessOrEqualEvaluator() {
            super(ValueType.PCHAR_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getCharValue(workingMemory, object1) <= object2.getCharValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.CharVariableContextEntry)context).right <= context.declaration.getExtractor().getCharValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return context.extractor.getCharValue(workingMemory, right) <= ((VariableRestriction.CharVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getCharValue(workingMemory, object1) <= extractor2.getCharValue(workingMemory, object2);
        }

        public String toString() {
            return "Character <=";
        }
    }

    public static class CharacterLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new CharacterLessEvaluator();

        public CharacterLessEvaluator() {
            super(ValueType.PCHAR_TYPE, Operator.LESS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getCharValue(workingMemory, object1) < object2.getCharValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.CharVariableContextEntry)context).right < context.declaration.getExtractor().getCharValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return context.extractor.getCharValue(workingMemory, right) < ((VariableRestriction.CharVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getCharValue(workingMemory, object1) < extractor2.getCharValue(workingMemory, object2);
        }

        public String toString() {
            return "Character <";
        }
    }

    public static class ByteGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new ByteGreaterOrEqualEvaluator();

        public ByteGreaterOrEqualEvaluator() {
            super(ValueType.PBYTE_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getByteValue(workingMemory, object1) >= object2.getByteValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right >= (long)context.declaration.getExtractor().getByteValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (long)context.extractor.getByteValue(workingMemory, right) >= ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getByteValue(workingMemory, object1) >= extractor2.getByteValue(workingMemory, object2);
        }

        public String toString() {
            return "Byte >=";
        }
    }

    public static class ByteGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ByteGreaterEvaluator();

        public ByteGreaterEvaluator() {
            super(ValueType.PBYTE_TYPE, Operator.GREATER);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getByteValue(workingMemory, object1) > object2.getByteValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right > (long)context.declaration.getExtractor().getByteValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (long)context.extractor.getByteValue(workingMemory, right) > ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getByteValue(workingMemory, object1) > extractor2.getByteValue(workingMemory, object2);
        }

        public String toString() {
            return "Byte >";
        }
    }

    public static class ByteLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ByteLessOrEqualEvaluator();

        public ByteLessOrEqualEvaluator() {
            super(ValueType.PBYTE_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getByteValue(workingMemory, object1) <= object2.getByteValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right <= (long)context.declaration.getExtractor().getByteValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (long)context.extractor.getByteValue(workingMemory, right) <= ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getByteValue(workingMemory, object1) <= extractor2.getByteValue(workingMemory, object2);
        }

        public String toString() {
            return "Byte <=";
        }
    }

    public static class ByteLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new ByteLessEvaluator();

        public ByteLessEvaluator() {
            super(ValueType.PBYTE_TYPE, Operator.LESS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor.getByteValue(workingMemory, object1) < object2.getByteValue();
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            return ((VariableRestriction.LongVariableContextEntry)context).right < (long)context.declaration.getExtractor().getByteValue(workingMemory, left);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            return (long)context.extractor.getByteValue(workingMemory, right) < ((VariableRestriction.LongVariableContextEntry)context).left;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            return extractor1.getByteValue(workingMemory, object1) < extractor2.getByteValue(workingMemory, object2);
        }

        public String toString() {
            return "Byte <";
        }
    }

    public static class BigIntegerGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new BigIntegerGreaterOrEqualEvaluator();

        public BigIntegerGreaterOrEqualEvaluator() {
            super(ValueType.BIG_INTEGER_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigInteger comp = extractor.getBigIntegerValue(workingMemory, object1);
            return comp.compareTo(object2.getBigIntegerValue()) >= 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            BigInteger comp = MathUtils.getBigInteger(((VariableRestriction.ObjectVariableContextEntry)context).right);
            return comp.compareTo(context.declaration.getExtractor().getBigIntegerValue(workingMemory, left)) >= 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            BigInteger comp = context.extractor.getBigIntegerValue(workingMemory, right);
            return comp.compareTo(MathUtils.getBigInteger(((VariableRestriction.ObjectVariableContextEntry)context).left)) >= 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigInteger comp = extractor1.getBigIntegerValue(workingMemory, object1);
            return comp.compareTo(extractor2.getBigIntegerValue(workingMemory, object2)) >= 0;
        }

        public String toString() {
            return "BigInteger >=";
        }
    }

    public static class BigIntegerGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigIntegerGreaterEvaluator();

        public BigIntegerGreaterEvaluator() {
            super(ValueType.BIG_INTEGER_TYPE, Operator.GREATER);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigInteger comp = extractor.getBigIntegerValue(workingMemory, object1);
            return comp.compareTo(object2.getBigIntegerValue()) > 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            BigInteger comp = MathUtils.getBigInteger(((VariableRestriction.ObjectVariableContextEntry)context).right);
            return comp.compareTo(context.declaration.getExtractor().getBigIntegerValue(workingMemory, left)) > 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            BigInteger comp = context.extractor.getBigIntegerValue(workingMemory, right);
            return comp.compareTo(MathUtils.getBigInteger(((VariableRestriction.ObjectVariableContextEntry)context).left)) > 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigInteger comp = extractor1.getBigIntegerValue(workingMemory, object1);
            return comp.compareTo(extractor2.getBigIntegerValue(workingMemory, object2)) > 0;
        }

        public String toString() {
            return "BigInteger >";
        }
    }

    public static class BigIntegerLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigIntegerLessOrEqualEvaluator();

        private BigIntegerLessOrEqualEvaluator() {
            super(ValueType.BIG_INTEGER_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigInteger comp = extractor.getBigIntegerValue(workingMemory, object1);
            return comp.compareTo(object2.getBigIntegerValue()) <= 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            BigInteger comp = MathUtils.getBigInteger(((VariableRestriction.ObjectVariableContextEntry)context).right);
            return comp.compareTo(context.declaration.getExtractor().getBigIntegerValue(workingMemory, left)) <= 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            BigInteger comp = context.extractor.getBigIntegerValue(workingMemory, right);
            return comp.compareTo(MathUtils.getBigInteger(((VariableRestriction.ObjectVariableContextEntry)context).left)) <= 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigInteger comp = extractor1.getBigIntegerValue(workingMemory, object1);
            return comp.compareTo(extractor2.getBigIntegerValue(workingMemory, object2)) <= 0;
        }

        public String toString() {
            return "BigInteger <=";
        }
    }

    public static class BigIntegerLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigIntegerLessEvaluator();

        public BigIntegerLessEvaluator() {
            super(ValueType.BIG_INTEGER_TYPE, Operator.LESS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigInteger comp = extractor.getBigIntegerValue(workingMemory, object1);
            return comp.compareTo(object2.getBigIntegerValue()) < 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            BigInteger comp = MathUtils.getBigInteger(((VariableRestriction.ObjectVariableContextEntry)context).right);
            return comp.compareTo(context.declaration.getExtractor().getBigIntegerValue(workingMemory, left)) < 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            BigInteger comp = context.extractor.getBigIntegerValue(workingMemory, right);
            return comp.compareTo(MathUtils.getBigInteger(((VariableRestriction.ObjectVariableContextEntry)context).left)) < 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigInteger comp = extractor1.getBigIntegerValue(workingMemory, object1);
            return comp.compareTo(extractor2.getBigIntegerValue(workingMemory, object2)) < 0;
        }

        public String toString() {
            return "BigInteger <";
        }
    }

    public static class BigDecimalGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        private static final Evaluator INSTANCE = new BigDecimalGreaterOrEqualEvaluator();

        public BigDecimalGreaterOrEqualEvaluator() {
            super(ValueType.BIG_DECIMAL_TYPE, Operator.GREATER_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigDecimal comp = extractor.getBigDecimalValue(workingMemory, object1);
            return comp.compareTo(object2.getBigDecimalValue()) >= 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            BigDecimal comp = MathUtils.getBigDecimal(((VariableRestriction.ObjectVariableContextEntry)context).right);
            return comp.compareTo(context.declaration.getExtractor().getBigDecimalValue(workingMemory, left)) >= 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            BigDecimal comp = context.extractor.getBigDecimalValue(workingMemory, right);
            return comp.compareTo(MathUtils.getBigDecimal(((VariableRestriction.ObjectVariableContextEntry)context).left)) >= 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigDecimal comp = extractor1.getBigDecimalValue(workingMemory, object1);
            return comp.compareTo(extractor2.getBigDecimalValue(workingMemory, object2)) >= 0;
        }

        public String toString() {
            return "BigDecimal >=";
        }
    }

    public static class BigDecimalGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigDecimalGreaterEvaluator();

        public BigDecimalGreaterEvaluator() {
            super(ValueType.BIG_DECIMAL_TYPE, Operator.GREATER);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigDecimal comp = extractor.getBigDecimalValue(workingMemory, object1);
            return comp.compareTo(object2.getBigDecimalValue()) > 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            BigDecimal comp = MathUtils.getBigDecimal(((VariableRestriction.ObjectVariableContextEntry)context).right);
            return comp.compareTo(context.declaration.getExtractor().getBigDecimalValue(workingMemory, left)) > 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            BigDecimal comp = context.extractor.getBigDecimalValue(workingMemory, right);
            return comp.compareTo(MathUtils.getBigDecimal(((VariableRestriction.ObjectVariableContextEntry)context).left)) > 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigDecimal comp = extractor1.getBigDecimalValue(workingMemory, object1);
            return comp.compareTo(extractor2.getBigDecimalValue(workingMemory, object2)) > 0;
        }

        public String toString() {
            return "BigDecimal >";
        }
    }

    public static class BigDecimalLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigDecimalLessOrEqualEvaluator();

        public BigDecimalLessOrEqualEvaluator() {
            super(ValueType.BIG_DECIMAL_TYPE, Operator.LESS_OR_EQUAL);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigDecimal comp = extractor.getBigDecimalValue(workingMemory, object1);
            return comp.compareTo(object2.getBigDecimalValue()) <= 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            BigDecimal comp = MathUtils.getBigDecimal(((VariableRestriction.ObjectVariableContextEntry)context).right);
            return comp.compareTo(context.declaration.getExtractor().getBigDecimalValue(workingMemory, left)) <= 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            BigDecimal comp = context.extractor.getBigDecimalValue(workingMemory, right);
            return comp.compareTo(MathUtils.getBigDecimal(((VariableRestriction.ObjectVariableContextEntry)context).left)) <= 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigDecimal comp = extractor1.getBigDecimalValue(workingMemory, object1);
            return comp.compareTo(extractor2.getBigDecimalValue(workingMemory, object2)) <= 0;
        }

        public String toString() {
            return "BigDecimal <=";
        }
    }

    public static class BigDecimalLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new BigDecimalLessEvaluator();

        public BigDecimalLessEvaluator() {
            super(ValueType.BIG_DECIMAL_TYPE, Operator.LESS);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            if (extractor.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigDecimal comp = extractor.getBigDecimalValue(workingMemory, object1);
            return comp.compareTo(object2.getBigDecimalValue()) < 0;
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            if (context.rightNull) {
                return false;
            }
            BigDecimal comp = MathUtils.getBigDecimal(((VariableRestriction.ObjectVariableContextEntry)context).right);
            return comp.compareTo(context.declaration.getExtractor().getBigDecimalValue(workingMemory, left)) < 0;
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            if (context.extractor.isNullValue(workingMemory, right)) {
                return false;
            }
            BigDecimal comp = context.extractor.getBigDecimalValue(workingMemory, right);
            return comp.compareTo(MathUtils.getBigDecimal(((VariableRestriction.ObjectVariableContextEntry)context).left)) < 0;
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            if (extractor1.isNullValue(workingMemory, object1)) {
                return false;
            }
            BigDecimal comp = extractor1.getBigDecimalValue(workingMemory, object1);
            return comp.compareTo(extractor2.getBigDecimalValue(workingMemory, object2)) < 0;
        }

        public String toString() {
            return "BigDecimal <";
        }
    }
}

