/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.mvel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.base.ModifyInterceptor;
import org.drools.base.mvel.DroolsMVELFactory;
import org.drools.base.mvel.DroolsMVELShadowFactory;
import org.drools.base.mvel.MVELCalendarCoercion;
import org.drools.base.mvel.MVELDateCoercion;
import org.drools.base.mvel.MVELDebugHandler;
import org.drools.rule.Declaration;
import org.drools.runtime.rule.RuleContext;
import org.drools.spi.KnowledgeHelper;
import org.mvel2.DataConversion;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExpressionCompiler;

public class MVELCompilationUnit
implements Externalizable {
    private String name;
    private String expression;
    private String[] pkgImports;
    private String[] importClasses;
    private String[] importMethods;
    private String[] importFields;
    private String[] globalIdentifiers;
    private Declaration[] previousDeclarations;
    private Declaration[] localDeclarations;
    private String[] otherIdentifiers;
    private String[] inputIdentifiers;
    private String[] inputTypes;
    private String[] shadowIdentifiers;
    private int languageLevel;
    private boolean strictMode;
    private Map<String, Class> resolvedInputs;
    private static Map interceptors = new HashMap(2);
    private static final Map<String, Class> primitivesMap;
    public static final Object COMPILER_LOCK;

    public MVELCompilationUnit() {
    }

    public MVELCompilationUnit(String name, String expression, String[] pkgImports, String[] importClasses, String[] importMethods, String[] importFields, String[] globalIdentifiers, Declaration[] previousDeclarations, Declaration[] localDeclarations, String[] otherIdentifiers, String[] inputIdentifiers, String[] inputTypes, int languageLevel, boolean strictMode) {
        this.name = name;
        this.expression = expression;
        this.pkgImports = pkgImports;
        this.importClasses = importClasses;
        this.importMethods = importMethods;
        this.importFields = importFields;
        this.globalIdentifiers = globalIdentifiers;
        this.previousDeclarations = previousDeclarations;
        this.localDeclarations = localDeclarations;
        this.otherIdentifiers = otherIdentifiers;
        this.inputIdentifiers = inputIdentifiers;
        this.inputTypes = inputTypes;
        this.languageLevel = languageLevel;
        this.strictMode = strictMode;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setShadowIdentifiers(String[] shadowIdentifiers) {
        this.shadowIdentifiers = shadowIdentifiers;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.expression);
        out.writeObject(this.pkgImports);
        out.writeObject(this.importClasses);
        out.writeObject(this.importMethods);
        out.writeObject(this.importFields);
        out.writeObject(this.globalIdentifiers);
        out.writeObject(this.previousDeclarations);
        out.writeObject(this.localDeclarations);
        out.writeObject(this.otherIdentifiers);
        out.writeObject(this.inputIdentifiers);
        out.writeObject(this.inputTypes);
        out.writeObject(this.shadowIdentifiers);
        out.writeInt(this.languageLevel);
        out.writeBoolean(this.strictMode);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.expression = in.readUTF();
        this.pkgImports = (String[])in.readObject();
        this.importClasses = (String[])in.readObject();
        this.importMethods = (String[])in.readObject();
        this.importFields = (String[])in.readObject();
        this.globalIdentifiers = (String[])in.readObject();
        this.previousDeclarations = (Declaration[])in.readObject();
        this.localDeclarations = (Declaration[])in.readObject();
        this.otherIdentifiers = (String[])in.readObject();
        this.inputIdentifiers = (String[])in.readObject();
        this.inputTypes = (String[])in.readObject();
        this.shadowIdentifiers = (String[])in.readObject();
        this.languageLevel = in.readInt();
        this.strictMode = in.readBoolean();
    }

    public Serializable getCompiledExpression(ClassLoader classLoader) {
        HashMap<String, Object> resolvedImports = new HashMap<String, Object>(this.importClasses.length + this.importMethods.length + this.importFields.length);
        String lastName = null;
        try {
            Class cls;
            String className;
            String name2;
            int i$;
            String[] arr$ = this.importClasses;
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                lastName = name2 = arr$[i$];
                Class cls2 = this.loadClass(classLoader, name2);
                resolvedImports.put(cls2.getSimpleName(), cls2);
            }
            arr$ = this.importMethods;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                lastName = name2 = arr$[i$];
                int lastDot = name2.lastIndexOf(46);
                className = name2.substring(0, lastDot);
                cls = this.loadClass(classLoader, className);
                String methodName = name2.substring(lastDot + 1);
                Method method = null;
                for (Method item : cls.getMethods()) {
                    if (!methodName.equals(item.getName())) continue;
                    method = item;
                }
                resolvedImports.put(method.getName(), method);
            }
            for (String name2 : this.importFields) {
                int lastDot = name2.lastIndexOf(46);
                className = name2.substring(0, lastDot);
                cls = this.loadClass(classLoader, className);
                String fieldName = name2.substring(lastDot + 1);
                Field field = cls.getField(fieldName);
                resolvedImports.put(field.getName(), field);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeDroolsException("Unable to resolve import '" + lastName + "'");
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new RuntimeDroolsException("Unable to resolve import '" + lastName + "'");
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            throw new RuntimeDroolsException("Unable to resolve import '" + lastName + "'");
        }
        ParserContext parserContext = new ParserContext(resolvedImports, null, this.name);
        parserContext.getParserConfiguration().setClassLoader(classLoader);
        for (String pkgImport : this.pkgImports) {
            parserContext.addPackageImport(pkgImport);
        }
        parserContext.setInterceptors(interceptors);
        parserContext.setStrongTyping(this.strictMode);
        this.resolvedInputs = new HashMap<String, Class>(this.inputIdentifiers.length);
        parserContext.addInput("drools", KnowledgeHelper.class);
        this.resolvedInputs.put("drools", KnowledgeHelper.class);
        String lastIdentifier = null;
        String lastType = null;
        try {
            int length = this.inputIdentifiers.length;
            for (int i = 0; i < length; ++i) {
                lastIdentifier = this.inputIdentifiers[i];
                lastType = this.inputTypes[i];
                Class cls = this.loadClass(classLoader, this.inputTypes[i]);
                this.resolvedInputs.put(this.inputIdentifiers[i], cls);
                parserContext.addInput(this.inputIdentifiers[i], cls);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeDroolsException("Unable to resolve class '" + lastType + "' for identifier '" + lastIdentifier);
        }
        if (parserContext.getInputs().get("kcontext") == null) {
            parserContext.addInput("kcontext", RuleContext.class);
            this.resolvedInputs.put("kcontext", RuleContext.class);
        }
        return this.compile(this.expression, classLoader, parserContext, this.languageLevel);
    }

    public DroolsMVELFactory getFactory() {
        HashMap<String, Class> resolvedGlobals = null;
        if (this.inputIdentifiers != null) {
            resolvedGlobals = new HashMap<String, Class>(this.inputIdentifiers.length);
            for (String identifier : this.globalIdentifiers) {
                resolvedGlobals.put(identifier, this.resolvedInputs.get(identifier));
            }
        }
        HashMap<String, Declaration> previousDeclarationsMap = null;
        if (this.previousDeclarations != null) {
            previousDeclarationsMap = new HashMap<String, Declaration>(this.previousDeclarations.length);
            for (Declaration declr : this.previousDeclarations) {
                previousDeclarationsMap.put(declr.getIdentifier(), declr);
            }
        }
        HashMap<String, Declaration> localDeclarationsMap = null;
        if (this.localDeclarations != null) {
            localDeclarationsMap = new HashMap<String, Declaration>(this.localDeclarations.length);
            for (Declaration declr : this.localDeclarations) {
                localDeclarationsMap.put(declr.getIdentifier(), declr);
            }
        }
        DroolsMVELFactory factory = null;
        if (this.shadowIdentifiers == null) {
            factory = new DroolsMVELFactory(previousDeclarationsMap, localDeclarationsMap, resolvedGlobals, this.inputIdentifiers);
        } else {
            HashSet<String> set = new HashSet<String>(this.shadowIdentifiers.length);
            for (String string : this.shadowIdentifiers) {
                set.add(string);
            }
            factory = new DroolsMVELShadowFactory(previousDeclarationsMap, localDeclarationsMap, resolvedGlobals, this.inputIdentifiers, set);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable compile(String text, ClassLoader classLoader, ParserContext parserContext, int languageLevel) {
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        ExpressionCompiler compiler = new ExpressionCompiler(text.trim());
        if (MVELDebugHandler.isDebugMode()) {
            parserContext.setDebugSymbols(true);
        }
        Object object = COMPILER_LOCK;
        synchronized (object) {
            ClassLoader tempClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            AbstractParser.setLanguageLevel(languageLevel);
            CompiledExpression expr = null;
            try {
                expr = compiler.compile(parserContext);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tempClassLoader);
            }
            return expr;
        }
    }

    private Class loadClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        Class<?> cls = primitivesMap.get(className);
        if (cls == null) {
            cls = classLoader.loadClass(className);
        }
        return cls;
    }

    static {
        interceptors.put("Modify", new ModifyInterceptor());
        DataConversion.addConversionHandler(Date.class, new MVELDateCoercion());
        DataConversion.addConversionHandler(Calendar.class, new MVELCalendarCoercion());
        primitivesMap = new HashMap<String, Class>();
        primitivesMap.put("int", Integer.TYPE);
        primitivesMap.put("boolean", Boolean.TYPE);
        primitivesMap.put("float", Float.TYPE);
        primitivesMap.put("long", Long.TYPE);
        primitivesMap.put("short", Short.TYPE);
        primitivesMap.put("byte", Byte.TYPE);
        primitivesMap.put("double", Double.TYPE);
        primitivesMap.put("char", Character.TYPE);
        COMPILER_LOCK = new Object();
    }
}

