/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.mvel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.drools.WorkingMemory;
import org.drools.base.mvel.DroolsMVELFactory;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.base.mvel.MVELCompileable;
import org.drools.base.mvel.MVELDebugHandler;
import org.drools.common.InternalRuleBase;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.Package;
import org.drools.spi.Consequence;
import org.drools.spi.KnowledgeHelper;
import org.mvel2.MVEL;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.integration.VariableResolverFactory;

public class MVELConsequence
implements Consequence,
MVELCompileable,
Externalizable {
    private static final long serialVersionUID = 400L;
    private MVELCompilationUnit unit;
    private String id;
    private Serializable expr;
    private DroolsMVELFactory prototype;

    public MVELConsequence() {
    }

    public MVELConsequence(MVELCompilationUnit unit, String id) {
        this.unit = unit;
        this.id = id;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.unit = (MVELCompilationUnit)in.readObject();
        this.id = in.readUTF();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.unit);
        out.writeUTF(this.id);
    }

    public void compile(ClassLoader classLoader) {
        this.expr = this.unit.getCompiledExpression(classLoader);
        this.prototype = this.unit.getFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
        DroolsMVELFactory factory = (DroolsMVELFactory)this.prototype.clone();
        factory.setContext(knowledgeHelper.getTuple(), knowledgeHelper, null, workingMemory, null);
        Package pkg = workingMemory.getRuleBase().getPackage("MAIN");
        if (pkg != null) {
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData(this.id);
            factory.setNextFactory(data.getFunctionFactory());
        }
        CompiledExpression compexpr = (CompiledExpression)this.expr;
        pkg = knowledgeHelper.getWorkingMemory().getRuleBase().getPackage(knowledgeHelper.getRule().getPackage());
        ClassLoader tempClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((InternalRuleBase)workingMemory.getRuleBase()).getRootClassLoader());
        try {
            if (MVELDebugHandler.isDebugMode()) {
                MVEL.executeDebugger(compexpr, null, factory);
            } else {
                MVEL.executeExpression((Object)compexpr, null, (VariableResolverFactory)factory);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tempClassLoader);
        }
    }

    public Serializable getCompExpr() {
        return this.expr;
    }
}

