/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.mvel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.drools.WorkingMemory;
import org.drools.base.mvel.DroolsMVELFactory;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.base.mvel.MVELCompileable;
import org.drools.rule.Declaration;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.Package;
import org.drools.spi.EvalExpression;
import org.drools.spi.Tuple;
import org.mvel2.MVEL;
import org.mvel2.integration.VariableResolverFactory;

public class MVELEvalExpression
implements EvalExpression,
MVELCompileable,
Externalizable {
    private static final long serialVersionUID = 400L;
    private MVELCompilationUnit unit;
    private String id;
    private Serializable expr;
    private DroolsMVELFactory prototype;

    public MVELEvalExpression() {
    }

    public MVELEvalExpression(MVELCompilationUnit unit, String id) {
        this.unit = unit;
        this.id = id;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.unit = (MVELCompilationUnit)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeObject(this.unit);
    }

    public void compile(ClassLoader classLoader) {
        this.expr = this.unit.getCompiledExpression(classLoader);
        this.prototype = this.unit.getFactory();
    }

    public Object createContext() {
        return this.prototype.clone();
    }

    public boolean evaluate(Tuple tuple, Declaration[] requiredDeclarations, WorkingMemory workingMemory, Object context) throws Exception {
        DroolsMVELFactory factory = (DroolsMVELFactory)context;
        factory.setContext(tuple, null, null, workingMemory, null);
        Package pkg = workingMemory.getRuleBase().getPackage("MAIN");
        if (pkg != null) {
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData(this.id);
            factory.setNextFactory(data.getFunctionFactory());
        }
        Boolean result = (Boolean)MVEL.executeExpression((Object)this.expr, new Object(), (VariableResolverFactory)factory);
        return result;
    }

    public String toString() {
        return this.unit.getExpression();
    }
}

