/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.WorkingMemory;
import org.drools.base.DefaultKnowledgeHelper;
import org.drools.base.SequentialKnowledgeHelper;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.ActivationGroupImpl;
import org.drools.common.ActivationGroupNode;
import org.drools.common.AgendaGroupFactory;
import org.drools.common.AgendaItem;
import org.drools.common.EventFactHandle;
import org.drools.common.EventSupport;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalAgendaGroup;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalRuleFlowGroup;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.LogicalDependency;
import org.drools.common.RuleFlowGroupImpl;
import org.drools.common.RuleFlowGroupListener;
import org.drools.common.RuleFlowGroupNode;
import org.drools.common.ScheduledAgendaItem;
import org.drools.common.Scheduler;
import org.drools.event.rule.ActivationCancelledCause;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.process.instance.ProcessInstance;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.rule.Declaration;
import org.drools.runtime.rule.Activation;
import org.drools.runtime.rule.ConsequenceExceptionHandler;
import org.drools.spi.ActivationGroup;
import org.drools.spi.AgendaFilter;
import org.drools.spi.AgendaGroup;
import org.drools.spi.ConsequenceException;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.PropagationContext;
import org.drools.spi.RuleFlowGroup;
import org.drools.util.ClassUtils;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAgenda
implements Externalizable,
InternalAgenda {
    private static final long serialVersionUID = 400L;
    private InternalWorkingMemory workingMemory;
    private LinkedList scheduledActivations;
    private Map<String, InternalAgendaGroup> agendaGroups;
    private Map<String, ActivationGroup> activationGroups;
    private Map<String, RuleFlowGroup> ruleFlowGroups;
    private java.util.LinkedList<AgendaGroup> focusStack;
    private InternalAgendaGroup currentModule;
    private InternalAgendaGroup main;
    private AgendaGroupFactory agendaGroupFactory;
    private KnowledgeHelper knowledgeHelper;
    public int activeActivations;
    public int dormantActivations;
    private org.drools.spi.ConsequenceExceptionHandler legacyConsequenceExceptionHandler;
    private ConsequenceExceptionHandler consequenceExceptionHandler;
    protected volatile AtomicBoolean halt = new AtomicBoolean(false);

    public DefaultAgenda() {
    }

    public DefaultAgenda(InternalRuleBase rb) {
        this(rb, true);
    }

    public DefaultAgenda(InternalRuleBase rb, boolean initMain) {
        Object object;
        this.agendaGroups = new HashMap<String, InternalAgendaGroup>();
        this.activationGroups = new HashMap<String, ActivationGroup>();
        this.ruleFlowGroups = new HashMap<String, RuleFlowGroup>();
        this.focusStack = new java.util.LinkedList();
        this.scheduledActivations = new LinkedList();
        this.agendaGroupFactory = rb.getConfiguration().getAgendaGroupFactory();
        if (initMain) {
            this.main = this.agendaGroupFactory.createAgendaGroup("MAIN", rb);
            this.agendaGroups.put("MAIN", this.main);
            this.focusStack.add(this.main);
        }
        if ((object = ClassUtils.instantiateObject(rb.getConfiguration().getConsequenceExceptionHandler(), rb.getConfiguration().getClassLoader())) instanceof org.drools.spi.ConsequenceExceptionHandler) {
            this.legacyConsequenceExceptionHandler = (org.drools.spi.ConsequenceExceptionHandler)object;
        } else {
            this.consequenceExceptionHandler = (ConsequenceExceptionHandler)object;
        }
    }

    @Override
    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        this.knowledgeHelper = ((InternalRuleBase)this.workingMemory.getRuleBase()).getConfiguration().isSequential() ? new SequentialKnowledgeHelper(this.workingMemory) : new DefaultKnowledgeHelper(this.workingMemory);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.workingMemory = (InternalWorkingMemory)in.readObject();
        this.scheduledActivations = (LinkedList)in.readObject();
        this.agendaGroups = (Map)in.readObject();
        this.activationGroups = (Map)in.readObject();
        this.ruleFlowGroups = (Map)in.readObject();
        this.focusStack = (java.util.LinkedList)in.readObject();
        this.currentModule = (InternalAgendaGroup)in.readObject();
        this.main = (InternalAgendaGroup)in.readObject();
        this.agendaGroupFactory = (AgendaGroupFactory)in.readObject();
        this.knowledgeHelper = (KnowledgeHelper)in.readObject();
        this.activeActivations = in.readInt();
        this.dormantActivations = in.readInt();
        this.legacyConsequenceExceptionHandler = (org.drools.spi.ConsequenceExceptionHandler)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.workingMemory);
        out.writeObject(this.scheduledActivations);
        out.writeObject(this.agendaGroups);
        out.writeObject(this.activationGroups);
        out.writeObject(this.ruleFlowGroups);
        out.writeObject(this.focusStack);
        out.writeObject(this.currentModule);
        out.writeObject(this.main);
        out.writeObject(this.agendaGroupFactory);
        out.writeObject(this.knowledgeHelper);
        out.writeInt(this.activeActivations);
        out.writeInt(this.dormantActivations);
        out.writeObject(this.legacyConsequenceExceptionHandler);
    }

    @Override
    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    @Override
    public void scheduleItem(ScheduledAgendaItem item) {
        Scheduler.scheduleAgendaItem(item, this);
        this.scheduledActivations.add(item);
        this.addItemToActivationGroup(item);
    }

    private void addItemToActivationGroup(AgendaItem item) {
        String group = item.getRule().getActivationGroup();
        if (group != null && group.length() > 0) {
            this.getActivationGroup(group).addActivation(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addActivation(AgendaItem activation) {
        if (activation.getRule().getAutoFocus()) {
            this.setFocus(activation.getRule().getAgendaGroup());
        }
        this.addItemToActivationGroup(activation);
        InternalAgendaGroup agendaGroup = (InternalAgendaGroup)this.getAgendaGroup(activation.getRule().getAgendaGroup());
        activation.setAgendaGroup(agendaGroup);
        if (activation.getRule().getRuleFlowGroup() == null) {
            if (activation.getPropagationContext().getType() == 2) {
                org.drools.spi.Activation justifier;
                if (activation.getRule().isLockOnActive() && agendaGroup.isActive()) {
                    justifier = activation.getPropagationContext().removeRetractedTuple(activation.getRule(), (LeftTuple)activation.getTuple());
                    if (justifier == null) {
                        return false;
                    }
                    if (activation.getRule().hasLogicalDependency()) {
                        this.copyLogicalDependencies(activation.getPropagationContext(), this.workingMemory, activation, justifier);
                    }
                } else if (activation.getRule().hasLogicalDependency()) {
                    justifier = activation.getPropagationContext().removeRetractedTuple(activation.getRule(), (LeftTuple)activation.getTuple());
                    this.copyLogicalDependencies(activation.getPropagationContext(), this.workingMemory, activation, justifier);
                }
            } else if (activation.getRule().isLockOnActive() && agendaGroup.isActive()) {
                return false;
            }
            agendaGroup.add(activation);
        } else {
            InternalRuleFlowGroup rfg = (InternalRuleFlowGroup)this.getRuleFlowGroup(activation.getRule().getRuleFlowGroup());
            if (activation.getPropagationContext().getType() == 2) {
                if (activation.getRule().isLockOnActive() && rfg.isActive()) {
                    org.drools.spi.Activation justifier = activation.getPropagationContext().removeRetractedTuple(activation.getRule(), (LeftTuple)activation.getTuple());
                    if (justifier == null) {
                        return false;
                    }
                    if (activation.getRule().hasLogicalDependency()) {
                        this.copyLogicalDependencies(activation.getPropagationContext(), this.workingMemory, activation, justifier);
                    }
                } else if (activation.getRule().hasLogicalDependency()) {
                    org.drools.spi.Activation justifier = activation.getPropagationContext().removeRetractedTuple(activation.getRule(), (LeftTuple)activation.getTuple());
                    this.copyLogicalDependencies(activation.getPropagationContext(), this.workingMemory, activation, justifier);
                }
            } else if (activation.getRule().isLockOnActive() && rfg.isActive()) {
                return false;
            }
            rfg.addActivation(activation);
        }
        AtomicBoolean atomicBoolean = this.halt;
        synchronized (atomicBoolean) {
            this.halt.notifyAll();
        }
        return true;
    }

    private void copyLogicalDependencies(PropagationContext context, InternalWorkingMemory workingMemory, AgendaItem item, org.drools.spi.Activation justifier) {
        LinkedList list;
        if (justifier != null && (list = justifier.getLogicalDependencies()) != null && !list.isEmpty()) {
            for (LogicalDependency node = (LogicalDependency)list.getFirst(); node != null; node = (LogicalDependency)node.getNext()) {
                InternalFactHandle handle = (InternalFactHandle)node.getFactHandle();
                workingMemory.getTruthMaintenanceSystem().addLogicalDependency(handle, item, context, item.getRule());
            }
        }
    }

    @Override
    public void removeScheduleItem(ScheduledAgendaItem item) {
        this.scheduledActivations.remove(item);
        Scheduler.removeAgendaItem(item, this);
    }

    @Override
    public void addAgendaGroup(AgendaGroup agendaGroup) {
        this.agendaGroups.put(agendaGroup.getName(), (InternalAgendaGroup)agendaGroup);
    }

    public boolean setFocus(AgendaGroup agendaGroup) {
        if (this.focusStack.getLast() != agendaGroup) {
            ((InternalAgendaGroup)this.focusStack.getLast()).setActive(false);
            this.focusStack.add(agendaGroup);
            ((InternalAgendaGroup)agendaGroup).setActive(true);
            EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
            eventsupport.getAgendaEventSupport().fireAgendaGroupPushed(agendaGroup, this.workingMemory);
            return true;
        }
        return false;
    }

    @Override
    public void setFocus(String name) {
        AgendaGroup agendaGroup = this.getAgendaGroup(name);
        this.setFocus(agendaGroup);
    }

    public AgendaGroup getFocus() {
        return this.focusStack.getLast();
    }

    public AgendaGroup getNextFocus() {
        boolean empty;
        InternalAgendaGroup agendaGroup = null;
        while ((empty = (agendaGroup = (InternalAgendaGroup)this.focusStack.getLast()).isEmpty()) && this.focusStack.size() > 1) {
            agendaGroup.setActive(false);
            this.focusStack.removeLast();
            EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
            eventsupport.getAgendaEventSupport().fireAgendaGroupPopped(agendaGroup, this.workingMemory);
        }
        agendaGroup = empty ? null : agendaGroup;
        if (agendaGroup != null) {
            agendaGroup.setActive(true);
        }
        return agendaGroup;
    }

    public void setCurrentAgendaGroup(InternalAgendaGroup agendaGroup) {
        this.currentModule = agendaGroup;
    }

    public AgendaGroup getCurrentAgendaGroup() {
        return this.currentModule;
    }

    @Override
    public AgendaGroup getAgendaGroup(String name) {
        String groupName = name == null || name.length() == 0 ? "MAIN" : name;
        AgendaGroup agendaGroup = this.agendaGroups.get(groupName);
        if (agendaGroup == null) {
            agendaGroup = this.agendaGroupFactory.createAgendaGroup(name, (InternalRuleBase)this.workingMemory.getRuleBase());
            this.addAgendaGroup(agendaGroup);
        }
        return agendaGroup;
    }

    @Override
    public AgendaGroup[] getAgendaGroups() {
        return this.agendaGroups.values().toArray(new AgendaGroup[this.agendaGroups.size()]);
    }

    public Map<String, InternalAgendaGroup> getAgendaGroupsMap() {
        return this.agendaGroups;
    }

    public InternalAgendaGroup getMainAgendaGroup() {
        if (this.main == null) {
            this.main = (InternalAgendaGroup)this.getAgendaGroup("MAIN");
        }
        return this.main;
    }

    @Override
    public AgendaGroup[] getStack() {
        return this.focusStack.toArray(new AgendaGroup[this.focusStack.size()]);
    }

    public java.util.LinkedList<AgendaGroup> getStackList() {
        return this.focusStack;
    }

    public Map<String, RuleFlowGroup> getRuleFlowGroupsMap() {
        return this.ruleFlowGroups;
    }

    public Map<String, ActivationGroup> getActivationGroupsMap() {
        return this.activationGroups;
    }

    @Override
    public ActivationGroup getActivationGroup(String name) {
        ActivationGroupImpl activationGroup = (ActivationGroupImpl)this.activationGroups.get(name);
        if (activationGroup == null) {
            activationGroup = new ActivationGroupImpl(name);
            this.activationGroups.put(name, activationGroup);
        }
        return activationGroup;
    }

    @Override
    public RuleFlowGroup getRuleFlowGroup(String name) {
        RuleFlowGroup ruleFlowGroup = this.ruleFlowGroups.get(name);
        if (ruleFlowGroup == null) {
            ruleFlowGroup = new RuleFlowGroupImpl(name);
            ((InternalRuleFlowGroup)ruleFlowGroup).setWorkingMemory((InternalWorkingMemory)this.getWorkingMemory());
            this.ruleFlowGroups.put(name, ruleFlowGroup);
        }
        return ruleFlowGroup;
    }

    @Override
    public void activateRuleFlowGroup(String name) {
        ((InternalRuleFlowGroup)this.getRuleFlowGroup(name)).setActive(true);
    }

    @Override
    public void deactivateRuleFlowGroup(String name) {
        ((InternalRuleFlowGroup)this.getRuleFlowGroup(name)).setActive(false);
    }

    @Override
    public int focusStackSize() {
        int size = 0;
        for (AgendaGroup group : this.focusStack) {
            size += group.size();
        }
        return size;
    }

    @Override
    public int agendaSize() {
        int size = 0;
        for (AgendaGroup agendaGroup : this.agendaGroups.values()) {
            size += agendaGroup.size();
        }
        return size;
    }

    @Override
    public org.drools.spi.Activation[] getActivations() {
        ArrayList<Activation> list = new ArrayList<Activation>();
        for (AgendaGroup agendaGroup : this.agendaGroups.values()) {
            list.addAll(Arrays.asList(agendaGroup.getActivations()));
        }
        return list.toArray(new org.drools.spi.Activation[list.size()]);
    }

    @Override
    public org.drools.spi.Activation[] getScheduledActivations() {
        ArrayList<LinkedListNode> list = new ArrayList<LinkedListNode>(this.scheduledActivations.size());
        for (LinkedListNode node = this.scheduledActivations.getFirst(); node != null; node = node.getNext()) {
            list.add(node);
        }
        return list.toArray(new org.drools.spi.Activation[list.size()]);
    }

    @Override
    public LinkedList getScheduledActivationsLinkedList() {
        return this.scheduledActivations;
    }

    @Override
    public void clear() {
        this.focusStack.clear();
        this.focusStack.add(this.getMainAgendaGroup());
        if (!this.scheduledActivations.isEmpty()) {
            ScheduledAgendaItem item = (ScheduledAgendaItem)this.scheduledActivations.removeFirst();
            while (item != null) {
                Scheduler.removeAgendaItem(item, this);
                item = (ScheduledAgendaItem)this.scheduledActivations.removeFirst();
            }
        }
        for (InternalAgendaGroup internalAgendaGroup : this.agendaGroups.values()) {
            internalAgendaGroup.clear();
        }
        for (RuleFlowGroup ruleFlowGroup : this.ruleFlowGroups.values()) {
            ruleFlowGroup.clear();
        }
        for (ActivationGroup activationGroup : this.activationGroups.values()) {
            activationGroup.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clearAndCancel() {
        for (AgendaGroup agendaGroup : this.agendaGroups.values()) {
            this.clearAndCancelAgendaGroup(agendaGroup);
        }
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        if (!this.scheduledActivations.isEmpty()) {
            void var2_4;
            ScheduledAgendaItem scheduledAgendaItem = (ScheduledAgendaItem)this.scheduledActivations.removeFirst();
            while (var2_4 != null) {
                Scheduler.removeAgendaItem((ScheduledAgendaItem)var2_4, this);
                eventsupport.getAgendaEventSupport().fireActivationCancelled((org.drools.spi.Activation)var2_4, this.workingMemory, ActivationCancelledCause.CLEAR);
                ScheduledAgendaItem scheduledAgendaItem2 = (ScheduledAgendaItem)this.scheduledActivations.removeFirst();
            }
        }
        for (RuleFlowGroup ruleFlowGroup : this.ruleFlowGroups.values()) {
            this.clearAndCancelAndCancel(ruleFlowGroup);
        }
        for (ActivationGroup activationGroup : this.activationGroups.values()) {
            this.clearAndCancelActivationGroup(activationGroup);
        }
    }

    @Override
    public void clearAndCancelAgendaGroup(String name) {
        AgendaGroup agendaGroup = this.agendaGroups.get(name);
        if (agendaGroup != null) {
            this.clearAndCancelAgendaGroup(agendaGroup);
        }
    }

    @Override
    public void clearAndCancelAgendaGroup(AgendaGroup agendaGroup) {
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        org.drools.spi.Activation[] queueable = ((InternalAgendaGroup)agendaGroup).getQueue();
        int length = queueable.length;
        for (int i = 0; i < length; ++i) {
            AgendaItem item = (AgendaItem)queueable[i];
            if (item == null) continue;
            item.setActivated(false);
            if (item.getActivationGroupNode() != null) {
                item.getActivationGroupNode().getActivationGroup().removeActivation(item);
            }
            if (item.getRuleFlowGroupNode() != null) {
                InternalRuleFlowGroup ruleFlowGroup = item.getRuleFlowGroupNode().getRuleFlowGroup();
                ruleFlowGroup.removeActivation(item);
            }
            eventsupport.getAgendaEventSupport().fireActivationCancelled(item, this.workingMemory, ActivationCancelledCause.CLEAR);
        }
        ((InternalAgendaGroup)agendaGroup).clear();
    }

    @Override
    public void clearAndCancelActivationGroup(String name) {
        ActivationGroup activationGroup = this.activationGroups.get(name);
        if (activationGroup != null) {
            this.clearAndCancelActivationGroup(activationGroup);
        }
    }

    @Override
    public void clearAndCancelActivationGroup(ActivationGroup activationGroup) {
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        Iterator it = activationGroup.iterator();
        while (it.hasNext()) {
            ActivationGroupNode node = (ActivationGroupNode)it.next();
            org.drools.spi.Activation activation = node.getActivation();
            activation.setActivationGroupNode(null);
            if (!activation.isActivated()) continue;
            activation.setActivated(false);
            activation.remove();
            if (activation.getRuleFlowGroupNode() != null) {
                InternalRuleFlowGroup ruleFlowGroup = activation.getRuleFlowGroupNode().getRuleFlowGroup();
                ruleFlowGroup.removeActivation(activation);
            }
            eventsupport.getAgendaEventSupport().fireActivationCancelled(activation, this.workingMemory, ActivationCancelledCause.CLEAR);
        }
        activationGroup.clear();
    }

    @Override
    public void clearAndCancelRuleFlowGroup(String name) {
        RuleFlowGroup ruleFlowGrlup = this.ruleFlowGroups.get(name);
        if (ruleFlowGrlup != null) {
            this.clearAndCancelAndCancel(ruleFlowGrlup);
        }
    }

    @Override
    public void clearAndCancelAndCancel(RuleFlowGroup ruleFlowGroup) {
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        Iterator<RuleFlowGroupNode> it = ruleFlowGroup.iterator();
        while (it.hasNext()) {
            RuleFlowGroupNode node = it.next();
            AgendaItem item = (AgendaItem)node.getActivation();
            if (item != null) {
                item.setActivated(false);
                item.remove();
                if (item.getActivationGroupNode() != null) {
                    item.getActivationGroupNode().getActivationGroup().removeActivation(item);
                }
            }
            eventsupport.getAgendaEventSupport().fireActivationCancelled(item, this.workingMemory, ActivationCancelledCause.CLEAR);
        }
        ((InternalRuleFlowGroup)ruleFlowGroup).clear();
        if (ruleFlowGroup.isActive() && ruleFlowGroup.isAutoDeactivate()) {
            RuleFlowGroupImpl.DeactivateCallback action = new RuleFlowGroupImpl.DeactivateCallback((InternalRuleFlowGroup)ruleFlowGroup);
            this.workingMemory.queueWorkingMemoryAction(action);
        }
    }

    @Override
    public boolean fireNextItem(AgendaFilter filter) throws ConsequenceException {
        boolean result;
        boolean tryagain;
        do {
            AgendaItem item;
            result = false;
            tryagain = false;
            InternalAgendaGroup group = (InternalAgendaGroup)this.getNextFocus();
            if (group == null || (item = (AgendaItem)group.getNext()) == null) continue;
            if (filter == null || filter.accept(item)) {
                this.fireActivation(item);
                result = true;
                continue;
            }
            EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
            eventsupport.getAgendaEventSupport().fireActivationCancelled(item, this.workingMemory, ActivationCancelledCause.FILTER);
            tryagain = true;
        } while (tryagain);
        return result;
    }

    @Override
    public synchronized void fireActivation(org.drools.spi.Activation activation) throws ConsequenceException {
        InternalRuleFlowGroup ruleFlowGroup;
        this.increaseDormantActivations();
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        eventsupport.getAgendaEventSupport().fireBeforeActivationFired(activation, this.workingMemory);
        if (activation.getActivationGroupNode() != null) {
            ActivationGroup activationGroup = activation.getActivationGroupNode().getActivationGroup();
            activationGroup.removeActivation(activation);
            this.clearAndCancelActivationGroup(activationGroup);
        }
        activation.setActivated(false);
        try {
            this.knowledgeHelper.setActivation(activation);
            activation.getRule().getConsequence().evaluate(this.knowledgeHelper, this.workingMemory);
            this.knowledgeHelper.reset();
        }
        catch (Exception e) {
            if (this.legacyConsequenceExceptionHandler != null) {
                this.legacyConsequenceExceptionHandler.handleException(activation, this.workingMemory, e);
            }
            if (this.consequenceExceptionHandler != null) {
                this.consequenceExceptionHandler.handleException(activation, new StatefulKnowledgeSessionImpl((ReteooWorkingMemory)this.workingMemory), e);
            }
            throw new RuntimeException(e);
        }
        if (activation.getRuleFlowGroupNode() != null && (ruleFlowGroup = activation.getRuleFlowGroupNode().getRuleFlowGroup()).isActive()) {
            ruleFlowGroup.removeActivation(activation);
        }
        for (LeftTuple tuple = (LeftTuple)activation.getTuple(); tuple != null; tuple = tuple.getParent()) {
            EventFactHandle handle;
            if (!tuple.getLastHandle().isEvent() || !(handle = (EventFactHandle)tuple.getLastHandle()).isExpired()) continue;
            handle.decreaseActivationsCount();
            if (handle.getActivationsCount() != 0L) continue;
            handle.getEntryPoint().retract(handle);
        }
        eventsupport.getAgendaEventSupport().fireAfterActivationFired(activation, this.workingMemory);
    }

    @Override
    public void increaseActiveActivations() {
        ++this.activeActivations;
    }

    @Override
    public void decreaseActiveActivations() {
        --this.activeActivations;
    }

    @Override
    public void increaseDormantActivations() {
        --this.activeActivations;
        ++this.dormantActivations;
    }

    @Override
    public void decreaseDormantActivations() {
        --this.dormantActivations;
    }

    @Override
    public int getActiveActivations() {
        return this.activeActivations;
    }

    @Override
    public int getDormantActivations() {
        return this.dormantActivations;
    }

    @Override
    public boolean isRuleActiveInRuleFlowGroup(String ruleflowGroupName, String ruleName, long processInstanceId) {
        RuleFlowGroup systemRuleFlowGroup = this.getRuleFlowGroup(ruleflowGroupName);
        Iterator<RuleFlowGroupNode> activations = systemRuleFlowGroup.iterator();
        while (activations.hasNext()) {
            org.drools.spi.Activation activation = activations.next().getActivation();
            if (!ruleName.equals(activation.getRule().getName()) || !this.checkProcessInstance(activation, processInstanceId)) continue;
            return true;
        }
        return false;
    }

    private boolean checkProcessInstance(org.drools.spi.Activation activation, long processInstanceId) {
        Map declarations = activation.getSubRule().getOuterDeclarations();
        for (Declaration declaration : declarations.values()) {
            Object value;
            if (!"processInstance".equals(declaration.getIdentifier()) || !((value = declaration.getValue(this.workingMemory, activation.getTuple().get(declaration).getObject())) instanceof ProcessInstance)) continue;
            return ((ProcessInstance)value).getId() == processInstanceId;
        }
        return true;
    }

    @Override
    public void addRuleFlowGroupListener(String ruleFlowGroup, RuleFlowGroupListener listener) {
        InternalRuleFlowGroup rfg = (InternalRuleFlowGroup)this.getRuleFlowGroup(ruleFlowGroup);
        rfg.addRuleFlowGroupListener(listener);
    }

    @Override
    public void removeRuleFlowGroupListener(String ruleFlowGroup, RuleFlowGroupListener listener) {
        InternalRuleFlowGroup rfg = (InternalRuleFlowGroup)this.getRuleFlowGroup(ruleFlowGroup);
        rfg.removeRuleFlowGroupListener(listener);
    }

    @Override
    public String getFocusName() {
        return this.getFocus().getName();
    }

    @Override
    public void fireUntilHalt() {
        this.fireUntilHalt(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireUntilHalt(AgendaFilter agendaFilter) {
        this.halt.set(false);
        while (this.continueFiring(-1)) {
            boolean fired = this.fireNextItem(agendaFilter);
            fired = fired || !((AbstractWorkingMemory)this.workingMemory).getActionQueue().isEmpty();
            this.workingMemory.executeQueuedActions();
            if (!fired) {
                try {
                    AtomicBoolean atomicBoolean = this.halt;
                    synchronized (atomicBoolean) {
                        this.halt.wait();
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    this.halt.set(true);
                    continue;
                }
            }
            this.workingMemory.executeQueuedActions();
        }
    }

    @Override
    public int fireAllRules(AgendaFilter agendaFilter, int fireLimit) {
        this.halt.set(false);
        int fireCount = 0;
        while (this.continueFiring(fireLimit) && this.fireNextItem(agendaFilter)) {
            ++fireCount;
            fireLimit = this.updateFireLimit(fireLimit);
            this.workingMemory.executeQueuedActions();
        }
        if (this.focusStack.size() == 1 && this.getMainAgendaGroup().isEmpty()) {
            this.getMainAgendaGroup().setActive(false);
        }
        return fireCount;
    }

    private final boolean continueFiring(int fireLimit) {
        return !this.halt.get() && fireLimit != 0;
    }

    private final int updateFireLimit(int fireLimit) {
        return fireLimit > 0 ? fireLimit - 1 : fireLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyHalt() {
        AtomicBoolean atomicBoolean = this.halt;
        synchronized (atomicBoolean) {
            this.halt.notifyAll();
        }
    }

    @Override
    public void halt() {
        this.halt.set(true);
        this.notifyHalt();
    }

    public org.drools.spi.ConsequenceExceptionHandler getConsequenceExceptionHandler() {
        return this.legacyConsequenceExceptionHandler;
    }
}

