/*
 * Decompiled with CFR 0.152.
 */
package org.drools.contrib;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.RuntimeDroolsException;
import org.drools.builder.DecisionTableConfiguration;
import org.drools.builder.DecisionTableInputType;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.drools.definition.KnowledgePackage;
import org.drools.guvnor.client.modeldriven.brl.RuleModel;
import org.drools.guvnor.server.util.BRDRLPersistence;
import org.drools.guvnor.server.util.BRXMLPersistence;
import org.drools.io.ResourceFactory;
import org.drools.lang.dsl.DSLMappingFile;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.drools.lang.dsl.DefaultExpander;
import org.drools.lang.dsl.DefaultExpanderResolver;
import org.drools.rule.Package;
import org.drools.util.DroolsStreamUtils;

public class DroolsCompilerAntTask
extends MatchingTask {
    public static String BRLFILEEXTENSION = ".brl";
    public static String XMLFILEEXTENSION = ".xml";
    public static String RULEFLOWMODELFILEEXTENSION = ".rfm";
    public static String RULEFLOWFILEEXTENSION = ".rf";
    public static String DSLFILEEXTENSION = ".dsl";
    public static String DSLRFILEEXTENSION = ".dslr";
    public static String XLSFILEEXTENSION = ".xls";
    public static String PACKAGEBINFORMAT = "package";
    public static String PACKAGEBINTYPE = "knowledge";
    private File srcdir;
    private File toFile;
    private Path classpath;
    private String binformat;
    private String bintype;

    public void setSrcDir(File directory) {
        this.srcdir = directory;
    }

    public void setToFile(File toFile) {
        this.toFile = toFile;
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public void setClasspathref(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void execute() throws BuildException {
        super.execute();
        if (this.toFile == null) {
            throw new BuildException("Destination rulebase file does not specified.");
        }
        if (this.srcdir == null) {
            throw new BuildException("Source directory not specified.");
        }
        if (!this.srcdir.exists()) {
            throw new BuildException("Source directory does not exists." + this.srcdir.getAbsolutePath());
        }
        AntClassLoader loader = null;
        try {
            loader = this.getClassLoader();
            if (PACKAGEBINTYPE.equals(this.bintype)) {
                this.createWithKnowledgeBuilder(loader);
            } else {
                this.createWithPackageBuilder(loader);
            }
        }
        catch (Exception e) {
            throw new BuildException("RuleBaseTask failed: " + e.getMessage(), e);
        }
        finally {
            if (loader != null) {
                loader.resetThreadContextLoader();
            }
        }
    }

    private void createWithKnowledgeBuilder(AntClassLoader loader) throws FileNotFoundException, DroolsParserException, IOException {
        KnowledgeBuilder kbuilder = this.getKnowledgeBuilder(loader);
        String[] fileNames = this.getFileList();
        for (int i = 0; i < fileNames.length; ++i) {
            this.compileAndAddFile(kbuilder, fileNames[i]);
        }
        if (kbuilder.hasErrors()) {
            System.err.println(kbuilder.getErrors().toString());
        }
        Collection<KnowledgePackage> pkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        if (PACKAGEBINFORMAT.equals(this.binformat)) {
            this.serializeObject(pkgs.iterator().next());
        } else {
            this.serializeObject(kbase);
        }
    }

    private void createWithPackageBuilder(AntClassLoader loader) throws FileNotFoundException, DroolsParserException, IOException {
        PackageBuilder builder = this.getPackageBuilder(loader);
        String[] fileNames = this.getFileList();
        for (int i = 0; i < fileNames.length; ++i) {
            this.compileAndAddFile(builder, fileNames[i]);
        }
        if (builder.hasErrors()) {
            System.err.println(builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(pkg);
        if (PACKAGEBINFORMAT.equals(this.binformat)) {
            this.serializeObject(pkg);
        } else {
            this.serializeObject(ruleBase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeObject(Object object) throws FileNotFoundException, IOException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(this.toFile);
            DroolsStreamUtils.streamOut(fout, object);
        }
        finally {
            if (fout != null) {
                fout.close();
            }
        }
    }

    private void compileAndAddFile(KnowledgeBuilder kbuilder, String fileName) throws FileNotFoundException, DroolsParserException, IOException {
        FileReader fileReader = new FileReader(new File(this.srcdir, fileName));
        if (fileName.endsWith(BRLFILEEXTENSION)) {
            RuleModel model = BRXMLPersistence.getInstance().unmarshal(this.loadResource(fileName));
            String packagefile = this.loadResource(this.resolvePackageFile(this.srcdir.getAbsolutePath()));
            model.name = fileName.replace(BRLFILEEXTENSION, "");
            ByteArrayInputStream istream = new ByteArrayInputStream((packagefile + BRDRLPersistence.getInstance().marshal(model)).getBytes());
            InputStreamReader instream = new InputStreamReader(istream);
            kbuilder.add(ResourceFactory.newReaderResource(instream), ResourceType.DRL);
        } else if (fileName.endsWith(RULEFLOWMODELFILEEXTENSION) || fileName.endsWith(RULEFLOWFILEEXTENSION)) {
            kbuilder.add(ResourceFactory.newReaderResource(fileReader), ResourceType.DRF);
        } else if (fileName.endsWith(XMLFILEEXTENSION)) {
            kbuilder.add(ResourceFactory.newReaderResource(fileReader), ResourceType.XDRL);
        } else if (fileName.endsWith(XLSFILEEXTENSION)) {
            DecisionTableConfiguration dtableconfiguration = KnowledgeBuilderFactory.newDecisionTableConfiguration();
            dtableconfiguration.setInputType(DecisionTableInputType.XLS);
            kbuilder.add(ResourceFactory.newReaderResource(fileReader), ResourceType.DTABLE, dtableconfiguration);
        } else if (fileName.endsWith(DSLRFILEEXTENSION)) {
            String[] dsls = this.resolveDSLFilesToArray();
            for (int i = 0; i < dsls.length; ++i) {
                kbuilder.add(ResourceFactory.newFileResource(new File(this.srcdir, dsls[i])), ResourceType.DSL);
            }
            kbuilder.add(ResourceFactory.newReaderResource(fileReader), ResourceType.DSLR);
        } else {
            kbuilder.add(ResourceFactory.newReaderResource(fileReader), ResourceType.DRL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileAndAddFile(PackageBuilder builder, String fileName) throws FileNotFoundException, DroolsParserException, IOException {
        InputStreamReader instream = null;
        File file = new File(this.srcdir, fileName);
        try {
            if (fileName.endsWith(BRLFILEEXTENSION)) {
                RuleModel model = BRXMLPersistence.getInstance().unmarshal(this.loadResource(fileName));
                String packagefile = this.loadResource(this.resolvePackageFile(this.srcdir.getAbsolutePath()));
                model.name = fileName.replace(BRLFILEEXTENSION, "");
                ByteArrayInputStream istream = new ByteArrayInputStream((packagefile + BRDRLPersistence.getInstance().marshal(model)).getBytes());
                instream = new InputStreamReader(istream);
            } else {
                instream = new InputStreamReader(new FileInputStream(file));
            }
            if (fileName.endsWith(RULEFLOWMODELFILEEXTENSION) || fileName.endsWith(RULEFLOWFILEEXTENSION)) {
                builder.addRuleFlow(instream);
            } else if (fileName.endsWith(XMLFILEEXTENSION)) {
                builder.addPackageFromXml(instream);
            } else if (fileName.endsWith(XLSFILEEXTENSION)) {
                SpreadsheetCompiler converter = new SpreadsheetCompiler();
                String drl = converter.compile((InputStream)new FileInputStream(file), InputType.XLS);
                System.out.println(drl);
                builder.addPackageFromDrl(new StringReader(drl));
            } else if (fileName.endsWith(DSLRFILEEXTENSION)) {
                DrlParser parser = new DrlParser();
                String expandedDRL = parser.getExpandedDRL(this.loadResource(fileName), this.resolveDSLFiles());
                builder.addPackageFromDrl(new StringReader(expandedDRL));
            } else {
                builder.addPackageFromDrl(instream);
            }
        }
        finally {
            if (instream != null) {
                instream.close();
            }
        }
    }

    private String[] resolveDSLFilesToArray() {
        ArrayList list = new ArrayList();
        File dir = new File(this.srcdir.getAbsolutePath());
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".dsl");
            }
        };
        return dir.list(filter);
    }

    private DefaultExpanderResolver resolveDSLFiles() throws IOException {
        DefaultExpanderResolver resolver = new DefaultExpanderResolver();
        File dir = new File(this.srcdir.getAbsolutePath());
        DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".dsl");
            }
        };
        String[] children = dir.list(filter);
        if (children.length == 0) {
            throw new BuildException("There are no DSL files for this directory:" + this.srcdir.getAbsolutePath());
        }
        for (int index = 0; index < children.length; ++index) {
            if (!((DSLMappingFile)file).parseAndLoad(new StringReader(this.loadResource(children[index])))) {
                throw new RuntimeDroolsException("Error parsing and loading DSL file." + file.getErrors());
            }
            DefaultExpander expander = new DefaultExpander();
            expander.addDSLMapping(file.getMapping());
            resolver.addExpander("*", expander);
        }
        return resolver;
    }

    private String resolvePackageFile(String dirname) {
        File dir = new File(dirname);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".package");
            }
        };
        String[] children = dir.list(filter);
        if (children.length > 1) {
            throw new BuildException("There are more than one package configuration file for this directory :" + dirname);
        }
        if (children.length == 0) {
            throw new BuildException("There is no package configuration file for this directory:" + dirname);
        }
        return children[0];
    }

    private String loadResource(String name) throws IOException {
        FileInputStream in = new FileInputStream(this.srcdir + "/" + name);
        InputStreamReader reader = new InputStreamReader(in);
        StringBuffer text = new StringBuffer();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text.toString();
    }

    private AntClassLoader getClassLoader() {
        AntClassLoader loader = null;
        loader = this.classpath != null ? new AntClassLoader(PackageBuilder.class.getClassLoader(), this.getProject(), this.classpath, false) : new AntClassLoader(PackageBuilder.class.getClassLoader(), false);
        loader.setThreadContextLoader();
        return loader;
    }

    private PackageBuilder getPackageBuilder(AntClassLoader loader) {
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration();
        conf.setClassLoader(loader);
        PackageBuilder builder = new PackageBuilder(conf);
        return builder;
    }

    private String[] getFileList() {
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.srcdir);
        String[] fileNames = directoryScanner.getIncludedFiles();
        if (fileNames == null || fileNames.length <= 0) {
            throw new BuildException("No rule files found in include directory.");
        }
        return fileNames;
    }

    private KnowledgeBuilder getKnowledgeBuilder(AntClassLoader loader) {
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration();
        conf.setClassLoader(loader);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder(conf);
        return kbuilder;
    }

    public void setBinformat(String binformat) {
        this.binformat = binformat;
    }

    public String getBinformat() {
        return this.binformat;
    }

    public String getBintype() {
        return this.bintype;
    }

    public void setBintype(String bintype) {
        this.bintype = bintype;
    }
}

