/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.builder;

import java.util.ArrayList;
import java.util.List;
import org.drools.InitialFact;
import org.drools.base.ClassObjectType;
import org.drools.common.BaseNode;
import org.drools.common.InternalRuleBase;
import org.drools.conf.EventProcessingOption;
import org.drools.reteoo.QueryTerminalNode;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.builder.AccumulateBuilder;
import org.drools.reteoo.builder.BuildContext;
import org.drools.reteoo.builder.BuildUtils;
import org.drools.reteoo.builder.CollectBuilder;
import org.drools.reteoo.builder.EntryPointBuilder;
import org.drools.reteoo.builder.EvalBuilder;
import org.drools.reteoo.builder.ForallBuilder;
import org.drools.reteoo.builder.FromBuilder;
import org.drools.reteoo.builder.GroupElementBuilder;
import org.drools.reteoo.builder.PatternBuilder;
import org.drools.reteoo.builder.ReteooComponentBuilder;
import org.drools.rule.Accumulate;
import org.drools.rule.Collect;
import org.drools.rule.EntryPoint;
import org.drools.rule.EvalCondition;
import org.drools.rule.Forall;
import org.drools.rule.From;
import org.drools.rule.GroupElement;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Pattern;
import org.drools.rule.Query;
import org.drools.rule.Rule;
import org.drools.time.TemporalDependencyMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReteooRuleBuilder {
    private BuildUtils utils = new BuildUtils();

    public ReteooRuleBuilder() {
        this.utils.addBuilder(GroupElement.class, new GroupElementBuilder());
        this.utils.addBuilder(Pattern.class, new PatternBuilder());
        this.utils.addBuilder(EvalCondition.class, new EvalBuilder());
        this.utils.addBuilder(From.class, new FromBuilder());
        this.utils.addBuilder(Collect.class, new CollectBuilder());
        this.utils.addBuilder(Accumulate.class, new AccumulateBuilder());
        this.utils.addBuilder(Forall.class, new ForallBuilder());
        this.utils.addBuilder(EntryPoint.class, new EntryPointBuilder());
    }

    public List<TerminalNode> addRule(Rule rule, InternalRuleBase rulebase, ReteooBuilder.IdGenerator idGenerator) throws InvalidPatternException {
        ArrayList<TerminalNode> nodes = new ArrayList<TerminalNode>();
        GroupElement[] subrules = rule.getTransformedLhs();
        for (int i = 0; i < subrules.length; ++i) {
            BuildContext context = new BuildContext(rulebase, idGenerator);
            context.setRule(rule);
            if (EventProcessingOption.STREAM.equals(rulebase.getConfiguration().getEventProcessingMode())) {
                TemporalDependencyMatrix temporal = this.utils.calculateTemporalDistance(subrules[i]);
                context.setTemporalDistance(temporal);
            }
            if (rulebase.getConfiguration().isSequential()) {
                context.setTupleMemoryEnabled(false);
                context.setObjectTypeNodeMemoryEnabled(false);
                context.setTerminalNodeMemoryEnabled(false);
                context.setAlphaNodeMemoryAllowed(false);
            } else {
                context.setTupleMemoryEnabled(true);
                context.setObjectTypeNodeMemoryEnabled(true);
                context.setTerminalNodeMemoryEnabled(true);
                context.setAlphaNodeMemoryAllowed(true);
            }
            TerminalNode node = this.addSubRule(context, subrules[i], rule);
            nodes.add(node);
        }
        return nodes;
    }

    private TerminalNode addSubRule(BuildContext context, GroupElement subrule, Rule rule) throws InvalidPatternException {
        ReteooComponentBuilder builder = this.utils.getBuilderFor(subrule);
        if (builder.requiresLeftActivation(this.utils, subrule)) {
            this.addInitialFactPattern(context, subrule, rule);
        }
        builder.build(context, this.utils, subrule);
        BaseNode terminal = null;
        terminal = !(rule instanceof Query) ? new RuleTerminalNode(context.getNextId(), context.getTupleSource(), rule, subrule, context) : new QueryTerminalNode(context.getNextId(), context.getTupleSource(), rule, subrule, context);
        if (context.getWorkingMemories().length == 0) {
            ((BaseNode)terminal).attach();
        } else {
            ((BaseNode)terminal).attach(context.getWorkingMemories());
        }
        ((BaseNode)terminal).networkUpdated();
        context.getNodes().add(terminal);
        return terminal;
    }

    private void addInitialFactPattern(BuildContext context, GroupElement subrule, Rule rule) {
        Pattern pattern = new Pattern(0, new ClassObjectType(InitialFact.class));
        subrule.addChild(0, pattern);
    }
}

