/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.base.mvel.MVELCompileable;
import org.drools.rule.CompositeClassLoader;
import org.drools.rule.DialectRuntimeData;
import org.drools.rule.DialectRuntimeRegistry;
import org.drools.rule.Function;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.spi.Wireable;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.impl.MapVariableResolverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVELDialectRuntimeData
implements DialectRuntimeData,
Externalizable {
    private MapFunctionResolverFactory functionFactory;
    private Map<Wireable, MVELCompileable> invokerLookups;
    private CompositeClassLoader rootClassLoader;
    private List<Wireable> wireList = Collections.emptyList();

    public MVELDialectRuntimeData() {
        this.functionFactory = new MapFunctionResolverFactory();
        this.invokerLookups = new HashMap<Wireable, MVELCompileable>();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.invokerLookups);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.invokerLookups = (Map)in.readObject();
        if (!this.invokerLookups.isEmpty()) {
            this.wireList = new ArrayList<Wireable>(this.invokerLookups.keySet());
        }
    }

    @Override
    public void merge(DialectRuntimeRegistry registry, DialectRuntimeData newData) {
        MVELDialectRuntimeData other = (MVELDialectRuntimeData)newData;
        for (Map.Entry<Wireable, MVELCompileable> entry : other.invokerLookups.entrySet()) {
            this.invokerLookups.put(entry.getKey(), entry.getValue());
            if (this.wireList == Collections.emptyList()) {
                this.wireList = new ArrayList<Wireable>();
            }
            this.wireList.add(entry.getKey());
        }
    }

    @Override
    public DialectRuntimeData clone(DialectRuntimeRegistry registry, CompositeClassLoader rootClassLoader) {
        MVELDialectRuntimeData clone = new MVELDialectRuntimeData();
        clone.merge(registry, this);
        clone.onAdd(registry, rootClassLoader);
        return clone;
    }

    @Override
    public void onAdd(DialectRuntimeRegistry registry, CompositeClassLoader rootClassLoader) {
        this.rootClassLoader = rootClassLoader;
    }

    @Override
    public void onRemove() {
    }

    @Override
    public void onBeforeExecute() {
        for (Wireable target : this.wireList) {
            MVELCompileable compileable = this.invokerLookups.get(target);
            compileable.compile(this.rootClassLoader);
            target.wire(compileable);
        }
        this.wireList.clear();
    }

    public MapFunctionResolverFactory getFunctionFactory() {
        return this.functionFactory;
    }

    @Override
    public void removeRule(Package pkg, Rule rule) {
    }

    public void addFunction(org.mvel2.ast.Function function) {
        this.functionFactory.addFunction(function);
    }

    @Override
    public void removeFunction(Package pkg, Function function) {
        this.functionFactory.removeFunction(function.getName());
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void setDirty(boolean dirty) {
    }

    @Override
    public void reload() {
    }

    public void addCompileable(Wireable wireable, MVELCompileable compilable) {
        this.invokerLookups.put(wireable, compilable);
    }

    public Map<Wireable, MVELCompileable> getLookup() {
        return this.invokerLookups;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapFunctionResolverFactory
    extends MapVariableResolverFactory
    implements Externalizable {
        public MapFunctionResolverFactory() {
            super(new HashMap());
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.variables);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.variables = (Map)in.readObject();
        }

        public void addFunction(org.mvel2.ast.Function function) {
            this.variables.put(function.getName(), function);
        }

        public void removeFunction(String functionName) {
            this.variables.remove(functionName);
            this.variableResolvers.remove(functionName);
        }

        @Override
        public VariableResolver createVariable(String name, Object value) {
            throw new RuntimeException("variable is a read-only function pointer");
        }

        @Override
        public VariableResolver createIndexedVariable(int index, String name, Object value, Class<?> type) {
            throw new RuntimeException("variable is a read-only function pointer");
        }
    }
}

