/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.drools.lang.descr.BaseDescr;
import org.drools.rule.Declaration;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.java.JavaDialect;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.util.StringUtils;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.templates.SimpleTemplateRegistry;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRegistry;
import org.mvel2.templates.TemplateRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractJavaRuleBuilder {
    protected static final TemplateRegistry RULE_REGISTRY = new SimpleTemplateRegistry();
    protected static final TemplateRegistry INVOKER_REGISTRY = new SimpleTemplateRegistry();

    public static TemplateRegistry getRuleTemplateRegistry() {
        return RULE_REGISTRY;
    }

    public static TemplateRegistry getInvokerTemplateRegistry() {
        return INVOKER_REGISTRY;
    }

    public Map<String, Object> createVariableContext(String className, String text, RuleBuildContext context, Declaration[] declarations, Declaration[] localDeclarations, String[] globals) {
        int i;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("methodName", className);
        map.put("package", context.getPkg().getName());
        map.put("ruleClassName", StringUtils.ucFirst(context.getRuleDescr().getClassName()));
        map.put("invokerClassName", context.getRuleDescr().getClassName() + StringUtils.ucFirst(className) + "Invoker");
        if (text != null) {
            map.put("text", text);
            map.put("hashCode", new Integer(text.hashCode()));
        }
        String[] declarationTypes = new String[declarations.length];
        int size = declarations.length;
        for (int i2 = 0; i2 < size; ++i2) {
            declarationTypes[i2] = ((JavaDialect)context.getDialect()).getTypeFixer().fix(declarations[i2]);
        }
        map.put("declarations", declarations);
        map.put("declarationTypes", declarationTypes);
        if (localDeclarations != null) {
            String[] localDeclarationTypes = new String[localDeclarations.length];
            int size2 = localDeclarations.length;
            for (i = 0; i < size2; ++i) {
                localDeclarationTypes[i] = ((JavaDialect)context.getDialect()).getTypeFixer().fix(localDeclarations[i]);
            }
            map.put("localDeclarations", localDeclarations);
            map.put("localDeclarationTypes", localDeclarationTypes);
        }
        ArrayList<String> globalTypes = new ArrayList<String>(globals.length);
        int length = globals.length;
        for (i = 0; i < length; ++i) {
            globalTypes.add(context.getPkg().getGlobals().get(globals[i]).replace('$', '.'));
        }
        map.put("globals", globals);
        map.put("globalTypes", globalTypes);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generatTemplates(String ruleTemplate, String invokerTemplate, RuleBuildContext context, String className, Map vars, Object invokerLookup, BaseDescr descrLookup) {
        Object object = MVELDialect.COMPILER_LOCK;
        synchronized (object) {
            AbstractParser.setLanguageLevel(5);
            TemplateRegistry registry = AbstractJavaRuleBuilder.getRuleTemplateRegistry();
            context.getMethods().add(TemplateRuntime.execute(registry.getNamedTemplate(ruleTemplate), null, (VariableResolverFactory)new MapVariableResolverFactory(vars), registry));
            registry = AbstractJavaRuleBuilder.getInvokerTemplateRegistry();
            String invokerClassName = context.getPkg().getName() + "." + context.getRuleDescr().getClassName() + StringUtils.ucFirst(className) + "Invoker";
            context.getInvokers().put(invokerClassName, TemplateRuntime.execute(registry.getNamedTemplate(invokerTemplate), null, (VariableResolverFactory)new MapVariableResolverFactory(vars), registry));
            context.getInvokerLookups().put(invokerClassName, invokerLookup);
            context.getDescrLookups().put(invokerClassName, descrLookup);
        }
    }

    static {
        OptimizerFactory.setDefaultOptimizer("reflective");
        RULE_REGISTRY.addNamedTemplate("rules", TemplateCompiler.compileTemplate(AbstractJavaRuleBuilder.class.getResourceAsStream("javaRule.mvel"), null));
        INVOKER_REGISTRY.addNamedTemplate("invokers", TemplateCompiler.compileTemplate(AbstractJavaRuleBuilder.class.getResourceAsStream("javaInvokers.mvel"), null));
        TemplateRuntime.execute(RULE_REGISTRY.getNamedTemplate("rules"), null, RULE_REGISTRY);
        TemplateRuntime.execute(INVOKER_REGISTRY.getNamedTemplate("invokers"), null, INVOKER_REGISTRY);
    }
}

