/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.base.TypeResolver;
import org.drools.compiler.FunctionError;
import org.drools.lang.descr.FunctionDescr;
import org.drools.rule.LineMappings;
import org.drools.rule.Package;
import org.drools.rule.builder.FunctionBuilder;
import org.drools.util.StringUtils;
import org.mvel2.integration.impl.MapVariableResolverFactory;
import org.mvel2.templates.TemplateRuntime;

public class JavaFunctionBuilder
implements FunctionBuilder {
    private static final String template = StringUtils.readFileAsString(new InputStreamReader(JavaFunctionBuilder.class.getResourceAsStream("javaFunction.mvel")));

    public String build(Package pkg, FunctionDescr functionDescr, TypeResolver typeResolver, Map lineMappings, List errors) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("package", pkg.getName());
        vars.put("imports", pkg.getImports().keySet());
        LinkedList<String> staticImports = new LinkedList<String>();
        for (String staticImport : pkg.getStaticImports()) {
            if (staticImport.endsWith(functionDescr.getName())) continue;
            staticImports.add(staticImport);
        }
        vars.put("staticImports", staticImports);
        vars.put("className", StringUtils.ucFirst(functionDescr.getName()));
        vars.put("methodName", functionDescr.getName());
        vars.put("returnType", functionDescr.getReturnType());
        vars.put("parameterTypes", functionDescr.getParameterTypes());
        vars.put("parameterNames", functionDescr.getParameterNames());
        HashMap<String, Class> params = new HashMap<String, Class>();
        List<String> names = functionDescr.getParameterNames();
        List<String> types = functionDescr.getParameterTypes();
        try {
            int size = names.size();
            for (int i = 0; i < size; ++i) {
                params.put(names.get(i), typeResolver.resolveType(types.get(i)));
            }
        }
        catch (ClassNotFoundException e) {
            errors.add(new FunctionError(functionDescr, e, "unable to resolve type while building function"));
        }
        vars.put("text", functionDescr.getText());
        String text = String.valueOf(TemplateRuntime.eval(template, null, new MapVariableResolverFactory(vars)));
        BufferedReader reader = new BufferedReader(new StringReader(text));
        String line = null;
        String lineStartsWith = "    public static " + functionDescr.getReturnType() + " " + functionDescr.getName();
        int offset = 0;
        try {
            while ((line = reader.readLine()) != null) {
                ++offset;
                if (!line.startsWith(lineStartsWith)) continue;
            }
            functionDescr.setOffset(offset);
        }
        catch (IOException e) {
            throw new RuntimeDroolsException("Error determining start offset with function");
        }
        String name = pkg.getName() + "." + StringUtils.ucFirst(functionDescr.getName());
        LineMappings mapping = new LineMappings(name);
        mapping.setStartLine(functionDescr.getLine());
        mapping.setOffset(functionDescr.getOffset());
        lineMappings.put(name, mapping);
        return text;
    }
}

