/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.base.ModifyInterceptor;
import org.drools.base.TypeResolver;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.base.mvel.MVELDebugHandler;
import org.drools.commons.jci.readers.MemoryResourceReader;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.Dialect;
import org.drools.compiler.ImportError;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageRegistry;
import org.drools.io.Resource;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.CollectDescr;
import org.drools.lang.descr.EntryPointDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.FromDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.ProcessDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.Declaration;
import org.drools.rule.LineMappings;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.Package;
import org.drools.rule.builder.AccumulateBuilder;
import org.drools.rule.builder.ActionBuilder;
import org.drools.rule.builder.CollectBuilder;
import org.drools.rule.builder.ConsequenceBuilder;
import org.drools.rule.builder.EnabledBuilder;
import org.drools.rule.builder.EngineElementBuilder;
import org.drools.rule.builder.EntryPointBuilder;
import org.drools.rule.builder.ForallBuilder;
import org.drools.rule.builder.FromBuilder;
import org.drools.rule.builder.GroupElementBuilder;
import org.drools.rule.builder.PackageBuildContext;
import org.drools.rule.builder.PatternBuilder;
import org.drools.rule.builder.PredicateBuilder;
import org.drools.rule.builder.ProcessBuildContext;
import org.drools.rule.builder.ProcessClassBuilder;
import org.drools.rule.builder.QueryBuilder;
import org.drools.rule.builder.ReturnValueBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleClassBuilder;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.rule.builder.SalienceBuilder;
import org.drools.rule.builder.dialect.java.JavaDialect;
import org.drools.rule.builder.dialect.java.JavaFunctionBuilder;
import org.drools.rule.builder.dialect.mvel.MVELAccumulateBuilder;
import org.drools.rule.builder.dialect.mvel.MVELActionBuilder;
import org.drools.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.rule.builder.dialect.mvel.MVELConsequenceBuilder;
import org.drools.rule.builder.dialect.mvel.MVELDialectConfiguration;
import org.drools.rule.builder.dialect.mvel.MVELEnabledBuilder;
import org.drools.rule.builder.dialect.mvel.MVELEvalBuilder;
import org.drools.rule.builder.dialect.mvel.MVELExprAnalyzer;
import org.drools.rule.builder.dialect.mvel.MVELFromBuilder;
import org.drools.rule.builder.dialect.mvel.MVELPredicateBuilder;
import org.drools.rule.builder.dialect.mvel.MVELReturnValueBuilder;
import org.drools.rule.builder.dialect.mvel.MVELReturnValueEvaluatorBuilder;
import org.drools.rule.builder.dialect.mvel.MVELSalienceBuilder;
import org.drools.runtime.rule.RuleContext;
import org.drools.spi.DeclarationScopeResolver;
import org.drools.spi.KnowledgeHelper;
import org.drools.util.StringUtils;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.ast.Function;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExpressionCompiler;
import org.mvel2.util.CompilerTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVELDialect
implements Dialect,
Externalizable {
    private String id = "mvel";
    private static final String EXPRESSION_DIALECT_NAME = "MVEL";
    protected static final PatternBuilder PATTERN_BUILDER = new PatternBuilder();
    protected static final QueryBuilder QUERY_BUILDER = new QueryBuilder();
    protected static final MVELAccumulateBuilder ACCUMULATE_BUILDER = new MVELAccumulateBuilder();
    protected static final SalienceBuilder SALIENCE_BUILDER = new MVELSalienceBuilder();
    protected static final EnabledBuilder ENABLED_BUILDER = new MVELEnabledBuilder();
    protected static final MVELEvalBuilder EVAL_BUILDER = new MVELEvalBuilder();
    protected static final MVELPredicateBuilder PREDICATE_BUILDER = new MVELPredicateBuilder();
    protected static final MVELReturnValueBuilder RETURN_VALUE_BUILDER = new MVELReturnValueBuilder();
    protected static final MVELConsequenceBuilder CONSEQUENCE_BUILDER = new MVELConsequenceBuilder();
    protected static final MVELActionBuilder ACTION_BUILDER = new MVELActionBuilder();
    protected static final MVELReturnValueEvaluatorBuilder RETURN_VALUE_EVALUATOR_BUILDER = new MVELReturnValueEvaluatorBuilder();
    protected static final MVELFromBuilder FROM_BUILDER = new MVELFromBuilder();
    protected static final JavaFunctionBuilder FUNCTION_BUILDER = new JavaFunctionBuilder();
    protected static final CollectBuilder COLLECT_BUILDER = new CollectBuilder();
    protected static final ForallBuilder FORALL_BUILDER = new ForallBuilder();
    protected static final EntryPointBuilder ENTRY_POINT_BUILDER = new EntryPointBuilder();
    protected static final GroupElementBuilder GE_BUILDER = new GroupElementBuilder();
    private static Map<Class<?>, EngineElementBuilder> builders;
    private static final MVELExprAnalyzer analyzer;
    private Map interceptors;
    protected List results;
    protected MemoryResourceReader src;
    protected Package pkg;
    private MVELDialectConfiguration configuration;
    private PackageBuilder pkgBuilder;
    private PackageRegistry packageRegistry;
    private Map imports;
    private Map packageImports;
    private boolean strictMode;
    private int languageLevel;
    public static final Object COMPILER_LOCK;

    public MVELDialect(PackageBuilder builder, PackageRegistry pkgRegistry, Package pkg) {
        this(builder, pkgRegistry, pkg, "mvel");
    }

    public MVELDialect(PackageBuilder builder, PackageRegistry pkgRegistry, Package pkg, String id) {
        this.id = id;
        this.pkg = pkg;
        this.pkgBuilder = builder;
        this.packageRegistry = pkgRegistry;
        this.configuration = (MVELDialectConfiguration)builder.getPackageBuilderConfiguration().getDialectConfiguration("mvel");
        this.setLanguageLevel(this.configuration.getLangLevel());
        this.strictMode = this.configuration.isStrict();
        this.imports = new HashMap();
        this.packageImports = new HashMap();
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        this.interceptors = new HashMap(1);
        this.interceptors.put("Modify", new ModifyInterceptor());
        this.results = new ArrayList();
        MVELDialectRuntimeData data = null;
        if (pkg.getDialectRuntimeRegistry().getDialectData(this.getId()) == null) {
            data = new MVELDialectRuntimeData();
            this.pkg.getDialectRuntimeRegistry().setDialectData(this.getId(), data);
            data.onAdd(this.pkg.getDialectRuntimeRegistry(), this.pkgBuilder.getRootClassLoader());
        }
        this.results = new ArrayList();
        this.src = new MemoryResourceReader();
        if (this.pkg != null) {
            this.addImport(this.pkg.getName() + ".*");
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.interceptors = (Map)in.readObject();
        this.results = (List)in.readObject();
        this.src = (MemoryResourceReader)in.readObject();
        this.pkg = (Package)in.readObject();
        this.packageRegistry = (PackageRegistry)in.readObject();
        this.configuration = (MVELDialectConfiguration)in.readObject();
        this.imports = (Map)in.readObject();
        this.packageImports = (Map)in.readObject();
        this.strictMode = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.interceptors);
        out.writeObject(this.results);
        out.writeObject(this.src);
        out.writeObject(this.pkg);
        out.writeObject(this.packageRegistry);
        out.writeObject(this.configuration);
        out.writeObject(this.imports);
        out.writeObject(this.packageImports);
        out.writeBoolean(this.strictMode);
    }

    public void setLanguageLevel(int languageLevel) {
        this.languageLevel = languageLevel;
    }

    public static void initBuilder() {
        if (builders != null) {
            return;
        }
        builders = new HashMap();
        builders.put(AndDescr.class, GE_BUILDER);
        builders.put(OrDescr.class, GE_BUILDER);
        builders.put(NotDescr.class, GE_BUILDER);
        builders.put(ExistsDescr.class, GE_BUILDER);
        builders.put(PatternDescr.class, PATTERN_BUILDER);
        builders.put(FromDescr.class, FROM_BUILDER);
        builders.put(QueryDescr.class, QUERY_BUILDER);
        builders.put(AccumulateDescr.class, ACCUMULATE_BUILDER);
        builders.put(EvalDescr.class, EVAL_BUILDER);
        builders.put(CollectDescr.class, COLLECT_BUILDER);
        builders.put(ForallDescr.class, FORALL_BUILDER);
        builders.put(FunctionDescr.class, FUNCTION_BUILDER);
        builders.put(EntryPointDescr.class, ENTRY_POINT_BUILDER);
    }

    @Override
    public void init(RuleDescr ruleDescr) {
        String pkgName = this.pkg == null ? "" : this.pkg.getName();
        String ruleClassName = JavaDialect.getUniqueLegalName(pkgName, ruleDescr.getName(), "mvel", "Rule", this.src);
        ruleDescr.setClassName(StringUtils.ucFirst(ruleClassName));
    }

    @Override
    public void init(ProcessDescr processDescr) {
        String processDescrClassName = JavaDialect.getUniqueLegalName(this.pkg.getName(), processDescr.getName(), "mvel", "Process", this.src);
        processDescr.setClassName(StringUtils.ucFirst(processDescrClassName));
    }

    @Override
    public String getExpressionDialectName() {
        return EXPRESSION_DIALECT_NAME;
    }

    @Override
    public void addRule(RuleBuildContext context) {
        RuleDescr ruleDescr = context.getRuleDescr();
        String name = this.pkg.getName() + "." + StringUtils.ucFirst(ruleDescr.getClassName());
        LineMappings mapping = new LineMappings(name);
        mapping.setStartLine(ruleDescr.getConsequenceLine());
        mapping.setOffset(ruleDescr.getConsequenceOffset());
        context.getPkg().getDialectRuntimeRegistry().getLineMappings().put(name, mapping);
    }

    @Override
    public void addProcess(ProcessBuildContext context) {
    }

    @Override
    public void addFunction(FunctionDescr functionDescr, TypeResolver typeResolver, Resource resource) {
        Serializable s1 = this.compile((String)functionDescr.getContent(), null, null, null, null, null);
        Map<String, Function> map = CompilerTools.extractAllDeclaredFunctions((CompiledExpression)s1);
        MVELDialectRuntimeData data = (MVELDialectRuntimeData)this.packageRegistry.getDialectRuntimeRegistry().getDialectData(this.getId());
        for (Function function : map.values()) {
            data.addFunction(function);
        }
    }

    @Override
    public void preCompileAddFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
    }

    @Override
    public void postCompileAddFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
    }

    @Override
    public void addImport(String importEntry) {
        if (importEntry.endsWith(".*")) {
            importEntry = importEntry.substring(0, importEntry.length() - 2);
            this.packageImports.put(importEntry, importEntry);
        } else {
            try {
                Class cls = this.packageRegistry.getTypeResolver().resolveType(importEntry);
                this.imports.put(cls.getSimpleName(), cls);
            }
            catch (ClassNotFoundException e) {
                this.results.add(new ImportError(importEntry, 1));
            }
        }
    }

    public Map getImports() {
        return this.imports;
    }

    public Map getPackgeImports() {
        return this.packageImports;
    }

    @Override
    public void addStaticImport(String staticImportEntry) {
        if (staticImportEntry.endsWith("*")) {
            return;
        }
        int index = staticImportEntry.lastIndexOf(46);
        String className = staticImportEntry.substring(0, index);
        String methodName = staticImportEntry.substring(index + 1);
        try {
            Class<?> cls = this.pkgBuilder.getRootClassLoader().loadClass(className);
            if (cls != null) {
                for (Method method : cls.getDeclaredMethods()) {
                    if (!method.getName().equals(methodName)) continue;
                    this.imports.put(methodName, method);
                    return;
                }
                for (AccessibleObject accessibleObject : cls.getFields()) {
                    if (!accessibleObject.isAccessible() || !((Field)accessibleObject).getName().equals(methodName)) continue;
                    this.imports.put(methodName, accessibleObject);
                    return;
                }
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        this.results.add(new ImportError(staticImportEntry, -1));
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    @Override
    public void compileAll() {
    }

    @Override
    public Dialect.AnalysisResult analyzeExpression(PackageBuildContext context, BaseDescr descr, Object content, Map<String, Class<?>>[] availableIdentifiers) {
        return this.analyzeExpression(context, descr, content, availableIdentifiers, null);
    }

    public Dialect.AnalysisResult analyzeExpression(PackageBuildContext context, BaseDescr descr, Object content, Map<String, Class<?>>[] availableIdentifiers, Map<String, Class<?>> localTypes) {
        MVELAnalysisResult result = null;
        try {
            result = analyzer.analyzeExpression(context, (String)content, availableIdentifiers, localTypes);
        }
        catch (Exception e) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to determine the used declarations.\n" + e.getMessage()));
        }
        return result;
    }

    @Override
    public Dialect.AnalysisResult analyzeBlock(PackageBuildContext context, BaseDescr descr, String text, Map<String, Class<?>>[] availableIdentifiers) {
        return this.analyzeBlock(context, descr, null, text, availableIdentifiers, null);
    }

    public Dialect.AnalysisResult analyzeBlock(PackageBuildContext context, BaseDescr descr, Map interceptors, String text, Map<String, Class<?>>[] availableIdentifiers, Map<String, Class<?>> localTypes) {
        MVELAnalysisResult result = null;
        result = analyzer.analyzeExpression(context, text, availableIdentifiers, localTypes);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable compile(String text, Dialect.AnalysisResult analysis, Map interceptors, Map outerDeclarations, Map otherInputVariables, PackageBuildContext context) {
        ParserContext parserContext = this.getParserContext(analysis, outerDeclarations, otherInputVariables, context);
        ExpressionCompiler compiler = new ExpressionCompiler(text.trim());
        Object object = COMPILER_LOCK;
        synchronized (object) {
            ClassLoader tempClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.pkgBuilder.getRootClassLoader());
            AbstractParser.setLanguageLevel(this.languageLevel);
            CompiledExpression expr = compiler.compile(parserContext);
            Thread.currentThread().setContextClassLoader(tempClassLoader);
            return expr;
        }
    }

    public MVELCompilationUnit getMVELCompilationUnit(String expression, Dialect.AnalysisResult analysis, Declaration[] previousDeclarations, Declaration[] localDeclarations, Map<String, Class<?>> otherInputVariables, PackageBuildContext context) {
        String[] otherIdentifiers;
        String[] pkgImports = new String[this.packageImports.size()];
        int i = 0;
        Iterator it = this.packageImports.values().iterator();
        while (it.hasNext()) {
            pkgImports[i] = (String)it.next();
        }
        ArrayList<String> importClasses = new ArrayList<String>();
        ArrayList<String> importMethods = new ArrayList<String>();
        ArrayList<String> importFields = new ArrayList<String>();
        for (Object object : this.imports.values()) {
            if (object instanceof Class) {
                importClasses.add(((Class)object).getName());
                continue;
            }
            if (object instanceof Method) {
                Method method = (Method)object;
                importMethods.add(method.getDeclaringClass().getName() + "." + method.getName());
                continue;
            }
            Field field = (Field)object;
            importFields.add(field.getDeclaringClass().getName() + "." + field.getName());
        }
        HashMap<String, Class> resolvedInputs = new HashMap<String, Class>();
        String[] globalIdentifiers = new String[]{};
        String[] stringArray = otherIdentifiers = otherInputVariables == null ? new String[]{} : new String[otherInputVariables.size()];
        if (analysis != null) {
            List<String>[] list = analysis.getBoundIdentifiers();
            Map<String, Class<?>> globalTypes = context.getPackageBuilder().getGlobals();
            globalIdentifiers = new String[list[1].size()];
            i = 0;
            for (String string : list[1]) {
                globalIdentifiers[i++] = string;
                resolvedInputs.put(string, globalTypes.get(string));
            }
            if (previousDeclarations != null) {
                for (Declaration declr : previousDeclarations) {
                    resolvedInputs.put(declr.getIdentifier(), declr.getExtractor().getExtractToClass());
                }
            }
            if (localDeclarations != null) {
                for (Declaration declr : localDeclarations) {
                    resolvedInputs.put(declr.getIdentifier(), declr.getExtractor().getExtractToClass());
                }
            }
            if (otherInputVariables != null) {
                i = 0;
                for (Map.Entry entry : otherInputVariables.entrySet()) {
                    otherIdentifiers[i++] = (String)entry.getKey();
                    resolvedInputs.put((String)entry.getKey(), (Class)entry.getValue());
                }
            }
        }
        String[] inputIdentifiers = new String[resolvedInputs.size()];
        String[] inputTypes = new String[resolvedInputs.size()];
        i = 0;
        for (Map.Entry entry : resolvedInputs.entrySet()) {
            inputIdentifiers[i] = (String)entry.getKey();
            inputTypes[i++] = ((Class)entry.getValue()).getName();
        }
        String name = context != null && context.getPkg() != null & context.getPkg().getName() != null ? (context instanceof RuleBuildContext ? context.getPkg().getName() + "." + ((RuleBuildContext)context).getRuleDescr().getClassName() : context.getPkg().getName() + ".Unknown") : "Unknown";
        MVELCompilationUnit mVELCompilationUnit = new MVELCompilationUnit(name, expression, pkgImports, importClasses.toArray(new String[importClasses.size()]), importMethods.toArray(new String[importMethods.size()]), importFields.toArray(new String[importFields.size()]), globalIdentifiers, previousDeclarations, localDeclarations, otherIdentifiers, inputIdentifiers, inputTypes, this.languageLevel, this.strictMode);
        return mVELCompilationUnit;
    }

    public ParserContext getParserContext(Dialect.AnalysisResult analysis, Map outerDeclarations, Map otherInputVariables, PackageBuildContext context) {
        String name = context != null && context.getPkg() != null & context.getPkg().getName() != null ? (context instanceof RuleBuildContext ? context.getPkg().getName() + "." + ((RuleBuildContext)context).getRuleDescr().getClassName() : context.getPkg().getName() + ".Unknown") : "Unknown";
        ParserContext parserContext = new ParserContext(this.imports, null, name);
        if (MVELDebugHandler.isDebugMode()) {
            parserContext.setDebugSymbols(true);
        }
        for (String packageImport : this.packageImports.values()) {
            parserContext.addPackageImport(packageImport);
        }
        parserContext.setStrictTypeEnforcement(this.strictMode);
        if (this.interceptors != null) {
            parserContext.setInterceptors(this.interceptors);
        }
        if (analysis != null) {
            List<String>[] list = analysis.getBoundIdentifiers();
            if (context instanceof RuleBuildContext) {
                DeclarationScopeResolver resolver = ((RuleBuildContext)context).getDeclarationResolver();
                for (String string : list[0]) {
                    Class<?> cls = resolver.getDeclaration(null, string).getExtractor().getExtractToClass();
                    parserContext.addInput(string, cls);
                }
            }
            Map<String, Class<?>> globalTypes = context.getPackageBuilder().getGlobals();
            for (String string : list[1]) {
                parserContext.addInput(string, globalTypes.get(string));
            }
            if (otherInputVariables != null) {
                for (Map.Entry entry : otherInputVariables.entrySet()) {
                    parserContext.addInput((String)entry.getKey(), (Class)entry.getValue());
                }
            }
            if (outerDeclarations != null) {
                for (Map.Entry entry : outerDeclarations.entrySet()) {
                    parserContext.addInput((String)entry.getKey(), ((Declaration)entry.getValue()).getExtractor().getExtractToClass());
                }
            }
            parserContext.addInput("drools", KnowledgeHelper.class);
            if (parserContext.getInputs().get("kcontext") == null) {
                parserContext.addInput("kcontext", RuleContext.class);
            }
        }
        return parserContext;
    }

    @Override
    public EngineElementBuilder getBuilder(Class<?> clazz) {
        return builders.get(clazz);
    }

    @Override
    public Map<Class<?>, EngineElementBuilder> getBuilders() {
        return builders;
    }

    @Override
    public PatternBuilder getPatternBuilder() {
        return PATTERN_BUILDER;
    }

    @Override
    public QueryBuilder getQueryBuilder() {
        return QUERY_BUILDER;
    }

    @Override
    public AccumulateBuilder getAccumulateBuilder() {
        return ACCUMULATE_BUILDER;
    }

    @Override
    public ConsequenceBuilder getConsequenceBuilder() {
        return CONSEQUENCE_BUILDER;
    }

    @Override
    public ActionBuilder getActionBuilder() {
        return ACTION_BUILDER;
    }

    @Override
    public MVELReturnValueEvaluatorBuilder getReturnValueEvaluatorBuilder() {
        return RETURN_VALUE_EVALUATOR_BUILDER;
    }

    @Override
    public RuleConditionBuilder getEvalBuilder() {
        return EVAL_BUILDER;
    }

    @Override
    public FromBuilder getFromBuilder() {
        return FROM_BUILDER;
    }

    @Override
    public EntryPointBuilder getEntryPointBuilder() {
        return ENTRY_POINT_BUILDER;
    }

    @Override
    public PredicateBuilder getPredicateBuilder() {
        return PREDICATE_BUILDER;
    }

    public PredicateBuilder getExpressionPredicateBuilder() {
        return PREDICATE_BUILDER;
    }

    @Override
    public SalienceBuilder getSalienceBuilder() {
        return SALIENCE_BUILDER;
    }

    @Override
    public EnabledBuilder getEnabledBuilder() {
        return ENABLED_BUILDER;
    }

    @Override
    public List getResults() {
        return this.results;
    }

    @Override
    public ReturnValueBuilder getReturnValueBuilder() {
        return RETURN_VALUE_BUILDER;
    }

    @Override
    public RuleClassBuilder getRuleClassBuilder() {
        throw new UnsupportedOperationException("MVELDialect.getRuleClassBuilder is not supported");
    }

    @Override
    public ProcessClassBuilder getProcessClassBuilder() {
        throw new UnsupportedOperationException("MVELDialect.getProcessClassBuilder is not supported");
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.packageRegistry.getTypeResolver();
    }

    public Map getInterceptors() {
        return this.interceptors;
    }

    @Override
    public String getId() {
        return this.id;
    }

    static {
        MVELDialect.initBuilder();
        analyzer = new MVELExprAnalyzer();
        COMPILER_LOCK = new Object();
    }
}

