/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.report.components;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.drools.base.evaluators.Operator;
import org.drools.verifier.components.Field;
import org.drools.verifier.report.components.CauseType;
import org.drools.verifier.report.components.MissingRange;
import org.drools.verifier.report.components.RangeCheckCause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissingNumberPattern
extends MissingRange
implements RangeCheckCause,
Comparable<MissingRange> {
    private final Field.FieldType valueType;
    private final String value;

    @Override
    public int compareTo(MissingRange another) {
        return super.compareTo(another);
    }

    @Override
    public CauseType getCauseType() {
        return CauseType.RANGE_CHECK_CAUSE;
    }

    public MissingNumberPattern(Field field, Operator operator, Field.FieldType valueType, String value) {
        super(field, operator);
        this.valueType = valueType;
        this.value = value;
    }

    public String getRuleName() {
        return null;
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    @Override
    public Object getValueAsObject() {
        if (this.valueType == Field.FieldType.BOOLEAN) {
            return Boolean.valueOf(this.value);
        }
        if (this.valueType == Field.FieldType.DATE) {
            try {
                String fmt = System.getProperty("drools.dateformat");
                if (fmt == null) {
                    fmt = "dd-MMM-yyyy";
                }
                return new SimpleDateFormat(fmt, Locale.ENGLISH).parse(this.value);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            if (this.valueType == Field.FieldType.DOUBLE) {
                return Double.valueOf(this.value);
            }
            if (this.valueType == Field.FieldType.INT) {
                return Integer.valueOf(this.value);
            }
        }
        return this.value;
    }

    public Field.FieldType getValueType() {
        return this.valueType;
    }

    public String toString() {
        return "Missing restriction " + this.operator + " " + this.value;
    }
}

