/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.report.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.drools.verifier.dao.VerifierData;
import org.drools.verifier.report.components.Cause;
import org.drools.verifier.report.components.VerifierMessage;
import org.drools.verifier.report.components.VerifierMessageBase;
import org.drools.verifier.report.components.VerifierRangeCheckMessage;
import org.drools.verifier.report.html.MissingRangesReportVisitor;
import org.drools.verifier.report.html.ReportVisitor;
import org.drools.verifier.report.html.UrlFactory;
import org.mvel2.templates.TemplateRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VerifierMessagesVisitor
extends ReportVisitor {
    private static final String VERIFIER_MESSAGES_TEMPLATE = "verifierMessages.htm";
    private static final String VERIFIER_MESSAGE_TEMPLATE = "verifierMessage.htm";
    public static final String NOTES = "Notes";
    public static final String WARNINGS = "Warnings";
    public static final String ERRORS = "Errors";

    VerifierMessagesVisitor() {
    }

    public static String visitVerifierMessagesCollection(String title, Collection<VerifierMessageBase> messages, VerifierData data) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> messageTemplates = new ArrayList<String>();
        String myTemplate = VerifierMessagesVisitor.readFile(VERIFIER_MESSAGES_TEMPLATE);
        for (VerifierMessageBase message : messages) {
            messageTemplates.add(VerifierMessagesVisitor.visitVerifierMessage(message, data));
        }
        map.put("title", title);
        map.put("messages", messageTemplates);
        return String.valueOf(TemplateRuntime.eval(myTemplate, map));
    }

    public static String visitVerifierMessage(VerifierMessageBase message, VerifierData data) {
        if (message instanceof VerifierRangeCheckMessage) {
            return VerifierMessagesVisitor.visitVerifierMessage((VerifierRangeCheckMessage)message, data);
        }
        if (message instanceof VerifierMessage) {
            return VerifierMessagesVisitor.visitVerifierMessage((VerifierMessage)message);
        }
        return null;
    }

    public static String visitVerifierMessage(VerifierRangeCheckMessage message, VerifierData data) {
        return MissingRangesReportVisitor.visitRangeCheckMessage(".", message, data);
    }

    public static String visitVerifierMessage(VerifierMessage message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> causeUrls = new ArrayList<String>();
        String myTemplate = VerifierMessagesVisitor.readFile(VERIFIER_MESSAGE_TEMPLATE);
        for (Cause cause : message.getCauses()) {
            causeUrls.add(UrlFactory.getUrl(cause));
        }
        map.put("title", message.getSeverity());
        map.put("reason", message.getFaulty());
        map.put("message", message.getMessage());
        map.put("causes", causeUrls);
        return String.valueOf(TemplateRuntime.eval(myTemplate, map));
    }
}

