/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workflow.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.definition.process.Connection;
import org.drools.process.core.Context;
import org.drools.process.core.ContextResolver;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.NodeContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeImpl
implements Node,
Serializable,
ContextResolver {
    private static final long serialVersionUID = 4L;
    protected static final NodeImpl[] EMPTY_NODE_ARRAY = new NodeImpl[0];
    private long id = -1L;
    private String name;
    private Map<String, List<Connection>> incomingConnections;
    private Map<String, List<Connection>> outgoingConnections;
    private org.drools.definition.process.NodeContainer nodeContainer;
    private Map<String, Context> contexts = new HashMap<String, Context>();
    private Map<String, Object> metaData = new HashMap<String, Object>();

    public NodeImpl() {
        this.incomingConnections = new HashMap<String, List<Connection>>();
        this.outgoingConnections = new HashMap<String, List<Connection>>();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Map<String, List<Connection>> getIncomingConnections() {
        return Collections.unmodifiableMap(this.incomingConnections);
    }

    @Override
    public Map<String, List<Connection>> getOutgoingConnections() {
        return Collections.unmodifiableMap(this.outgoingConnections);
    }

    @Override
    public void addIncomingConnection(String type, Connection connection) {
        this.validateAddIncomingConnection(type, connection);
        List<Connection> connections = this.incomingConnections.get(type);
        if (connections == null) {
            connections = new ArrayList<Connection>();
            this.incomingConnections.put(type, connections);
        }
        connections.add(connection);
    }

    public void validateAddIncomingConnection(String type, Connection connection) {
        if (type == null) {
            throw new IllegalArgumentException("Connection type cannot be null");
        }
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
    }

    @Override
    public List<Connection> getIncomingConnections(String type) {
        List<Connection> result = this.incomingConnections.get(type);
        if (result == null) {
            return new ArrayList<Connection>();
        }
        return result;
    }

    @Override
    public void addOutgoingConnection(String type, Connection connection) {
        this.validateAddOutgoingConnection(type, connection);
        List<Connection> connections = this.outgoingConnections.get(type);
        if (connections == null) {
            connections = new ArrayList<Connection>();
            this.outgoingConnections.put(type, connections);
        }
        connections.add(connection);
    }

    public void validateAddOutgoingConnection(String type, Connection connection) {
        if (type == null) {
            throw new IllegalArgumentException("Connection type cannot be null");
        }
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
    }

    @Override
    public List<Connection> getOutgoingConnections(String type) {
        List<Connection> result = this.outgoingConnections.get(type);
        if (result == null) {
            return new ArrayList<Connection>();
        }
        return result;
    }

    @Override
    public void removeIncomingConnection(String type, Connection connection) {
        this.validateRemoveIncomingConnection(type, connection);
        this.incomingConnections.get(type).remove(connection);
    }

    public void validateRemoveIncomingConnection(String type, Connection connection) {
        if (type == null) {
            throw new IllegalArgumentException("Connection type cannot be null");
        }
        if (connection == null) {
            throw new IllegalArgumentException("Connection is null");
        }
        if (!this.incomingConnections.get(type).contains(connection)) {
            throw new IllegalArgumentException("Given connection <" + connection + "> is not part of the incoming connections");
        }
    }

    @Override
    public void removeOutgoingConnection(String type, Connection connection) {
        this.validateRemoveOutgoingConnection(type, connection);
        this.outgoingConnections.get(type).remove(connection);
    }

    public void validateRemoveOutgoingConnection(String type, Connection connection) {
        if (type == null) {
            throw new IllegalArgumentException("Connection type cannot be null");
        }
        if (connection == null) {
            throw new IllegalArgumentException("Connection is null");
        }
        if (!this.outgoingConnections.get(type).contains(connection)) {
            throw new IllegalArgumentException("Given connection <" + connection + "> is not part of the outgoing connections");
        }
    }

    @Override
    public org.drools.definition.process.NodeContainer getNodeContainer() {
        return this.nodeContainer;
    }

    @Override
    public void setNodeContainer(org.drools.definition.process.NodeContainer nodeContainer) {
        this.nodeContainer = nodeContainer;
    }

    @Override
    public void setContext(String contextId, Context context) {
        this.contexts.put(contextId, context);
    }

    @Override
    public Context getContext(String contextId) {
        return this.contexts.get(contextId);
    }

    @Override
    public Context resolveContext(String contextId, Object param) {
        Context context = this.getContext(contextId);
        if (context != null && (context = context.resolveContext(param)) != null) {
            return context;
        }
        return ((NodeContainer)this.nodeContainer).resolveContext(contextId, param);
    }

    @Override
    public void setMetaData(String name, Object value) {
        this.metaData.put(name, value);
    }

    @Override
    public Object getMetaData(String name) {
        return this.metaData.get(name);
    }
}

