/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workflow.instance.node;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.WorkingMemory;
import org.drools.common.InternalRuleBase;
import org.drools.process.core.Work;
import org.drools.process.instance.WorkItem;
import org.drools.process.instance.context.variable.VariableScopeInstance;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.runtime.process.EventListener;
import org.drools.runtime.process.NodeInstance;
import org.drools.workflow.core.node.WorkItemNode;
import org.drools.workflow.instance.impl.NodeInstanceResolverFactory;
import org.drools.workflow.instance.impl.WorkItemResolverFactory;
import org.drools.workflow.instance.node.EventBasedNodeInstance;
import org.mvel2.MVEL;

public class WorkItemNodeInstance
extends EventBasedNodeInstance
implements EventListener {
    private static final long serialVersionUID = 400L;
    private static final Pattern PARAMETER_MATCHER = Pattern.compile("#\\{(\\S+)\\}", 32);
    private long workItemId = -1L;
    private transient WorkItem workItem;

    protected WorkItemNode getWorkItemNode() {
        return (WorkItemNode)this.getNode();
    }

    public WorkItem getWorkItem() {
        if (this.workItem == null && this.workItemId >= 0L) {
            this.workItem = this.getProcessInstance().getWorkingMemory().getWorkItemManager().getWorkItem(this.workItemId);
        }
        return this.workItem;
    }

    public long getWorkItemId() {
        return this.workItemId;
    }

    public void internalSetWorkItemId(long workItemId) {
        this.workItemId = workItemId;
    }

    public boolean isInversionOfControl() {
        return ((InternalRuleBase)this.getProcessInstance().getWorkingMemory().getRuleBase()).getConfiguration().isAdvancedProcessRuleIntegration();
    }

    public void internalTrigger(NodeInstance from, String type) {
        super.internalTrigger(from, type);
        WorkItemNode workItemNode = this.getWorkItemNode();
        this.createWorkItem(workItemNode);
        if (workItemNode.isWaitForCompletion()) {
            this.addWorkItemListener();
        }
        if (this.isInversionOfControl()) {
            this.getProcessInstance().getWorkingMemory().update(this.getProcessInstance().getWorkingMemory().getFactHandle(this), this);
        } else {
            this.getProcessInstance().getWorkingMemory().getWorkItemManager().internalExecuteWorkItem(this.workItem);
        }
        if (!workItemNode.isWaitForCompletion()) {
            this.triggerCompleted();
        } else {
            this.workItemId = this.workItem.getId();
        }
    }

    protected WorkItem createWorkItem(WorkItemNode workItemNode) {
        Work work = workItemNode.getWork();
        this.workItem = new WorkItemImpl();
        this.workItem.setName(work.getName());
        this.workItem.setProcessInstanceId(this.getProcessInstance().getId());
        this.workItem.setParameters(new HashMap<String, Object>(work.getParameters()));
        for (Map.Entry<String, String> mapping : workItemNode.getInMappings().entrySet()) {
            Object parameterValue = null;
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", mapping.getValue());
            if (variableScopeInstance != null) {
                parameterValue = variableScopeInstance.getVariable(mapping.getValue());
            } else {
                try {
                    parameterValue = MVEL.eval(mapping.getValue(), new NodeInstanceResolverFactory(this));
                }
                catch (Throwable t) {
                    System.err.println("Could not find variable scope for variable " + mapping.getValue());
                    System.err.println("when trying to execute Work Item " + work.getName());
                    System.err.println("Continuing without setting parameter.");
                }
            }
            if (parameterValue == null) continue;
            this.workItem.setParameter(mapping.getKey(), parameterValue);
        }
        for (Map.Entry<String, Object> entry : this.workItem.getParameters().entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            String s = (String)entry.getValue();
            HashMap<String, String> replacements = new HashMap<String, String>();
            Matcher matcher = PARAMETER_MATCHER.matcher(s);
            while (matcher.find()) {
                String variableValueString;
                Object variableValue;
                String paramName = matcher.group(1);
                if (replacements.get(paramName) != null) continue;
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", paramName);
                if (variableScopeInstance != null) {
                    variableValue = variableScopeInstance.getVariable(paramName);
                    variableValueString = variableValue == null ? "" : variableValue.toString();
                    replacements.put(paramName, variableValueString);
                    continue;
                }
                try {
                    variableValue = MVEL.eval(paramName, new NodeInstanceResolverFactory(this));
                    variableValueString = variableValue == null ? "" : variableValue.toString();
                    replacements.put(paramName, variableValueString);
                }
                catch (Throwable t) {
                    System.err.println("Could not find variable scope for variable " + paramName);
                    System.err.println("when trying to replace variable in string for Work Item " + work.getName());
                    System.err.println("Continuing without setting parameter.");
                }
            }
            for (Map.Entry replacement : replacements.entrySet()) {
                s = s.replace("#{" + (String)replacement.getKey() + "}", (CharSequence)replacement.getValue());
            }
            this.workItem.setParameter(entry.getKey(), s);
        }
        return this.workItem;
    }

    public void triggerCompleted(WorkItem workItem) {
        for (Map.Entry<String, String> mapping : this.getWorkItemNode().getOutMappings().entrySet()) {
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", mapping.getValue());
            if (variableScopeInstance != null) {
                Object value = workItem.getResult(mapping.getKey());
                if (value == null) {
                    try {
                        value = MVEL.eval(mapping.getKey(), new WorkItemResolverFactory(workItem));
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                variableScopeInstance.setVariable(mapping.getValue(), value);
                continue;
            }
            System.err.println("Could not find variable scope for variable " + mapping.getValue());
            System.err.println("when trying to complete Work Item " + workItem.getName());
            System.err.println("Continuing without setting variable.");
        }
        if (this.isInversionOfControl()) {
            WorkingMemory workingMemory = this.getProcessInstance().getWorkingMemory();
            workingMemory.update(workingMemory.getFactHandle(this), this);
        } else {
            this.triggerCompleted();
        }
    }

    public void cancel() {
        if (this.workItemId != -1L) {
            this.getProcessInstance().getWorkingMemory().getWorkItemManager().internalAbortWorkItem(this.workItemId);
        }
        super.cancel();
    }

    public void addEventListeners() {
        super.addEventListeners();
        this.addWorkItemListener();
    }

    private void addWorkItemListener() {
        this.getProcessInstance().addEventListener("workItemCompleted", this, false);
        this.getProcessInstance().addEventListener("workItemAborted", this, false);
    }

    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener("workItemCompleted", this, false);
        this.getProcessInstance().removeEventListener("workItemAborted", this, false);
    }

    public void signalEvent(String type, Object event) {
        if ("workItemCompleted".equals(type)) {
            this.workItemCompleted((WorkItem)event);
        } else if ("workItemAborted".equals(type)) {
            this.workItemAborted((WorkItem)event);
        } else {
            super.signalEvent(type, event);
        }
    }

    public String[] getEventTypes() {
        return new String[]{"workItemCompleted"};
    }

    public void workItemAborted(WorkItem workItem) {
        if (this.workItemId == workItem.getId() || this.workItemId == -1L && this.getWorkItem().getId() == workItem.getId()) {
            this.removeEventListeners();
            this.triggerCompleted(workItem);
        }
    }

    public void workItemCompleted(WorkItem workItem) {
        if (this.workItemId == workItem.getId() || this.workItemId == -1L && this.getWorkItem().getId() == workItem.getId()) {
            this.removeEventListeners();
            this.triggerCompleted(workItem);
        }
    }
}

