/*
 * Decompiled with CFR 0.152.
 */
package org.h2.fulltext;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.h2.api.Trigger;
import org.h2.command.Parser;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ValueExpression;
import org.h2.fulltext.FullTextSettings;
import org.h2.fulltext.IndexInfo;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.tools.SimpleResultSet;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullText {
    private static final String FIELD_SCHEMA = "SCHEMA";
    private static final String FIELD_TABLE = "TABLE";
    private static final String FIELD_COLUMNS = "COLUMNS";
    private static final String FIELD_KEYS = "KEYS";
    private static final String FIELD_SCORE = "SCORE";
    private static final String TRIGGER_PREFIX = "FT_";
    private static final String SCHEMA = "FT";
    private static final String SELECT_MAP_BY_WORD_ID = "SELECT ROWID FROM FT.MAP WHERE WORDID=?";
    private static final String SELECT_ROW_BY_ID = "SELECT KEY, INDEXID FROM FT.ROWS WHERE ID=?";
    private static final String FIELD_QUERY = "QUERY";

    public static void init(Connection connection) throws SQLException {
        String string;
        Object object;
        Statement statement = connection.createStatement();
        statement.execute("CREATE SCHEMA IF NOT EXISTS FT");
        statement.execute("CREATE TABLE IF NOT EXISTS FT.INDEXES(ID INT AUTO_INCREMENT PRIMARY KEY, SCHEMA VARCHAR, TABLE VARCHAR, COLUMNS VARCHAR, UNIQUE(SCHEMA, TABLE))");
        statement.execute("CREATE TABLE IF NOT EXISTS FT.WORDS(ID INT AUTO_INCREMENT PRIMARY KEY, NAME VARCHAR, UNIQUE(NAME))");
        statement.execute("CREATE TABLE IF NOT EXISTS FT.ROWS(ID IDENTITY, HASH INT, INDEXID INT, KEY VARCHAR, UNIQUE(HASH, INDEXID, KEY))");
        statement.execute("CREATE TABLE IF NOT EXISTS FT.MAP(ROWID INT, WORDID INT, PRIMARY KEY(WORDID, ROWID))");
        statement.execute("CREATE TABLE IF NOT EXISTS FT.IGNORELIST(LIST VARCHAR)");
        statement.execute("CREATE TABLE IF NOT EXISTS FT.SETTINGS(KEY VARCHAR PRIMARY KEY, VALUE VARCHAR)");
        statement.execute("CREATE ALIAS IF NOT EXISTS FT_CREATE_INDEX FOR \"" + FullText.class.getName() + ".createIndex\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FT_DROP_INDEX FOR \"" + FullText.class.getName() + ".dropIndex\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FT_SEARCH FOR \"" + FullText.class.getName() + ".search\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FT_SEARCH_DATA FOR \"" + FullText.class.getName() + ".searchData\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FT_REINDEX FOR \"" + FullText.class.getName() + ".reindex\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FT_DROP_ALL FOR \"" + FullText.class.getName() + ".dropAll\"");
        FullTextSettings fullTextSettings = FullTextSettings.getInstance(connection);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM FT.IGNORELIST");
        while (resultSet.next()) {
            object = resultSet.getString(1);
            FullText.setIgnoreList(fullTextSettings, (String)object);
        }
        resultSet = statement.executeQuery("SELECT * FROM FT.SETTINGS");
        while (resultSet.next()) {
            object = resultSet.getString(1);
            if (!"whitespaceChars".equals(object)) continue;
            string = resultSet.getString(2);
            fullTextSettings.setWhitespaceChars(string);
        }
        resultSet = statement.executeQuery("SELECT * FROM FT.WORDS");
        object = fullTextSettings.getWordList();
        while (resultSet.next()) {
            string = resultSet.getString("NAME");
            int n = resultSet.getInt("ID");
            if ((string = fullTextSettings.convertWord(string)) == null) continue;
            ((HashMap)object).put(string, n);
        }
        fullTextSettings.setInitialized(true);
    }

    public static void createIndex(Connection connection, String string, String string2, String string3) throws SQLException {
        FullText.init(connection);
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO FT.INDEXES(SCHEMA, TABLE, COLUMNS) VALUES(?, ?, ?)");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        preparedStatement.execute();
        FullText.createTrigger(connection, string, string2);
        FullText.indexExistingRows(connection, string, string2);
    }

    public static void reindex(Connection connection) throws SQLException {
        FullText.init(connection);
        FullText.removeAllTriggers(connection, TRIGGER_PREFIX);
        FullTextSettings fullTextSettings = FullTextSettings.getInstance(connection);
        fullTextSettings.getWordList().clear();
        Statement statement = connection.createStatement();
        statement.execute("TRUNCATE TABLE FT.WORDS");
        statement.execute("TRUNCATE TABLE FT.ROWS");
        statement.execute("TRUNCATE TABLE FT.MAP");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM FT.INDEXES");
        while (resultSet.next()) {
            String string = resultSet.getString(FIELD_SCHEMA);
            String string2 = resultSet.getString(FIELD_TABLE);
            FullText.createTrigger(connection, string, string2);
            FullText.indexExistingRows(connection, string, string2);
        }
    }

    public static void dropIndex(Connection connection, String string, String string2) throws SQLException {
        int n;
        FullText.init(connection);
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT ID FROM FT.INDEXES WHERE SCHEMA=? AND TABLE=?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            return;
        }
        int n2 = resultSet.getInt(1);
        preparedStatement = connection.prepareStatement("DELETE FROM FT.INDEXES WHERE ID=?");
        preparedStatement.setInt(1, n2);
        preparedStatement.execute();
        FullText.createOrDropTrigger(connection, string, string2, false);
        preparedStatement = connection.prepareStatement("DELETE FROM FT.ROWS WHERE INDEXID=? AND ROWNUM<10000");
        do {
            preparedStatement.setInt(1, n2);
        } while ((n = preparedStatement.executeUpdate()) != 0);
        preparedStatement = connection.prepareStatement("DELETE FROM FT.MAP M WHERE NOT EXISTS (SELECT * FROM FT.ROWS R WHERE R.ID=M.ROWID) AND ROWID<10000");
        while ((n = preparedStatement.executeUpdate()) != 0) {
        }
    }

    public static void dropAll(Connection connection) throws SQLException {
        FullText.init(connection);
        Statement statement = connection.createStatement();
        statement.execute("DROP SCHEMA IF EXISTS FT");
        FullText.removeAllTriggers(connection, TRIGGER_PREFIX);
        FullTextSettings fullTextSettings = FullTextSettings.getInstance(connection);
        fullTextSettings.removeAllIndexes();
        fullTextSettings.getIgnoreList().clear();
        fullTextSettings.getWordList().clear();
    }

    public static ResultSet search(Connection connection, String string, int n, int n2) throws SQLException {
        try {
            return FullText.search(connection, string, n, n2, false);
        }
        catch (DbException dbException) {
            throw DbException.toSQLException(dbException);
        }
    }

    public static ResultSet searchData(Connection connection, String string, int n, int n2) throws SQLException {
        try {
            return FullText.search(connection, string, n, n2, true);
        }
        catch (DbException dbException) {
            throw DbException.toSQLException(dbException);
        }
    }

    public static void setIgnoreList(Connection connection, String string) throws SQLException {
        try {
            FullText.init(connection);
            FullTextSettings fullTextSettings = FullTextSettings.getInstance(connection);
            FullText.setIgnoreList(fullTextSettings, string);
            Statement statement = connection.createStatement();
            statement.execute("TRUNCATE TABLE FT.IGNORELIST");
            PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO FT.IGNORELIST VALUES(?)");
            preparedStatement.setString(1, string);
            preparedStatement.execute();
        }
        catch (DbException dbException) {
            throw DbException.toSQLException(dbException);
        }
    }

    public static void setWhitespaceChars(Connection connection, String string) throws SQLException {
        try {
            FullText.init(connection);
            FullTextSettings fullTextSettings = FullTextSettings.getInstance(connection);
            fullTextSettings.setWhitespaceChars(string);
            PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO FT.SETTINGS VALUES(?, ?)");
            preparedStatement.setString(1, "whitespaceChars");
            preparedStatement.setString(2, string);
            preparedStatement.execute();
        }
        catch (DbException dbException) {
            throw DbException.toSQLException(dbException);
        }
    }

    protected static String asString(Object object, int n) throws SQLException {
        if (object == null) {
            return "NULL";
        }
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                return object.toString();
            }
            case 2005: {
                try {
                    if (object instanceof Clob) {
                        object = ((Clob)object).getCharacterStream();
                    }
                    return IOUtils.readStringAndClose((Reader)object, -1);
                }
                catch (IOException iOException) {
                    throw DbException.toSQLException(iOException);
                }
            }
            case -4: 
            case -3: 
            case -2: 
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2006: {
                throw FullText.throwException("Unsupported column data type: " + n);
            }
        }
        return "";
    }

    protected static SimpleResultSet createResultSet(boolean bl) {
        SimpleResultSet simpleResultSet = new SimpleResultSet();
        if (bl) {
            simpleResultSet.addColumn(FIELD_SCHEMA, 12, 0, 0);
            simpleResultSet.addColumn(FIELD_TABLE, 12, 0, 0);
            simpleResultSet.addColumn(FIELD_COLUMNS, 2003, 0, 0);
            simpleResultSet.addColumn(FIELD_KEYS, 2003, 0, 0);
        } else {
            simpleResultSet.addColumn(FIELD_QUERY, 12, 0, 0);
        }
        simpleResultSet.addColumn(FIELD_SCORE, 6, 0, 0);
        return simpleResultSet;
    }

    protected static Object[][] parseKey(Connection connection, String string) {
        ArrayList<String> arrayList = New.arrayList();
        ArrayList<String> arrayList2 = New.arrayList();
        JdbcConnection jdbcConnection2 = (JdbcConnection)connection;
        Session session = (Session)jdbcConnection2.getSession();
        Parser parser = new Parser(session);
        Expression expression = parser.parseExpression(string);
        FullText.addColumnData(arrayList, arrayList2, expression);
        Object[] objectArray = new Object[arrayList.size()];
        arrayList.toArray(objectArray);
        Object[] objectArray2 = new Object[arrayList.size()];
        arrayList2.toArray(objectArray2);
        Object[][] objectArray3 = new Object[][]{objectArray, objectArray2};
        return objectArray3;
    }

    protected static String quoteSQL(Object object, int n) throws SQLException {
        if (object == null) {
            return "NULL";
        }
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                return object.toString();
            }
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return FullText.quoteString(object.toString());
            }
            case -4: 
            case -3: 
            case -2: {
                return "'" + StringUtils.convertBytesToHex((byte[])object) + "'";
            }
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                throw FullText.throwException("Unsupported key data type: " + n);
            }
        }
        return "";
    }

    protected static void removeAllTriggers(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM INFORMATION_SCHEMA.TRIGGERS");
        Statement statement2 = connection.createStatement();
        while (resultSet.next()) {
            String string2 = resultSet.getString("TRIGGER_SCHEMA");
            String string3 = resultSet.getString("TRIGGER_NAME");
            if (!string3.startsWith(string)) continue;
            string3 = StringUtils.quoteIdentifier(string2) + "." + StringUtils.quoteIdentifier(string3);
            statement2.execute("DROP TRIGGER " + string3);
        }
    }

    protected static void setColumns(int[] nArray, ArrayList<String> arrayList, ArrayList<String> arrayList2) throws SQLException {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string = arrayList.get(i);
            int n2 = -1;
            int n3 = arrayList2.size();
            for (int j = 0; n2 == -1 && j < n3; ++j) {
                String string2 = arrayList2.get(j);
                if (!string2.equals(string)) continue;
                n2 = j;
            }
            if (n2 < 0) {
                throw FullText.throwException("Column not found: " + string);
            }
            nArray[i] = n2;
        }
    }

    protected static ResultSet search(Connection connection, String string, int n, int n2, boolean bl) throws SQLException {
        Object object;
        Object object2;
        SimpleResultSet simpleResultSet = FullText.createResultSet(bl);
        if (connection.getMetaData().getURL().startsWith("jdbc:columnlist:")) {
            return simpleResultSet;
        }
        if (string == null || string.trim().length() == 0) {
            return simpleResultSet;
        }
        FullTextSettings fullTextSettings = FullTextSettings.getInstance(connection);
        if (!fullTextSettings.isInitialized()) {
            FullText.init(connection);
        }
        HashSet<String> hashSet = New.hashSet();
        FullText.addWords(fullTextSettings, hashSet, string);
        HashSet hashSet2 = null;
        HashSet hashSet3 = null;
        HashMap<String, Integer> hashMap = fullTextSettings.getWordList();
        PreparedStatement preparedStatement = fullTextSettings.prepare(connection, SELECT_MAP_BY_WORD_ID);
        for (String string2 : hashSet) {
            hashSet3 = hashSet2;
            hashSet2 = New.hashSet();
            object2 = hashMap.get(string2);
            if (object2 == null) continue;
            preparedStatement.setInt(1, (Integer)object2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getInt(1);
                if (hashSet3 != null && !hashSet3.contains(object)) continue;
                hashSet2.add(object);
            }
        }
        if (hashSet2 == null || hashSet2.size() == 0) {
            return simpleResultSet;
        }
        PreparedStatement preparedStatement2 = fullTextSettings.prepare(connection, SELECT_ROW_BY_ID);
        int n3 = 0;
        object2 = hashSet2.iterator();
        while (object2.hasNext()) {
            Object object3;
            int n4 = (Integer)object2.next();
            preparedStatement2.setInt(1, n4);
            object = preparedStatement2.executeQuery();
            if (!object.next()) continue;
            if (n2 > 0) {
                --n2;
                continue;
            }
            String string3 = object.getString(1);
            int n5 = object.getInt(2);
            IndexInfo indexInfo = fullTextSettings.getIndexInfo(n5);
            if (bl) {
                object3 = FullText.parseKey(connection, string3);
                simpleResultSet.addRow(indexInfo.schema, indexInfo.table, object3[0], object3[1], 1.0);
            } else {
                object3 = StringUtils.quoteIdentifier(indexInfo.schema) + "." + StringUtils.quoteIdentifier(indexInfo.table) + " WHERE " + string3;
                simpleResultSet.addRow(object3, 1.0);
            }
            if (n <= 0 || ++n3 < n) continue;
            break;
        }
        return simpleResultSet;
    }

    private static void addColumnData(ArrayList<String> arrayList, ArrayList<String> arrayList2, Expression expression) {
        if (expression instanceof ConditionAndOr) {
            ConditionAndOr conditionAndOr = (ConditionAndOr)expression;
            Expression expression2 = conditionAndOr.getExpression(true);
            Expression expression3 = conditionAndOr.getExpression(false);
            FullText.addColumnData(arrayList, arrayList2, expression2);
            FullText.addColumnData(arrayList, arrayList2, expression3);
        } else {
            Comparison comparison = (Comparison)expression;
            ExpressionColumn expressionColumn = (ExpressionColumn)comparison.getExpression(true);
            ValueExpression valueExpression = (ValueExpression)comparison.getExpression(false);
            String string = expressionColumn.getColumnName();
            arrayList.add(string);
            if (valueExpression == null) {
                arrayList2.add(null);
            } else {
                arrayList2.add(valueExpression.getValue(null).getString());
            }
        }
    }

    protected static void addWords(FullTextSettings fullTextSettings, HashSet<String> hashSet, Reader reader) {
        char[] cArray;
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(33, 255);
        for (char c : cArray = fullTextSettings.getWhitespaceChars().toCharArray()) {
            streamTokenizer.whitespaceChars(c, c);
        }
        try {
            int n;
            while ((n = streamTokenizer.nextToken()) != -1) {
                if (n != -3) continue;
                String string = streamTokenizer.sval;
                if ((string = fullTextSettings.convertWord(string)) == null) continue;
                hashSet.add(string);
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, "Tokenizer error");
        }
    }

    protected static void addWords(FullTextSettings fullTextSettings, HashSet<String> hashSet, String string) {
        String string2 = fullTextSettings.getWhitespaceChars();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if ((string3 = fullTextSettings.convertWord(string3)) == null) continue;
            hashSet.add(string3);
        }
    }

    protected static void createTrigger(Connection connection, String string, String string2) throws SQLException {
        FullText.createOrDropTrigger(connection, string, string2, true);
    }

    private static void createOrDropTrigger(Connection connection, String string, String string2, boolean bl) throws SQLException {
        Statement statement = connection.createStatement();
        String string3 = StringUtils.quoteIdentifier(string) + "." + StringUtils.quoteIdentifier(TRIGGER_PREFIX + string2);
        statement.execute("DROP TRIGGER IF EXISTS " + string3);
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder("CREATE TRIGGER IF NOT EXISTS ");
            stringBuilder.append(string3).append(" AFTER INSERT, UPDATE, DELETE, ROLLBACK ON ").append(StringUtils.quoteIdentifier(string)).append('.').append(StringUtils.quoteIdentifier(string2)).append(" FOR EACH ROW CALL \"").append(FullTextTrigger.class.getName()).append('\"');
            statement.execute(stringBuilder.toString());
        }
    }

    protected static void indexExistingRows(Connection connection, String string, String string2) throws SQLException {
        FullTextTrigger fullTextTrigger = new FullTextTrigger();
        fullTextTrigger.init(connection, string, null, string2, false, 1);
        String string3 = "SELECT * FROM " + StringUtils.quoteIdentifier(string) + "." + StringUtils.quoteIdentifier(string2);
        ResultSet resultSet = connection.createStatement().executeQuery(string3);
        int n = resultSet.getMetaData().getColumnCount();
        while (resultSet.next()) {
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = resultSet.getObject(i + 1);
            }
            fullTextTrigger.fire(connection, null, objectArray);
        }
    }

    private static String quoteString(String string) {
        if (string.indexOf(39) < 0) {
            return "'" + string + "'";
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 2);
        stringBuilder.append('\'');
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                stringBuilder.append(c);
            }
            stringBuilder.append(c);
        }
        stringBuilder.append('\'');
        return stringBuilder.toString();
    }

    private static void setIgnoreList(FullTextSettings fullTextSettings, String string) {
        String[] stringArray = StringUtils.arraySplit(string, ',', true);
        HashSet<String> hashSet = fullTextSettings.getIgnoreList();
        for (String string2 : stringArray) {
            String string3 = fullTextSettings.convertWord(string2);
            if (string3 == null) continue;
            hashSet.add(string3);
        }
    }

    protected static boolean hasChanged(Object[] objectArray, Object[] objectArray2, int[] nArray) {
        for (int n : nArray) {
            Object object = objectArray[n];
            Object object2 = objectArray2[n];
            if (!(object == null ? object2 != null : !object.equals(object2))) continue;
            return true;
        }
        return false;
    }

    public static void closeAll() {
        FullTextSettings.closeAll();
    }

    protected static SQLException throwException(String string) throws SQLException {
        throw new SQLException(string, "FULLTEXT");
    }

    public static class FullTextTrigger
    implements Trigger {
        protected FullTextSettings setting;
        protected IndexInfo index;
        protected int[] columnTypes;
        protected PreparedStatement prepInsertWord;
        protected PreparedStatement prepInsertRow;
        protected PreparedStatement prepInsertMap;
        protected PreparedStatement prepDeleteRow;
        protected PreparedStatement prepDeleteMap;
        protected PreparedStatement prepSelectRow;

        public void init(Connection connection, String string, String string2, String string3, boolean bl, int n) throws SQLException {
            this.setting = FullTextSettings.getInstance(connection);
            if (!this.setting.isInitialized()) {
                FullText.init(connection);
            }
            ArrayList<String> arrayList = New.arrayList();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getColumns(null, JdbcUtils.escapeMetaDataPattern(string), JdbcUtils.escapeMetaDataPattern(string3), null);
            ArrayList<String> arrayList2 = New.arrayList();
            while (resultSet.next()) {
                arrayList2.add(resultSet.getString("COLUMN_NAME"));
            }
            this.columnTypes = new int[arrayList2.size()];
            this.index = new IndexInfo();
            this.index.schema = string;
            this.index.table = string3;
            this.index.columns = new String[arrayList2.size()];
            arrayList2.toArray(this.index.columns);
            resultSet = databaseMetaData.getColumns(null, JdbcUtils.escapeMetaDataPattern(string), JdbcUtils.escapeMetaDataPattern(string3), null);
            int n2 = 0;
            while (resultSet.next()) {
                this.columnTypes[n2] = resultSet.getInt("DATA_TYPE");
                ++n2;
            }
            if (arrayList.size() == 0) {
                resultSet = databaseMetaData.getPrimaryKeys(null, JdbcUtils.escapeMetaDataPattern(string), string3);
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString("COLUMN_NAME"));
                }
            }
            if (arrayList.size() == 0) {
                throw FullText.throwException("No primary key for table " + string3);
            }
            ArrayList<String> arrayList3 = New.arrayList();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT ID, COLUMNS FROM FT.INDEXES WHERE SCHEMA=? AND TABLE=?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string3);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                this.index.id = resultSet.getInt(1);
                String string4 = resultSet.getString(2);
                if (string4 != null) {
                    for (String string5 : StringUtils.arraySplit(string4, ',', true)) {
                        arrayList3.add(string5);
                    }
                }
            }
            if (arrayList3.size() == 0) {
                arrayList3.addAll(arrayList2);
            }
            this.index.keys = new int[arrayList.size()];
            FullText.setColumns(this.index.keys, arrayList, arrayList2);
            this.index.indexColumns = new int[arrayList3.size()];
            FullText.setColumns(this.index.indexColumns, arrayList3, arrayList2);
            this.setting.addIndexInfo(this.index);
            this.prepInsertWord = connection.prepareStatement("INSERT INTO FT.WORDS(NAME) VALUES(?)");
            this.prepInsertRow = connection.prepareStatement("INSERT INTO FT.ROWS(HASH, INDEXID, KEY) VALUES(?, ?, ?)");
            this.prepInsertMap = connection.prepareStatement("INSERT INTO FT.MAP(ROWID, WORDID) VALUES(?, ?)");
            this.prepDeleteRow = connection.prepareStatement("DELETE FROM FT.ROWS WHERE HASH=? AND INDEXID=? AND KEY=?");
            this.prepDeleteMap = connection.prepareStatement("DELETE FROM FT.MAP WHERE ROWID=? AND WORDID=?");
            this.prepSelectRow = connection.prepareStatement("SELECT ID FROM FT.ROWS WHERE HASH=? AND INDEXID=? AND KEY=?");
        }

        public void fire(Connection connection, Object[] objectArray, Object[] objectArray2) throws SQLException {
            if (objectArray != null) {
                if (objectArray2 != null) {
                    if (FullText.hasChanged(objectArray, objectArray2, this.index.indexColumns)) {
                        this.delete(objectArray);
                        this.insert(objectArray2);
                    }
                } else {
                    this.delete(objectArray);
                }
            } else if (objectArray2 != null) {
                this.insert(objectArray2);
            }
        }

        public void close() {
            this.setting.removeIndexInfo(this.index);
        }

        public void remove() {
            this.setting.removeIndexInfo(this.index);
        }

        protected void insert(Object[] objectArray) throws SQLException {
            int[] nArray;
            String string = this.getKey(objectArray);
            int n = string.hashCode();
            this.prepInsertRow.setInt(1, n);
            this.prepInsertRow.setInt(2, this.index.id);
            this.prepInsertRow.setString(3, string);
            this.prepInsertRow.execute();
            ResultSet resultSet = this.prepInsertRow.getGeneratedKeys();
            resultSet.next();
            int n2 = resultSet.getInt(1);
            this.prepInsertMap.setInt(1, n2);
            for (int n3 : nArray = this.getWordIds(objectArray)) {
                this.prepInsertMap.setInt(2, n3);
                this.prepInsertMap.execute();
            }
        }

        protected void delete(Object[] objectArray) throws SQLException {
            String string = this.getKey(objectArray);
            int n = string.hashCode();
            this.prepSelectRow.setInt(1, n);
            this.prepSelectRow.setInt(2, this.index.id);
            this.prepSelectRow.setString(3, string);
            ResultSet resultSet = this.prepSelectRow.executeQuery();
            if (resultSet.next()) {
                int[] nArray;
                int n2 = resultSet.getInt(1);
                this.prepDeleteMap.setInt(1, n2);
                for (int n3 : nArray = this.getWordIds(objectArray)) {
                    this.prepDeleteMap.setInt(2, n3);
                    this.prepDeleteMap.executeUpdate();
                }
                this.prepDeleteRow.setInt(1, n);
                this.prepDeleteRow.setInt(2, this.index.id);
                this.prepDeleteRow.setString(3, string);
                this.prepDeleteRow.executeUpdate();
            }
        }

        private int[] getWordIds(Object[] objectArray) throws SQLException {
            Object object;
            int n2;
            HashSet<String> hashSet = New.hashSet();
            for (int n2 : this.index.indexColumns) {
                Object object2;
                int n3 = this.columnTypes[n2];
                object = objectArray[n2];
                if (n3 == 2005 && object != null) {
                    object2 = object instanceof Reader ? (Reader)object : ((Clob)object).getCharacterStream();
                    FullText.addWords(this.setting, hashSet, (Reader)object2);
                    continue;
                }
                object2 = FullText.asString(object, n3);
                FullText.addWords(this.setting, hashSet, (String)object2);
            }
            Object object3 = this.setting.getWordList();
            int[] nArray = new int[hashSet.size()];
            Iterator iterator = hashSet.iterator();
            n2 = 0;
            while (iterator.hasNext()) {
                int n4;
                String string = (String)iterator.next();
                object = (Integer)((HashMap)object3).get(string);
                if (object == null) {
                    this.prepInsertWord.setString(1, string);
                    this.prepInsertWord.execute();
                    ResultSet resultSet = this.prepInsertWord.getGeneratedKeys();
                    resultSet.next();
                    n4 = resultSet.getInt(1);
                    ((HashMap)object3).put(string, n4);
                } else {
                    n4 = (Integer)object;
                }
                nArray[n2] = n4;
                ++n2;
            }
            Arrays.sort(nArray);
            return nArray;
        }

        private String getKey(Object[] objectArray) throws SQLException {
            StatementBuilder statementBuilder = new StatementBuilder();
            for (int n : this.index.keys) {
                statementBuilder.appendExceptFirst(" AND ");
                statementBuilder.append(StringUtils.quoteIdentifier(this.index.columns[n]));
                Object object = objectArray[n];
                if (object == null) {
                    statementBuilder.append(" IS NULL");
                    continue;
                }
                statementBuilder.append('=').append(FullText.quoteSQL(object, this.columnTypes[n]));
            }
            return statementBuilder.toString();
        }
    }
}

