/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.util.IOUtils;
import org.h2.util.Task;
import org.h2.value.Value;

public class JdbcClob
extends TraceObject
implements Clob {
    Value value;
    private JdbcConnection conn;

    public JdbcClob(JdbcConnection jdbcConnection2, Value value, int n) {
        this.setTrace(jdbcConnection2.getSession().getTrace(), 10, n);
        this.conn = jdbcConnection2;
        this.value = value;
    }

    public long length() throws SQLException {
        try {
            long l;
            this.debugCodeCall("length");
            this.checkClosed();
            if (this.value.getType() == 16 && (l = this.value.getPrecision()) > 0L) {
                return l;
            }
            return IOUtils.copyAndCloseInput(this.value.getReader(), null, Long.MAX_VALUE);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void truncate(long l) throws SQLException {
        throw this.unsupported("LOB update");
    }

    public InputStream getAsciiStream() throws SQLException {
        try {
            this.debugCodeCall("getAsciiStream");
            this.checkClosed();
            String string = this.value.getString();
            return IOUtils.getInputStreamFromString(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        throw this.unsupported("LOB update");
    }

    public Reader getCharacterStream() throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream");
            this.checkClosed();
            return this.value.getReader();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public Writer setCharacterStream(long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("setCharacterStream(" + l + ");");
            }
            this.checkClosed();
            if (l != 1L) {
                throw DbException.getInvalidValueException("pos", l);
            }
            if (this.value.getPrecision() != 0L) {
                throw DbException.getInvalidValueException("length", this.value.getPrecision());
            }
            final JdbcConnection jdbcConnection2 = this.conn;
            final PipedInputStream pipedInputStream = new PipedInputStream();
            final Task task = new Task(){

                public void call() {
                    JdbcClob.this.value = jdbcConnection2.createClob(IOUtils.getReader(pipedInputStream), -1L);
                }
            };
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream){

                public void close() throws IOException {
                    super.close();
                    try {
                        task.get();
                    }
                    catch (Exception exception) {
                        throw DbException.convertToIOException(exception);
                    }
                }
            };
            task.execute();
            return IOUtils.getBufferedWriter(pipedOutputStream);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubString(long l, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getSubString(" + l + ", " + n + ");");
            }
            this.checkClosed();
            if (l < 1L) {
                throw DbException.getInvalidValueException("pos", l);
            }
            if (n < 0) {
                throw DbException.getInvalidValueException("length", n);
            }
            StringWriter stringWriter = new StringWriter(Math.min(4096, n));
            Reader reader = this.value.getReader();
            try {
                IOUtils.skipFully(reader, l - 1L);
                IOUtils.copyAndCloseInput(reader, stringWriter, n);
            }
            finally {
                reader.close();
            }
            return stringWriter.toString();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int setString(long l, String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setString(" + l + ", " + JdbcClob.quote(string) + ");");
            }
            this.checkClosed();
            if (l != 1L) {
                throw DbException.getInvalidValueException("pos", l);
            }
            if (string == null) {
                throw DbException.getInvalidValueException("str", string);
            }
            this.value = this.conn.createClob(new StringReader(string), -1L);
            return string.length();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        throw this.unsupported("LOB update");
    }

    public long position(String string, long l) throws SQLException {
        throw this.unsupported("LOB search");
    }

    public long position(Clob clob, long l) throws SQLException {
        throw this.unsupported("LOB search");
    }

    public void free() {
        this.debugCodeCall("free");
        this.value = null;
    }

    private void checkClosed() {
        this.conn.checkClosed();
        if (this.value == null) {
            throw DbException.get(90007);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + (this.value == null ? "null" : this.value.getTraceSQL());
    }
}

