/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.h2.Driver;
import org.h2.constant.SysProperties;
import org.h2.jdbcx.JdbcDataSource;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDataSourceFactory
implements ObjectFactory {
    private static TraceSystem cachedTraceSystem;
    private Trace trace = JdbcDataSourceFactory.getTraceSystem().getTrace("JDBCX");

    @Override
    public synchronized Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) {
        Reference reference;
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("getObjectInstance obj={0} name={1} nameCtx={2} environment={3}", object, name, context, hashtable);
        }
        if (object instanceof Reference && (reference = (Reference)object).getClassName().equals(JdbcDataSource.class.getName())) {
            JdbcDataSource jdbcDataSource2 = new JdbcDataSource();
            jdbcDataSource2.setURL((String)reference.get("url").getContent());
            jdbcDataSource2.setUser((String)reference.get("user").getContent());
            jdbcDataSource2.setPassword((String)reference.get("password").getContent());
            jdbcDataSource2.setDescription((String)reference.get("description").getContent());
            String string = (String)reference.get("loginTimeout").getContent();
            jdbcDataSource2.setLoginTimeout(Integer.parseInt(string));
            return jdbcDataSource2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TraceSystem getTraceSystem() {
        Class<JdbcDataSourceFactory> clazz = JdbcDataSourceFactory.class;
        synchronized (JdbcDataSourceFactory.class) {
            if (cachedTraceSystem == null) {
                cachedTraceSystem = new TraceSystem(SysProperties.CLIENT_TRACE_DIRECTORY + "h2datasource" + ".trace.db");
                cachedTraceSystem.setLevelFile(SysProperties.DATASOURCE_TRACE_LEVEL);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return cachedTraceSystem;
        }
    }

    Trace getTrace() {
        return this.trace;
    }

    static {
        Driver.load();
    }
}

