/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.util.StringTokenizer;
import javax.transaction.xa.Xid;
import org.h2.jdbcx.JdbcDataSourceFactory;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.util.StringUtils;

public class JdbcXid
extends TraceObject
implements Xid {
    private static final String PREFIX = "XID";
    private int formatId;
    private byte[] branchQualifier;
    private byte[] globalTransactionId;

    JdbcXid(JdbcDataSourceFactory jdbcDataSourceFactory2, int n, String string) {
        this.setTrace(jdbcDataSourceFactory2.getTrace(), 15, n);
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            String string2 = stringTokenizer.nextToken();
            if (!PREFIX.equals(string2)) {
                throw DbException.get(90101, string);
            }
            this.formatId = Integer.parseInt(stringTokenizer.nextToken());
            this.branchQualifier = StringUtils.convertHexToBytes(stringTokenizer.nextToken());
            this.globalTransactionId = StringUtils.convertHexToBytes(stringTokenizer.nextToken());
        }
        catch (RuntimeException runtimeException) {
            throw DbException.get(90101, string);
        }
    }

    public static String toString(Xid xid) {
        StringBuilder stringBuilder = new StringBuilder(PREFIX);
        stringBuilder.append('_').append(xid.getFormatId()).append('_').append(StringUtils.convertBytesToHex(xid.getBranchQualifier())).append('_').append(StringUtils.convertBytesToHex(xid.getGlobalTransactionId()));
        return stringBuilder.toString();
    }

    public int getFormatId() {
        this.debugCodeCall("getFormatId");
        return this.formatId;
    }

    public byte[] getBranchQualifier() {
        this.debugCodeCall("getBranchQualifier");
        return this.branchQualifier;
    }

    public byte[] getGlobalTransactionId() {
        this.debugCodeCall("getGlobalTransactionId");
        return this.globalTransactionId;
    }
}

