/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.ConfigurationException;
import org.mule.config.ReaderResource;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.config.i18n.CoreMessages;
import org.mule.umo.manager.UMOManager;
import org.mule.util.ObjectUtils;
import org.mule.util.StringUtils;

public class MuleClasspathConfigurationBuilder
extends MuleXmlConfigurationBuilder {
    protected static final Log logger = LogFactory.getLog(MuleClasspathConfigurationBuilder.class);
    public static final String MULE_CONFIGURATION_RESOURCE = "mule-config.xml";

    public UMOManager configure(String configResources, String startupPropertiesFile) throws ConfigurationException {
        String[] resString;
        if (StringUtils.isBlank(configResources)) {
            configResources = MULE_CONFIGURATION_RESOURCE;
        }
        URL url = null;
        ArrayList<ReaderResource> list = new ArrayList<ReaderResource>();
        int i = 0;
        try {
            ClassLoader cl;
            resString = StringUtils.splitAndTrim(configResources, ",");
            for (i = 0; i < resString.length && (cl = Thread.currentThread().getContextClassLoader()) != null && (url = cl.getResource(resString[i])) != null; ++i) {
                list.add(new ReaderResource(url.toExternalForm(), new InputStreamReader(url.openStream())));
            }
        }
        catch (IOException ioe) {
            throw new ConfigurationException(CoreMessages.failedToLoad("Config: " + ObjectUtils.toString(url, "null")), (Throwable)ioe);
        }
        if (list.size() != resString.length) {
            throw new ConfigurationException(CoreMessages.failedToLoad("Not all resources specified loaded: " + resString[i]));
        }
        ReaderResource[] resources = new ReaderResource[list.size()];
        resources = list.toArray(resources);
        this.configure(resources, null);
        return this.manager;
    }
}

