/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.tcp;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractPollingMessageReceiver;
import org.mule.providers.ConnectException;
import org.mule.providers.tcp.TcpConnector;
import org.mule.providers.tcp.TcpProtocol;
import org.mule.providers.tcp.i18n.TcpMessages;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.StringUtils;

public class TcpStreamingMessageReceiver
extends AbstractPollingMessageReceiver {
    protected Socket clientSocket = null;
    protected DataInputStream dataIn = null;
    protected TcpProtocol protocol = null;

    public TcpStreamingMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
        this.protocol = ((TcpConnector)connector).getTcpProtocol();
    }

    protected void doDispose() {
    }

    protected void doConnect() throws ConnectException {
        URI uri = this.endpoint.getEndpointURI().getUri();
        String host = StringUtils.defaultIfEmpty(uri.getHost(), "localhost");
        try {
            this.logger.debug("Attempting to connect to server socket");
            InetAddress inetAddress = InetAddress.getByName(host);
            this.clientSocket = new Socket(inetAddress, uri.getPort());
            TcpConnector connector = (TcpConnector)this.connector;
            this.clientSocket.setReceiveBufferSize(connector.getReceiveBufferSize());
            this.clientSocket.setSendBufferSize(connector.getSendBufferSize());
            this.clientSocket.setSoTimeout(connector.getReceiveTimeout());
            this.dataIn = new DataInputStream(new BufferedInputStream(this.clientSocket.getInputStream()));
            this.logger.debug("Connected to server socket");
        }
        catch (Exception e) {
            throw new ConnectException(TcpMessages.failedToBindToUri(uri), e, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDisconnect() throws Exception {
        try {
            if (this.clientSocket != null && !this.clientSocket.isClosed()) {
                this.clientSocket.shutdownInput();
                this.clientSocket.shutdownOutput();
                this.clientSocket.close();
            }
            Object var2_1 = null;
            this.clientSocket = null;
            this.dataIn = null;
            this.logger.info("Closed tcp client socket");
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.clientSocket = null;
            this.dataIn = null;
            this.logger.info("Closed tcp client socket");
            throw throwable;
        }
    }

    public void poll() throws Exception {
        this.setFrequency(0L);
        byte[] data = (byte[])this.protocol.read(this.dataIn);
        if (data != null) {
            UMOMessageAdapter adapter = this.connector.getMessageAdapter(data);
            MuleMessage message = new MuleMessage(adapter);
            this.routeMessage((UMOMessage)message, this.endpoint.isSynchronous());
        }
    }
}

