/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.providers;

import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import java.beans.ExceptionListener;
import java.util.HashMap;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.config.i18n.MessageFactory;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.impl.model.seda.SedaModel;
import org.mule.providers.AbstractConnector;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.umo.UMOComponent;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOMessageDispatcherFactory;

public abstract class AbstractConnectorTestCase
extends AbstractMuleTestCase {
    private MuleDescriptor descriptor;
    private UMOConnector connector;
    private UMOModel model;

    public MuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public UMOModel getModel() {
        return this.model;
    }

    protected void doSetUp() throws Exception {
        UMOManager manager = AbstractConnectorTestCase.getManager(true);
        this.model = new SedaModel();
        this.model.setName("default");
        manager.registerModel(this.model);
        this.descriptor = AbstractConnectorTestCase.getTestDescriptor("apple", Apple.class.getName());
        MuleManager.getInstance().start();
        this.connector = this.createConnector();
    }

    protected void doTearDown() throws Exception {
        if (!this.connector.isDisposed()) {
            this.connector.dispose();
        }
    }

    public void testConnectorExceptionHandling() throws Exception {
        AbstractConnectorTestCase.assertNotNull(this.connector);
        Mock ehandlerMock = new Mock(ExceptionListener.class, "exceptionHandler");
        ehandlerMock.expect("exceptionThrown", C.isA(Exception.class));
        AbstractConnectorTestCase.assertNotNull(this.connector.getExceptionListener());
        this.connector.setExceptionListener((ExceptionListener)ehandlerMock.proxy());
        this.connector.handleException(new MuleException(MessageFactory.createStaticMessage("Dummy")));
        if (this.connector instanceof AbstractConnector) {
            ehandlerMock.expect("exceptionThrown", C.isA(Exception.class));
            ((AbstractConnector)this.connector).exceptionThrown(new MuleException(MessageFactory.createStaticMessage("Dummy")));
        }
        ehandlerMock.verify();
        this.connector.setExceptionListener(null);
        try {
            this.connector.handleException(new MuleException(MessageFactory.createStaticMessage("Dummy")));
            AbstractConnectorTestCase.fail("Should have thrown exception as no strategy is set");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testConnectorLifecycle() throws Exception {
        AbstractConnectorTestCase.assertNotNull(this.connector);
        AbstractConnectorTestCase.assertTrue(!this.connector.isStarted());
        AbstractConnectorTestCase.assertTrue(!this.connector.isDisposed());
        this.connector.startConnector();
        AbstractConnectorTestCase.assertTrue(this.connector.isStarted());
        AbstractConnectorTestCase.assertTrue(!this.connector.isDisposed());
        this.connector.stopConnector();
        AbstractConnectorTestCase.assertTrue(!this.connector.isStarted());
        AbstractConnectorTestCase.assertTrue(!this.connector.isDisposed());
        this.connector.dispose();
        AbstractConnectorTestCase.assertTrue(!this.connector.isStarted());
        AbstractConnectorTestCase.assertTrue(this.connector.isDisposed());
        try {
            this.connector.startConnector();
            AbstractConnectorTestCase.fail("Connector cannot be restarted after being disposing");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testConnectorListenerSupport() throws Exception {
        AbstractConnectorTestCase.assertNotNull(this.connector);
        MuleDescriptor d = AbstractConnectorTestCase.getTestDescriptor("anApple", Apple.class.getName());
        UMOComponent component = this.model.registerComponent(d);
        MuleEndpoint endpoint = new MuleEndpoint("test", new MuleEndpointURI(this.getTestEndpointURI()), this.connector, null, "sender", 0, null, new HashMap());
        try {
            this.connector.registerListener(null, null);
            AbstractConnectorTestCase.fail("cannot register null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.connector.registerListener(null, endpoint);
            AbstractConnectorTestCase.fail("cannot register null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.connector.registerListener(component, null);
            AbstractConnectorTestCase.fail("cannot register null");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.connector.registerListener(component, endpoint);
        this.connector.unregisterListener(component, endpoint);
        try {
            this.connector.unregisterListener(null, null);
            AbstractConnectorTestCase.fail("cannot unregister null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.connector.unregisterListener(component, null);
            AbstractConnectorTestCase.fail("cannot unregister null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.connector.unregisterListener(null, endpoint);
            AbstractConnectorTestCase.fail("cannot unregister null");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.connector.unregisterListener(component, endpoint);
        this.model.unregisterComponent(d);
    }

    public void testConnectorBeanProps() throws Exception {
        AbstractConnectorTestCase.assertNotNull(this.connector);
        try {
            this.connector.setName(null);
            AbstractConnectorTestCase.fail("Should throw IllegalArgumentException if name set to null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.connector.setName("Test");
        AbstractConnectorTestCase.assertEquals("Test", this.connector.getName());
        AbstractConnectorTestCase.assertNotNull("Protocol must be set as a constant", this.connector.getProtocol());
    }

    public void testConnectorMessageAdapter() throws Exception {
        UMOConnector connector = this.getConnector();
        AbstractConnectorTestCase.assertNotNull(connector);
        UMOMessageAdapter adapter = connector.getMessageAdapter(this.getValidMessage());
        AbstractConnectorTestCase.assertNotNull(adapter);
    }

    public void testConnectorMessageDispatcherFactory() throws Exception {
        UMOConnector connector = this.getConnector();
        AbstractConnectorTestCase.assertNotNull(connector);
        UMOMessageDispatcherFactory factory = connector.getDispatcherFactory();
        AbstractConnectorTestCase.assertNotNull(factory);
    }

    public void testConnectorInitialise() throws Exception {
        UMOConnector connector = this.getConnector();
        try {
            connector.initialise();
            AbstractConnectorTestCase.fail("A connector cannot be initialised more than once");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract UMOConnector createConnector() throws Exception;

    public abstract Object getValidMessage() throws Exception;

    public abstract String getTestEndpointURI();
}

