/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.tests.dbfill;

import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.ow2.jasmine.monitoring.tests.dbfill.JTEventConfig;
import org.ow2.jasmine.monitoring.tests.dbfill.generated.DbfillConfig;
import org.ow2.jasmine.monitoring.tests.dbfill.generated.Event;
import org.ow2.jasmine.monitoring.tests.dbfill.generated.ObjectFactory;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class DbFillConfig {
    static final String CONF_FILE_PROPERTY_NAME = "dbfill.config";
    static final String DEFAULT_CONFIG_FILE_NAME = "dbfill-config.xml";
    static final String DATE_FORMAT = "yyyy/MM/dd HH:mm";
    private Log logger = LogFactory.getLog(DbFillConfig.class);
    private String domain = "domain-test";
    private String server = "server-test";
    private String sName = "sName-test";
    private String source = "source-test";
    private long timeFrom;
    private long timeTo;
    private List<JTEventConfig> eventCfgList = new ArrayList<JTEventConfig>();

    public DbFillConfig() {
        try {
            InputStream configFile;
            String fName = System.getProperty(CONF_FILE_PROPERTY_NAME);
            if (fName == null) {
                fName = "dbfill.jar:dbfill-config.xml";
                configFile = DbFillConfig.class.getClassLoader().getResourceAsStream(DEFAULT_CONFIG_FILE_NAME);
            } else {
                configFile = new FileInputStream(fName);
            }
            this.logger.info(">> Configuration file = " + fName, new Object[0]);
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
            JAXBContext jaxbContext = JAXBContext.newInstance(ObjectFactory.class);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            DbfillConfig dbfillConfig = (DbfillConfig)unmarshaller.unmarshal(configFile);
            this.domain = dbfillConfig.getDomain();
            this.server = dbfillConfig.getServer();
            this.sName = dbfillConfig.getSname();
            this.source = dbfillConfig.getSource();
            String sFrom = dbfillConfig.getTimeFrom();
            Date dateFrom = (Date)formatter.parseObject(sFrom);
            this.timeFrom = dateFrom.getTime();
            String sTo = dbfillConfig.getTimeTo();
            Date dateTo = (Date)formatter.parseObject(sTo);
            this.timeTo = dateTo.getTime();
            for (Event event : dbfillConfig.getEvent()) {
                JTEventConfig ec = new JTEventConfig(event.getProbeId(), event.getMbean(), event.getValueName(), event.getPeriod(), event.getMin(), event.getMax(), event.getDeltaNeg(), event.getDeltaPos());
                this.eventCfgList.add(ec);
            }
            configFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("ERROR when loading DbFill configuration: " + e, new Object[0]);
            throw new Error("Cannot load the dbfill configuration", e);
        }
        this.logger.info(">>>> domain       = " + this.domain, new Object[0]);
        this.logger.info(">>>> server       = " + this.server, new Object[0]);
        this.logger.info(">>>> sname        = " + this.sName, new Object[0]);
        this.logger.info(">>>> source       = " + this.source, new Object[0]);
        this.logger.info(">>>> time-from    = " + new Date(this.timeFrom).toString(), new Object[0]);
        this.logger.info(">>>> time-to      = " + new Date(this.timeTo).toString(), new Object[0]);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getServer() {
        return this.server;
    }

    public String getSName() {
        return this.sName;
    }

    public String getSource() {
        return this.source;
    }

    public long getTimeFrom() {
        return this.timeFrom;
    }

    public long getTimeTo() {
        return this.timeTo;
    }

    public List<JTEventConfig> getEventConfigList() {
        return this.eventCfgList;
    }
}

