/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.tests.dbfill;

import java.util.Date;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.easybeans.component.smartclient.spi.SmartContextFactory;
import org.ow2.jasmine.event.beans.JasmineEventEB;
import org.ow2.jasmine.monitoring.eventswitch.beans.JasmineEventSLBRemote;
import org.ow2.jasmine.monitoring.tests.dbfill.IPublisher;
import org.ow2.jasmine.monitoring.tests.dbfill.JTEvent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class EjbPublisher
implements IPublisher {
    static final String SMART_FACTORY_HOST_PROPERTY_NAME = "smart.factory.host";
    static final String DEFAULT_SMART_FACTORY_HOST = "localhost";
    static final String SMART_FACTORY_PORT_PROPERTY_NAME = "smart.factory.port";
    static final String DEFAULT_SMART_FACTORY_PORT = "2503";
    static final String JASMINE_EVENT_EJB_NAME = "db-ejb/event";
    private Log logger = LogFactory.getLog(EjbPublisher.class);
    JasmineEventSLBRemote jEventSessionEjb = null;

    public EjbPublisher() {
        this.logger.info(">> Get the EJB = db-ejb/event", new Object[0]);
        try {
            this.jEventSessionEjb = (JasmineEventSLBRemote)this.getContext().lookup(JASMINE_EVENT_EJB_NAME);
        }
        catch (NamingException e) {
            e.printStackTrace();
            this.logger.error("ERROR: Cannot lookup to db-ejb/event EJB: " + e, new Object[0]);
            throw new Error("Cannot lookup to db-ejb/event EJB", e);
        }
    }

    @Override
    public void publishData(JTEvent event) {
        this.logger.debug(">>>>>> event to publish via the EJB: " + event.toString(), new Object[0]);
        JasmineEventEB jEventEB = new JasmineEventEB(event.getDomain(), event.getServer(), event.getSource() + "-dbfill-ejb", event.getMBean() + ":" + event.getVName(), event.getValue(), new Date(event.getTime()), event.getSName());
        this.jEventSessionEjb.saveEvent(jEventEB);
    }

    @Override
    public void close() {
    }

    private Context getContext() throws NamingException {
        String host = System.getProperty(SMART_FACTORY_HOST_PROPERTY_NAME, DEFAULT_SMART_FACTORY_HOST);
        String port = System.getProperty(SMART_FACTORY_PORT_PROPERTY_NAME, DEFAULT_SMART_FACTORY_PORT);
        String url = "smart://" + host + ":" + port;
        this.logger.info(">> Smart Factory URL = " + url, new Object[0]);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", SmartContextFactory.class.getName());
        env.put("java.naming.provider.url", url);
        return new InitialContext(env);
    }
}

