/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.tests.dbfill;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Enumeration;
import org.ow2.jasmine.monitoring.tests.dbfill.IPublisher;
import org.ow2.jasmine.monitoring.tests.dbfill.JTEvent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JdbcPublisher
implements IPublisher {
    static final String JDBC_URL_PROPERTY_NAME = "jdbc.url";
    static final String DEFAULT_JDBC_URL = "jdbc:h2:tcp://localhost:19001/db_jonas";
    static final String JDBC_USER_PROPERTY_NAME = "jdbc.user";
    static final String DEFAULT_JDBC_USER = "jonas";
    static final String JDBC_PASSWD_PROPERTY_NAME = "jdbc.passwd";
    static final String DEFAULT_JDBC_PASSWD = "jonas";
    static final String H2_JDBC_DRIVER = "org.h2.Driver";
    static final String HSQLDB_JDBC_DRIVER = "org.hsqldb.jdbcDriver";
    static final String MYSQL_JDBC_DRIVER = "com.mysql.jdbc.Driver";
    static final String ORACLE_JDBC_DRIVER = "oracle.jdbc.OracleDriver";
    static final String POSTGRESQL_JDBC_DRIVER = "org.postgresql.Driver";
    private Log logger = LogFactory.getLog(JdbcPublisher.class);
    Connection connection;
    PreparedStatement insertStatement;
    long nextPkId = -1L;

    public JdbcPublisher() {
        String sDriver;
        String sUrl = System.getProperty(JDBC_URL_PROPERTY_NAME, DEFAULT_JDBC_URL);
        String sUser = System.getProperty(JDBC_USER_PROPERTY_NAME, "jonas");
        String sPasswd = System.getProperty(JDBC_PASSWD_PROPERTY_NAME, "jonas");
        if (sUrl.startsWith("jdbc:h2")) {
            sDriver = H2_JDBC_DRIVER;
        } else if (sUrl.startsWith("jdbc:hsqldb")) {
            sDriver = HSQLDB_JDBC_DRIVER;
        } else if (sUrl.startsWith("jdbc:mysql")) {
            sDriver = MYSQL_JDBC_DRIVER;
        } else if (sUrl.startsWith("jdbc:oracle")) {
            sDriver = ORACLE_JDBC_DRIVER;
        } else if (sUrl.startsWith("jdbc:postgresql")) {
            sDriver = POSTGRESQL_JDBC_DRIVER;
        } else {
            this.logger.error("ERROR: Unknown database type (not h2, mysql, oracle, paostgresql): ", new Object[0]);
            throw new Error("Unknown database type (not h2, mysql, oracle, paostgresql)");
        }
        this.logger.info(">> JDBC driver = " + sDriver, new Object[0]);
        this.logger.info(">> JDBC url    = " + sUrl, new Object[0]);
        this.logger.info(">> JDBC user   = " + sUser, new Object[0]);
        this.logger.info(">> JDBC passwd = " + sPasswd, new Object[0]);
        try {
            Class<?> drvClass = JdbcPublisher.class.getClassLoader().loadClass(sDriver);
            Driver drv = (Driver)drvClass.newInstance();
            Enumeration<Driver> enume = DriverManager.getDrivers();
            while (enume.hasMoreElements()) {
                enume.nextElement();
            }
            this.connection = DriverManager.getConnection(sUrl, sUser, sPasswd);
            this.insertStatement = this.connection.prepareStatement("INSERT INTO jm_events (id, domain, probe, server, sname, source, timestamp, value) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            Statement selectStatement = this.connection.createStatement();
            ResultSet rset = selectStatement.executeQuery("SELECT MIN(id) FROM jm_events");
            while (rset.next()) {
                this.nextPkId = rset.getLong(1) - 1L;
            }
            this.logger.info(">> nextPkId    = " + this.nextPkId, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("ERROR: Cannot connect to the database: " + e, new Object[0]);
            throw new Error("Cannot connect to the database", e);
        }
    }

    @Override
    public void publishData(JTEvent event) {
        this.logger.debug(">>>>>> event to publish via the EJB: " + event.toString(), new Object[0]);
        try {
            this.insertStatement.setLong(1, this.nextPkId);
            --this.nextPkId;
            this.insertStatement.setString(2, event.getDomain());
            this.insertStatement.setString(3, event.getMBean() + ":" + event.getVName());
            this.insertStatement.setString(4, event.getServer());
            this.insertStatement.setString(5, event.getSName());
            this.insertStatement.setString(6, event.getSource() + "-dbfill-jdbc");
            this.insertStatement.setTimestamp(7, new Timestamp(event.getTime()));
            this.insertStatement.setObject(8, event.getValue());
            this.insertStatement.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("ERROR: Cannot insert an event into the database: " + e, new Object[0]);
            throw new Error("Cannot  insert an event into the database", e);
        }
    }

    @Override
    public void close() {
        try {
            this.insertStatement.close();
            this.connection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("ERROR: Cannot close the JdbcPublisher: " + e, new Object[0]);
            throw new Error("Cannot close the JdbcPublisher", e);
        }
    }
}

