/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.runtime.rule.FactHandle;
import org.ow2.jasmine.rules.api.IDroolsWorkingMemory;
import org.ow2.jasmine.rules.api.IDroolsWorkingMemoryPool;

public abstract class AbstractDroolsWorkingMemoryPool
implements IDroolsWorkingMemoryPool {
    public static final String DEFAULT_WORKING_MEMORY_NAME = "default";
    private Map<String, IDroolsWorkingMemory> workingMemories = new HashMap<String, IDroolsWorkingMemory>();

    @Override
    public void add(String workingMemoryName, IDroolsWorkingMemory workingMemory) throws Exception {
        this.checkWorkingMemoryName(workingMemoryName);
        if (workingMemory == null) {
            throw new Exception("The working memory object to manage is null.");
        }
        this.workingMemories.put(workingMemoryName, workingMemory);
    }

    @Override
    public IDroolsWorkingMemory remove(String workingMemoryName) throws Exception {
        if (!this.workingMemories.containsKey(workingMemoryName)) {
            throw new Exception("There is no working memory registeredin the pool with the name " + workingMemoryName + ".");
        }
        return this.workingMemories.remove(workingMemoryName);
    }

    @Override
    public IDroolsWorkingMemory get(String workingMemoryName) {
        return this.workingMemories.get(workingMemoryName);
    }

    @Override
    public void startAll() throws Exception {
        for (IDroolsWorkingMemory theWorkingMemory : this.workingMemories.values()) {
            theWorkingMemory.start();
        }
    }

    @Override
    public void stopAll() {
        for (IDroolsWorkingMemory theWorkingMemory : this.workingMemories.values()) {
            theWorkingMemory.stop();
        }
    }

    @Override
    public HashMap<String, FactHandle> insertAll(Object fact) {
        HashMap<String, FactHandle> result = new HashMap<String, FactHandle>();
        for (String theWorkingMemoryName : this.workingMemories.keySet()) {
            FactHandle insertResult = this.workingMemories.get(theWorkingMemoryName).insert(fact);
            result.put(theWorkingMemoryName, insertResult);
        }
        return result;
    }

    @Override
    public List<String> getWorkingMemoriesNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : this.workingMemories.keySet()) {
            result.add(name);
        }
        return result;
    }

    private void checkWorkingMemoryName(String workingMemoryName) throws Exception {
        if (workingMemoryName == null || workingMemoryName == "") {
            throw new Exception("A working memory cannot be added to the set with an empty name.");
        }
        if (this.workingMemories.containsKey(workingMemoryName)) {
            throw new Exception("The pool already contains a working memoryregistered with the name " + workingMemoryName + ".");
        }
    }
}

