/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules.osgi.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.conf.EventProcessingOption;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.ow2.jasmine.rules.AbstractDroolsWorkingMemory;
import org.ow2.jasmine.rules.api.DroolsWorkingMemoryState;
import org.ow2.jasmine.rules.osgi.api.IOSGiDroolsWorkingMemory;
import org.ow2.jasmine.rules.osgi.api.IPackageAdder;
import org.ow2.jasmine.rules.osgi.impl.DrlPackageAdder;
import org.ow2.jasmine.rules.osgi.impl.MultiBundleClassLoader;

public class OSGiDroolsWorkingMemory
extends AbstractDroolsWorkingMemory
implements IOSGiDroolsWorkingMemory {
    private static Logger logger = Logger.getLogger(OSGiDroolsWorkingMemory.class.getName());
    private final MultiBundleClassLoader multiBundleClassLoader;
    protected final Map<ServiceReference, IPackageAdder> packageAdders;

    public OSGiDroolsWorkingMemory(BundleContext context, Map<ServiceReference, IPackageAdder> packageAdders) throws Exception {
        super(logger);
        this.packageAdders = packageAdders;
        this.multiBundleClassLoader = new MultiBundleClassLoader(this.getClass().getClassLoader());
        this.multiBundleClassLoader.addBundleClassLoader(context.getBundle());
        this.initKnowledgeBuilderConfiguration(this.multiBundleClassLoader);
    }

    @Override
    public void start() throws Exception {
        if (!this.packageAdders.isEmpty()) {
            this.addPackages(this.packageAdders.values());
        } else {
            this.state = DroolsWorkingMemoryState.IDLE;
            this.debug("WorkingMemory[<name>] No Packages to use yet, going to state {0}", new Object[]{this.state});
        }
    }

    @Override
    public void addPackage(ServiceReference serviceReference, IPackageAdder packageAdder) throws Exception {
        if (this.packageAdders.put(serviceReference, packageAdder) == null && this.state != DroolsWorkingMemoryState.STOPPED) {
            this.debug("WorkingMemory[<name>] Installing Packages from bundle {0}", serviceReference.getBundle());
            this.addPackages(Collections.singletonList(packageAdder));
        } else {
            this.debug("WorkingMemory[<name>] Not installing Packages from bundle {0} (duplicate or STOPPED state) [current:{1}]", new Object[]{serviceReference.getBundle(), this.state});
        }
    }

    @Override
    public void removePackage(ServiceReference serviceReference) throws Exception {
        this.debug("WorkingMemory[<name>] Removing Packages from bundle {0}", serviceReference.getBundle());
        IPackageAdder packageAdder = this.packageAdders.get(serviceReference);
        if (packageAdder != null) {
            this.packageAdders.remove(serviceReference);
            this.multiBundleClassLoader.removeBundleClassLoader(packageAdder.getBundle());
            if (packageAdder instanceof DrlPackageAdder) {
                String name = ((DrlPackageAdder)packageAdder).getPackageName();
                this.knowledgeBase.removeKnowledgePackage(name);
                this.debug("WorkingMemory[<name>] Removing Package[{0}] from the KnowledgeBase", name);
            }
            if (this.packageAdders.size() < 1) {
                this.debug("WorkingMemory[<name>] No more Packages in the memory", new Object[0]);
                if (this.state != DroolsWorkingMemoryState.STOPPED) {
                    this.stop(DroolsWorkingMemoryState.IDLE);
                } else {
                    this.stop(DroolsWorkingMemoryState.STOPPED);
                }
            } else {
                this.debug("WorkingMemory[<name>] Still have some Packages in the memory", new Object[0]);
                if (this.state != DroolsWorkingMemoryState.STOPPED) {
                    this.stop(DroolsWorkingMemoryState.IDLE);
                } else {
                    this.stop(DroolsWorkingMemoryState.STOPPED);
                }
                this.knowledgeBase = null;
                this.knowledgeSession = null;
                this.debug("WorkingMemory[<name>] Base & Sessions nullified", new Object[0]);
                if (!this.packageAdders.isEmpty()) {
                    this.debug("WorkingMemory[<name>] Re-install available Packages", new Object[0]);
                    this.addPackages(this.packageAdders.values());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPackages(Collection<IPackageAdder> packageAdders) throws Exception {
        ClassLoader lastClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            if (this.knowledgeBase == null) {
                KnowledgeBaseConfiguration kbaseConfig = KnowledgeBaseFactory.newKnowledgeBaseConfiguration(null, this.multiBundleClassLoader);
                kbaseConfig.setOption(EventProcessingOption.STREAM);
                this.knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase(kbaseConfig);
                this.debug("WorkingMemory[<name>] Creating KnowledgeBase {0}", this.knowledgeBase);
            }
            for (IPackageAdder packageAdder : packageAdders) {
                this.debug("WorkingMemory[<name>] Adding Package from Bundle {0}", packageAdder.getBundle());
                KnowledgeBuilder packageBuilder = this.newKnowledgeBuilder();
                this.multiBundleClassLoader.addBundleClassLoader(packageAdder.getBundle());
                packageAdder.addPackage(packageBuilder, this.knowledgeBase);
                if (this.knowledgeSession == null) continue;
                this.debug("WorkingMemory[<name>] Adapting existing KnowledgeSession", new Object[0]);
                Map<String, Object> globals = packageAdder.getGlobals();
                if (globals == null) continue;
                for (Map.Entry<String, Object> entry : globals.entrySet()) {
                    this.knowledgeSession.setGlobal(entry.getKey(), entry.getValue());
                }
            }
            if (this.knowledgeSession == null) {
                this.debug("WorkingMemory[<name>] Creating new KnowledgeSession", new Object[0]);
                this.createWorkingMemory();
                for (IPackageAdder packageAdder : packageAdders) {
                    Map<String, Object> globals = packageAdder.getGlobals();
                    if (globals == null) continue;
                    for (Map.Entry<String, Object> entry : globals.entrySet()) {
                        this.knowledgeSession.setGlobal(entry.getKey(), entry.getValue());
                    }
                }
                this.startRuleExecutor();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(lastClassLoader);
        }
    }
}

