/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.monitoring.tests.dbfill;

import java.io.FileInputStream;
import java.io.InputStream;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.ow2.jasmine.monitoring.tests.dbfill.generated.ObjectFactory;
import org.ow2.jasmine.monitoring.tests.dbfill.generated.DbfillConfig;
import org.ow2.jasmine.monitoring.tests.dbfill.generated.Event;

import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class DbFillConfig {

    static final String CONF_FILE_PROPERTY_NAME = "dbfill.config";
    static final String DEFAULT_CONFIG_FILE_NAME = "dbfill-config.xml";
    static final String DATE_FORMAT = "yyyy/MM/dd HH:mm";

    private Log logger = LogFactory.getLog(DbFillConfig.class);

    private String domain = "domain-test";
    private String server = "server-test";
    private String sName = "sName-test";
    private String source = "source-test";
    private long timeFrom;
    private long timeTo;
    private List<JTEventConfig> eventCfgList = new ArrayList<JTEventConfig>();

    public DbFillConfig() {

        try {

            String fName = System.getProperty(CONF_FILE_PROPERTY_NAME);
            InputStream configFile;
            if (fName == null) {
                fName = "dbfill.jar:" + DEFAULT_CONFIG_FILE_NAME;
                configFile = DbFillConfig.class.getClassLoader().getResourceAsStream(DEFAULT_CONFIG_FILE_NAME);
            } else {
                configFile = new FileInputStream(fName);
            }
            logger.info(">> Configuration file = " + fName);

            Format formatter = new SimpleDateFormat(DATE_FORMAT);

            JAXBContext jaxbContext = JAXBContext.newInstance(ObjectFactory.class);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            DbfillConfig dbfillConfig = (DbfillConfig) unmarshaller.unmarshal(configFile);

            this.domain = dbfillConfig.getDomain();
            this.server = dbfillConfig.getServer();
            this.sName = dbfillConfig.getSname();
            this.source = dbfillConfig.getSource();

            String sFrom = dbfillConfig.getTimeFrom();
            Date dateFrom = (Date) formatter.parseObject(sFrom);
            this.timeFrom = dateFrom.getTime();

            String sTo = dbfillConfig.getTimeTo();
            Date dateTo = (Date) formatter.parseObject(sTo);
            this.timeTo = dateTo.getTime();

            // this.timeTo = System.currentTimeMillis();
            // this.timeFrom = timeTo - 60*60*1000; // - 1h

            // Create JTEventConfig list
            for (Event event : dbfillConfig.getEvent()) {
                JTEventConfig ec = new JTEventConfig(event.getProbeId(), event.getMbean(), event.getValueName(), event.getPeriod(), event.getMin(), event.getMax(), event.getDeltaNeg(), event.getDeltaPos());
                eventCfgList.add(ec);
            }

            configFile.close();

        } catch (Exception e) {
            e.printStackTrace();
            logger.error("ERROR when loading DbFill configuration: " + e);
            throw new Error("Cannot load the dbfill configuration", e);
        }

        logger.info(">>>> domain       = " + domain);
        logger.info(">>>> server       = " + server);
        logger.info(">>>> sname        = " + sName);
        logger.info(">>>> source       = " + source);
        logger.info(">>>> time-from    = " + (new Date(timeFrom)).toString());
        logger.info(">>>> time-to      = " + (new Date(timeTo)).toString());
    }

    public String getDomain() {
        return domain;
    }

    public String getServer() {
        return server;
    }

    public String getSName() {
        return sName;
    }
    
    public String getSource() {
        return source;
    }

    public long getTimeFrom() {
        return timeFrom;
    }

    public long getTimeTo() {
        return timeTo;
    }

    public List<JTEventConfig> getEventConfigList() {
        return eventCfgList;
    }

}
