/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.monitoring.tests.dbfill;

import java.util.Date;
import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.ow2.jasmine.event.beans.JasmineEventEB;
import org.ow2.jasmine.monitoring.eventswitch.beans.JasmineEventSLBRemote;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class EjbPublisher implements IPublisher {

    static final String SMART_FACTORY_HOST_PROPERTY_NAME = "smart.factory.host";
    static final String DEFAULT_SMART_FACTORY_HOST = "localhost";
    static final String SMART_FACTORY_PORT_PROPERTY_NAME = "smart.factory.port";
    static final String DEFAULT_SMART_FACTORY_PORT = "2503";
    static final String JASMINE_EVENT_EJB_NAME = "db-ejb/event";

    private Log logger = LogFactory.getLog(EjbPublisher.class);

    JasmineEventSLBRemote jEventSessionEjb = null;

    public EjbPublisher() {
        logger.info(">> Get the EJB = " + JASMINE_EVENT_EJB_NAME);
        try {
            jEventSessionEjb = (JasmineEventSLBRemote) getContext().lookup(JASMINE_EVENT_EJB_NAME);
        } catch (NamingException e) {
            e.printStackTrace();
            logger.error("ERROR: Cannot lookup to " + JASMINE_EVENT_EJB_NAME + " EJB: " + e);
            throw new Error("Cannot lookup to " + JASMINE_EVENT_EJB_NAME + " EJB", e);
        }
    }
    public void publishData(JTEvent event) {
        logger.debug(">>>>>> event to publish via the EJB: " + event.toString());
        JasmineEventEB jEventEB = new JasmineEventEB(event.getDomain(), event.getServer(), event.getSource()+"-dbfill-ejb", event.getMBean()+":"+event.getVName(), event.getValue(), new Date(event.getTime()), event.getSName());
        jEventSessionEjb.saveEvent(jEventEB);
    }
    
    public void close() {
        // Nothing to do
    }

    private Context getContext() throws NamingException {
        String host = System.getProperty(SMART_FACTORY_HOST_PROPERTY_NAME, DEFAULT_SMART_FACTORY_HOST);
        String port = System.getProperty(SMART_FACTORY_PORT_PROPERTY_NAME, DEFAULT_SMART_FACTORY_PORT);
        String url = "smart://"+host+":"+port;
        logger.info(">> Smart Factory URL = " + url);
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put(Context.INITIAL_CONTEXT_FACTORY, org.ow2.easybeans.component.smartclient.spi.SmartContextFactory.class.getName());
        env.put(Context.PROVIDER_URL, url);
        return new InitialContext(env);
    }

}
