/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.monitoring.tests.dbfill;

import java.io.Serializable;
import java.util.Date;
import java.util.Random;

public class JTEvent {

    static Random random = new Random();
    
    String domain;
    String server;
    String sName;
    String source;
    String probeId;
    String mbean;
    String vName;
    long time;
    Serializable value;

    public JTEvent(String domain, String server, String sName, String source, String probeId, String mbean, String vName, long time, Serializable value) {
        this.domain = domain;
        this.server = server;
        this.sName = sName;
        this.source = source;
        this.probeId = probeId;
        this.mbean = mbean;
        this.vName = vName;
        this.time = time;
        this.value = value;
    }

    public String getDomain() {
        return domain;
    }

    public String getServer() {
        return server;
    }

    public String getSName() {
        return sName;
    }

    public String getSource() {
        return source;
    }

    public String getProbeId() {
        return probeId;
    }

    public String getMBean() {
        return mbean;
    }

    public String getVName() {
        return vName;
    }

    public long getTime() {
        return time;
    }
    
    public void setTime(long t) {
        this.time = t;
    }

    public Serializable getValue() {
        return value;
    }
    public void setValue(Serializable v) {
        this.value = v;
    }

    public String toString() {
        Date timeDate = new Date(time);
        String s = "(domain=" + domain + ", server=" + server + ", sName=" + sName + ", source=" + source + ", probeId=" + probeId + ", vName=" + vName
                + ", mbean=" + mbean + ", time=" + timeDate + ", value=" + value.toString() + ")";
        return s;
    }


    static public int computeNextValue(int min, int max, int deltaNegative, int deltaPositive, int prevValue) {
        int nextValue = -1;
        if (min == max) {
            nextValue = min;
        } else {
            int vmin = prevValue - deltaNegative;
            if (vmin < min) {
                vmin = min;
            }
            int vmax = prevValue + deltaPositive;
            if (vmax > max) {
                vmax = max;
            }
            // Add 0.5 because of th erounding due to the cast
            nextValue = vmin + (int) (Math.random() * (vmax - vmin) + 0.5);
            /*
            if (vmax == vmin) {
                nextValue = vmin;
            } else {
                nextValue = vmin + random.nextInt(vmax-vmin);
            }
            */
        }
        return nextValue;
    }
}
