/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.monitoring.tests.dbfill;

import org.mule.extras.client.MuleClient;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class MulePublisher implements IPublisher {

    static final String JPROBE_DISPATCHER_HOST_PROPERTY_NAME = "jprobe.dispatcher.host";
    static final String DEFAULT_JPROBE_DISPATCHER_HOST = "localhost";
    static final String JPROBE_DISPATCHER_PORT_PROPERTY_NAME = "jprobe.dispatcher.port";
    static final String DEFAULT_JPROBE_DISPATCHER_PORT = "18564";

    protected static final String SEPARATOR = ";";

    private Log logger = LogFactory.getLog(MulePublisher.class);

    private MuleClient client = null;

    private String jasmineURI;
    private String header = "jprobe_values_v1\ncmdid;time;domain;server;sname;mbean;";

    public MulePublisher() {
        String host = System.getProperty(JPROBE_DISPATCHER_HOST_PROPERTY_NAME, DEFAULT_JPROBE_DISPATCHER_HOST);
        String port = System.getProperty(JPROBE_DISPATCHER_PORT_PROPERTY_NAME, DEFAULT_JPROBE_DISPATCHER_PORT);
        jasmineURI = "tcp://" + host + ":" + port + "/JProbe";
        logger.info(">> JasmineURI = " + jasmineURI);
        try {
            client = new MuleClient();
        } catch (Exception e) {
            // Should be UMOException
            e.printStackTrace();
            logger.error("ERROR: Cannot create Mule Client:" + e);
            throw new Error("Cannot create Mule Client", e);
        }
    }

    public void publishData(JTEvent event) {
        logger.debug(">>>>>> event to publish via mule: " + event.toString());
        /*
         * See org.ow2.jasmine.probe.outers.mule.internal.JMuleOuter
         */
        // We must use the OLD format, defined in Eventswitch here.
        // See eventswitch-config.xml
        // In this version, we have decided to send each attribute separately.
        // LATER: Change this format.
        StringBuilder sb = new StringBuilder(header);
        // end the header with the JSR's name, then pass to new line for
        // printing out values
        sb.append(event.getVName());
        sb.append(";\n");
        sb.append(event.getProbeId());
        sb.append(SEPARATOR);
        sb.append(event.getTime());
        sb.append(SEPARATOR);
        sb.append(event.getDomain());
        sb.append(SEPARATOR);
        sb.append(event.getServer());
        sb.append(SEPARATOR);
        sb.append(event.getSName());
        sb.append(SEPARATOR);
        sb.append(event.getMBean());
        sb.append(SEPARATOR);
        sb.append(event.getValue().toString());
        sb.append("\n");
        try {
            //client.send(jasmineURI, sb.toString(), null); // To long in synchronous !!!
            client.dispatch(jasmineURI, sb.toString(), null);
        } catch (Exception e) {
            e.printStackTrace();
            // Should be UMOException
            logger.error("ERROR: Cannot dispatch an event to MuleClient:" + e);
            throw new Error("Cannot dispatch an event to MuleClient", e);
        }
    }

    public void close() {
        client.dispose();
    }
}
