/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.tests.dbfill;

import org.mule.extras.client.MuleClient;
import org.ow2.jasmine.monitoring.tests.dbfill.IPublisher;
import org.ow2.jasmine.monitoring.tests.dbfill.JTEvent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class MulePublisher
implements IPublisher {
    static final String JPROBE_DISPATCHER_HOST_PROPERTY_NAME = "jprobe.dispatcher.host";
    static final String DEFAULT_JPROBE_DISPATCHER_HOST = "localhost";
    static final String JPROBE_DISPATCHER_PORT_PROPERTY_NAME = "jprobe.dispatcher.port";
    static final String DEFAULT_JPROBE_DISPATCHER_PORT = "18564";
    protected static final String SEPARATOR = ";";
    private Log logger = LogFactory.getLog(MulePublisher.class);
    private MuleClient client = null;
    private String jasmineURI;
    private String header = "jprobe_values_v1\ncmdid;time;domain;server;sname;mbean;";

    public MulePublisher() {
        String host = System.getProperty(JPROBE_DISPATCHER_HOST_PROPERTY_NAME, DEFAULT_JPROBE_DISPATCHER_HOST);
        String port = System.getProperty(JPROBE_DISPATCHER_PORT_PROPERTY_NAME, DEFAULT_JPROBE_DISPATCHER_PORT);
        this.jasmineURI = "tcp://" + host + ":" + port + "/JProbe";
        this.logger.info((Object)(">> JasmineURI = " + this.jasmineURI), new Object[0]);
        try {
            this.client = new MuleClient();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)("ERROR: Cannot create Mule Client:" + e), new Object[0]);
            throw new Error("Cannot create Mule Client", e);
        }
    }

    @Override
    public void publishData(JTEvent event) {
        this.logger.debug((Object)(">>>>>> event to publish via mule: " + event.toString()), new Object[0]);
        StringBuilder sb = new StringBuilder(this.header);
        sb.append(event.getVName());
        sb.append(";\n");
        sb.append(event.getProbeId());
        sb.append(SEPARATOR);
        sb.append(event.getTime());
        sb.append(SEPARATOR);
        sb.append(event.getDomain());
        sb.append(SEPARATOR);
        sb.append(event.getServer());
        sb.append(SEPARATOR);
        sb.append(event.getSName());
        sb.append(SEPARATOR);
        sb.append(event.getMBean());
        sb.append(SEPARATOR);
        sb.append(event.getValue().toString());
        sb.append("\n");
        try {
            this.client.dispatch(this.jasmineURI, (Object)sb.toString(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)("ERROR: Cannot dispatch an event to MuleClient:" + e), new Object[0]);
            throw new Error("Cannot dispatch an event to MuleClient", e);
        }
    }

    @Override
    public void close() {
        this.client.dispose();
    }
}

