/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.unix;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class Symlink
extends Task {
    private String resource;
    private String link;
    private String action;
    private Vector fileSets = new Vector();
    private String linkFileName;
    private boolean overwrite;
    private boolean failonerror;
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();

    public void init() throws BuildException {
        super.init();
        this.failonerror = true;
        this.overwrite = false;
        this.action = "single";
        this.fileSets = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        try {
            if (this.action.equals("single")) {
                this.doLink(this.resource, this.link);
            } else if (this.action.equals("delete")) {
                try {
                    this.log("Removing symlink: " + this.link);
                    Symlink.deleteSymlink(this.link);
                }
                catch (FileNotFoundException fnfe) {
                    this.handleError(fnfe.toString());
                }
                catch (IOException ioe) {
                    this.handleError(ioe.toString());
                }
            } else if (this.action.equals("recreate")) {
                if (this.fileSets.size() == 0) {
                    this.handleError("File set identifying link file(s) required for action recreate");
                    return;
                }
                Properties listOfLinks = this.loadLinks(this.fileSets);
                Enumeration<Object> keys = listOfLinks.keys();
                while (keys.hasMoreElements()) {
                    this.link = (String)keys.nextElement();
                    this.resource = listOfLinks.getProperty(this.link);
                    try {
                        File test = new File(this.link);
                        File testRes = new File(this.resource);
                        if (!FILE_UTILS.isSymbolicLink(test.getParentFile(), test.getName())) {
                            this.doLink(this.resource, this.link);
                            continue;
                        }
                        if (test.getCanonicalPath().equals(testRes.getCanonicalPath())) continue;
                        Symlink.deleteSymlink(this.link);
                        this.doLink(this.resource, this.link);
                    }
                    catch (IOException ioe) {
                        this.handleError("IO exception while creating link");
                    }
                }
            } else if (this.action.equals("record")) {
                Hashtable byDir = new Hashtable();
                if (this.fileSets.size() == 0) {
                    this.handleError("Fileset identifying links to record required");
                    return;
                }
                if (this.linkFileName == null) {
                    this.handleError("Name of file to record links in required");
                    return;
                }
                Vector vectOfLinks = this.findLinks(this.fileSets);
                Enumeration links = vectOfLinks.elements();
                while (links.hasMoreElements()) {
                    File thisLink = (File)links.nextElement();
                    String parent = thisLink.getParent();
                    if (byDir.containsKey(parent)) {
                        ((Vector)byDir.get(parent)).addElement(thisLink);
                        continue;
                    }
                    byDir.put(parent, new Vector());
                    ((Vector)byDir.get(parent)).addElement(thisLink);
                }
                Enumeration dirs = byDir.keys();
                while (dirs.hasMoreElements()) {
                    String dir = (String)dirs.nextElement();
                    Vector linksInDir = (Vector)byDir.get(dir);
                    Properties linksToStore = new Properties();
                    Enumeration eachlink = linksInDir.elements();
                    while (eachlink.hasMoreElements()) {
                        File alink = (File)eachlink.nextElement();
                        try {
                            linksToStore.put(alink.getName(), alink.getCanonicalPath());
                        }
                        catch (IOException ioe) {
                            this.handleError("Couldn't get canonical name of a parent link");
                        }
                    }
                    File writeTo = new File(dir + File.separator + this.linkFileName);
                    this.writePropertyFile(linksToStore, writeTo, "Symlinks from " + writeTo.getParent());
                }
            } else {
                this.handleError("Invalid action specified in symlink");
            }
        }
        finally {
            this.resource = null;
            this.link = null;
            this.action = "single";
            this.fileSets = new Vector();
            this.linkFileName = null;
            this.overwrite = false;
            this.failonerror = true;
        }
    }

    public void setOverwrite(boolean owrite) {
        this.overwrite = owrite;
    }

    public void setFailOnError(boolean foe) {
        this.failonerror = foe;
    }

    public void setAction(String typ) {
        this.action = typ;
    }

    public void setLink(String lnk) {
        this.link = lnk;
    }

    public void setResource(String src) {
        this.resource = src;
    }

    public void setLinkfilename(String lf) {
        this.linkFileName = lf;
    }

    public void addFileset(FileSet set) {
        this.fileSets.addElement(set);
    }

    public static void deleteSymlink(String path) throws IOException, FileNotFoundException {
        Symlink.deleteSymlink(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteSymlink(File linkfil) throws IOException, FileNotFoundException {
        if (!linkfil.exists()) {
            throw new FileNotFoundException("No such symlink: " + linkfil);
        }
        String canstr = linkfil.getCanonicalPath();
        File canfil = new File(canstr);
        String parentStr = canfil.getParent();
        File parentDir = new File(parentStr);
        File temp = FILE_UTILS.createTempFile("symlink", ".tmp", parentDir);
        temp.deleteOnExit();
        try {
            try {
                FILE_UTILS.rename(canfil, temp);
            }
            catch (IOException e) {
                throw new IOException("Couldn't rename resource when attempting to delete " + linkfil);
            }
            if (!linkfil.delete()) {
                throw new IOException("Couldn't delete symlink: " + linkfil + " (was it a real file? is this not a " + "UNIX system?)");
            }
        }
        finally {
            try {
                FILE_UTILS.rename(temp, canfil);
            }
            catch (IOException e) {
                throw new IOException("Couldn't return resource " + temp + " to its original name: " + canstr + "\n THE RESOURCE'S NAME ON DISK HAS " + "BEEN CHANGED BY THIS ERROR!\n");
            }
        }
    }

    private void writePropertyFile(Properties properties, File propertyfile, String comment) throws BuildException {
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(propertyfile);
                properties.store(fos, comment);
            }
            catch (IOException ioe) {
                throw new BuildException(ioe, this.getLocation());
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            FileUtils.close(fos);
            throw throwable;
        }
        FileUtils.close(fos);
    }

    private void handleError(String msg) {
        if (this.failonerror) {
            throw new BuildException(msg);
        }
        this.log(msg);
    }

    private void doLink(String resource, String link) throws BuildException {
        if (resource == null) {
            this.handleError("Must define the resource to symlink to!");
            return;
        }
        if (link == null) {
            this.handleError("Must define the link name for symlink!");
            return;
        }
        File linkfil = new File(link);
        String[] cmd = new String[]{"ln", "-s", resource, link};
        try {
            if (this.overwrite && linkfil.exists()) {
                Symlink.deleteSymlink(linkfil);
            }
        }
        catch (FileNotFoundException fnfe) {
            this.handleError("Symlink disappeared before it was deleted: " + link);
        }
        catch (IOException ioe) {
            this.handleError("Unable to overwrite preexisting link: " + link);
        }
        this.log(cmd[0] + " " + cmd[1] + " " + cmd[2] + " " + cmd[3]);
        Execute.runCommand(this, cmd);
    }

    private Vector scanDirsAndFiles(DirectoryScanner ds) {
        Vector<String> list = new Vector<String>();
        ds.scan();
        String[] files = ds.getIncludedFiles();
        String[] dirs = ds.getIncludedDirectories();
        int i = 0;
        while (i < files.length) {
            list.addElement(files[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < dirs.length) {
            list.addElement(dirs[i2]);
            ++i2;
        }
        return list;
    }

    private Vector findLinks(Vector fileSets) {
        Vector<File> result = new Vector<File>();
        int i = 0;
        while (i < fileSets.size()) {
            block11: {
                File next;
                FileSet fsTemp = (FileSet)fileSets.elementAt(i);
                String workingDir = null;
                Vector links = new Vector();
                Vector<File> linksFiles = new Vector<File>();
                File tmpfil = null;
                try {
                    tmpfil = fsTemp.getDir(this.getProject());
                    workingDir = tmpfil.getCanonicalPath();
                }
                catch (IOException ioe) {
                    this.handleError("Exception caught getting canonical path of working dir " + tmpfil + " in a FileSet passed to the symlink " + "task. Further processing of this " + "fileset skipped");
                    break block11;
                }
                DirectoryScanner ds = fsTemp.getDirectoryScanner(this.getProject());
                links = this.scanDirsAndFiles(ds);
                Enumeration enumLinks = links.elements();
                while (enumLinks.hasMoreElements()) {
                    linksFiles.addElement(new File(workingDir + File.separator + (String)enumLinks.nextElement()));
                }
                enumLinks = linksFiles.elements();
                Vector<File> removals = new Vector<File>();
                while (enumLinks.hasMoreElements()) {
                    next = (File)enumLinks.nextElement();
                    String nameParentNext = next.getParent();
                    File parentNext = new File(nameParentNext);
                    try {
                        if (FILE_UTILS.isSymbolicLink(parentNext, next.getName())) continue;
                        removals.addElement(next);
                    }
                    catch (IOException ioe) {
                        this.handleError("Failed checking " + next + " for symbolic link. FileSet skipped.");
                        break block11;
                    }
                }
                enumLinks = removals.elements();
                while (enumLinks.hasMoreElements()) {
                    linksFiles.removeElement(enumLinks.nextElement());
                }
                enumLinks = linksFiles.elements();
                while (enumLinks.hasMoreElements()) {
                    next = (File)enumLinks.nextElement();
                    try {
                        File parent = new File(next.getParent());
                        parent = new File(parent.getCanonicalPath());
                        File temp = new File(parent, next.getName());
                        if (result.contains(temp)) continue;
                        result.addElement(temp);
                    }
                    catch (IOException ioe) {
                        this.handleError("IOException: " + next + " omitted");
                    }
                }
            }
            ++i;
        }
        return result;
    }

    private Properties loadLinks(Vector fileSets) {
        Properties finalList = new Properties();
        int i = 0;
        while (i < fileSets.size()) {
            block8: {
                String workingDir;
                FileSet fsTemp = (FileSet)fileSets.elementAt(i);
                try {
                    File linelength = fsTemp.getDir(this.getProject());
                    workingDir = linelength.getCanonicalPath();
                }
                catch (IOException ioe) {
                    this.handleError("Exception caught getting canonical path of working dir of a FileSet passed to symlink task. FileSet skipped.");
                    break block8;
                }
                DirectoryScanner ds = fsTemp.getDirectoryScanner(this.getProject());
                ds.setFollowSymlinks(false);
                ds.scan();
                String[] includedFiles = ds.getIncludedFiles();
                int j = 0;
                while (j < includedFiles.length) {
                    String inDir;
                    File inc = new File(workingDir + File.separator + includedFiles[j]);
                    Properties propTemp = new Properties();
                    try {
                        propTemp.load(new FileInputStream(inc));
                        inDir = inc.getParent();
                        inDir = new File(inDir).getCanonicalPath();
                    }
                    catch (FileNotFoundException fnfe) {
                        this.handleError("Unable to find " + includedFiles[j] + "FileSet skipped.");
                        break;
                    }
                    catch (IOException ioe) {
                        this.handleError("Unable to open " + includedFiles[j] + " or its parent dir" + "FileSet skipped.");
                        break;
                    }
                    Enumeration<Object> keys = propTemp.keys();
                    propTemp.list(System.out);
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        String value = propTemp.getProperty(key);
                        finalList.put(inDir + File.separator + key, value);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return finalList;
    }
}

