/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.instance.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.WorkingMemory;
import org.drools.process.instance.ProcessInstance;
import org.drools.process.instance.WorkItem;
import org.drools.process.instance.WorkItemManager;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.runtime.process.WorkItemHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWorkItemManager
implements WorkItemManager,
Externalizable {
    private static final long serialVersionUID = 400L;
    private long workItemCounter;
    private Map<Long, WorkItem> workItems = new HashMap<Long, WorkItem>();
    private WorkingMemory workingMemory;
    private Map<String, WorkItemHandler> workItemHandlers = new HashMap<String, WorkItemHandler>();

    public DefaultWorkItemManager(WorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.workItemCounter = in.readLong();
        this.workItems = (Map)in.readObject();
        this.workingMemory = (WorkingMemory)in.readObject();
        this.workItemHandlers = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.workItemCounter);
        out.writeObject(this.workItems);
        out.writeObject(this.workingMemory);
        out.writeObject(this.workItemHandlers);
    }

    @Override
    public void internalExecuteWorkItem(WorkItem workItem) {
        ((WorkItemImpl)workItem).setId(++this.workItemCounter);
        this.internalAddWorkItem(workItem);
        WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler != null) {
            handler.executeWorkItem(workItem, this);
        } else {
            System.err.println("Could not find work item handler for " + workItem.getName());
        }
    }

    @Override
    public void internalAddWorkItem(WorkItem workItem) {
        this.workItems.put(new Long(workItem.getId()), workItem);
    }

    @Override
    public void internalAbortWorkItem(long id) {
        WorkItemImpl workItem = (WorkItemImpl)this.workItems.get(new Long(id));
        if (workItem != null) {
            WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler != null) {
                handler.abortWorkItem(workItem, this);
            } else {
                System.err.println("Could not find work item handler for " + workItem.getName());
            }
            this.workItems.remove(workItem.getId());
        }
    }

    @Override
    public Set<WorkItem> getWorkItems() {
        return new HashSet<WorkItem>(this.workItems.values());
    }

    @Override
    public WorkItem getWorkItem(long id) {
        return this.workItems.get(id);
    }

    @Override
    public void completeWorkItem(long id, Map<String, Object> results) {
        WorkItem workItem = this.workItems.get(new Long(id));
        if (workItem != null) {
            workItem.setResults(results);
            ProcessInstance processInstance = this.workingMemory.getProcessInstance(workItem.getProcessInstanceId());
            workItem.setState(2);
            if (processInstance != null) {
                processInstance.signalEvent("workItemCompleted", workItem);
            }
            this.workItems.remove(new Long(id));
            this.workingMemory.fireAllRules();
        }
    }

    @Override
    public void abortWorkItem(long id) {
        WorkItemImpl workItem = (WorkItemImpl)this.workItems.get(new Long(id));
        if (workItem != null) {
            ProcessInstance processInstance = this.workingMemory.getProcessInstance(workItem.getProcessInstanceId());
            workItem.setState(3);
            if (processInstance != null) {
                processInstance.signalEvent("workItemAborted", workItem);
            }
            this.workItems.remove(new Long(id));
            this.workingMemory.fireAllRules();
        }
    }

    @Override
    public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        this.workItemHandlers.put(workItemName, handler);
    }
}

