/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.util.Collection;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.Package;
import org.drools.verifier.PackageDescrFlattener;
import org.drools.verifier.RuleLoader;
import org.drools.verifier.dao.VerifierResult;
import org.drools.verifier.dao.VerifierResultFactory;
import org.drools.verifier.report.ReportModeller;
import org.drools.verifier.report.html.ComponentsReportModeller;

public class Verifier {
    static RuleBase verifierKnowledgeBase;
    private VerifierResult result = VerifierResultFactory.createVerifierResult();

    public void addPackageDescr(PackageDescr descr) {
        try {
            PackageDescrFlattener ruleFlattener = new PackageDescrFlattener();
            ruleFlattener.addPackageDescrToData(descr, this.result.getVerifierData());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public synchronized void reloadAnalysisKnowledgeBase() throws Exception {
        verifierKnowledgeBase = Verifier.createRuleBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fireAnalysis() {
        try {
            if (verifierKnowledgeBase == null) {
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    verifierKnowledgeBase = Verifier.createRuleBase();
                }
            }
            StatefulSession workingMemory = verifierKnowledgeBase.newStatefulSession();
            Collection<? extends Object> c = this.result.getVerifierData().getAll();
            for (Object object : c) {
                workingMemory.insert(object);
            }
            workingMemory.setGlobal("result", this.result);
            workingMemory.fireAllRules();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        return true;
    }

    public String getResultAsPlainText() {
        return ReportModeller.writePlainText(this.result);
    }

    public String getResultAsXML() {
        return ReportModeller.writeXML(this.result);
    }

    public void writeComponentsHTML(String path) {
        ComponentsReportModeller.writeHTML(path, this.result);
    }

    public VerifierResult getResult() {
        return this.result;
    }

    private static RuleBase createRuleBase() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        Collection<Package> packages = RuleLoader.loadPackages();
        for (Package pkg : packages) {
            try {
                ruleBase.addPackage(pkg);
            }
            catch (Exception e) {
                throw new Exception("Adding package " + pkg.getName() + " caused an error.", e);
            }
        }
        return ruleBase;
    }
}

