/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.report.html;

import java.io.File;
import java.io.IOException;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.dao.VerifierData;
import org.drools.verifier.dao.VerifierResult;
import org.drools.verifier.report.components.Severity;
import org.drools.verifier.report.html.ComponentsReportVisitor;
import org.drools.verifier.report.html.ReportModeller;
import org.drools.verifier.report.html.VerifierMessagesVisitor;

public class ComponentsReportModeller
extends ReportModeller {
    public static void writeHTML(String path, VerifierResult result) {
        VerifierData data = result.getVerifierData();
        File sourceFolder = new File(path + "report");
        sourceFolder.mkdir();
        ComponentsReportModeller.writeToFile(path + "report" + File.separator + "index.htm", ComponentsReportModeller.formPage(".", ComponentsReportVisitor.visitObjectTypeCollection(".", data.getAllObjectTypes())));
        ComponentsReportModeller.writeToFile(path + "report" + File.separator + "packages.htm", ComponentsReportModeller.formPage(".", ComponentsReportVisitor.visitRulePackageCollection(".", data.getAllRulePackages())));
        String ruleFolder = path + "report" + File.separator + "rules";
        File rulesFolder = new File(ruleFolder);
        rulesFolder.mkdir();
        for (VerifierRule rule : data.getAllRules()) {
            ComponentsReportModeller.writeToFile(ruleFolder + File.separator + rule.getId() + ".htm", ComponentsReportModeller.formPage("..", ComponentsReportVisitor.visitRule("..", rule, data)));
        }
        String objectTypeFolder = path + "report" + File.separator + "objectTypes";
        File objectTypesFolder = new File(objectTypeFolder);
        objectTypesFolder.mkdir();
        for (ObjectType objectType : data.getAllObjectTypes()) {
            ComponentsReportModeller.writeToFile(objectTypeFolder + File.separator + objectType.getId() + ".htm", ComponentsReportModeller.formPage("..", ComponentsReportVisitor.visitObjectType("..", objectType, data)));
        }
        String fieldFolder = path + "report" + File.separator + "fields";
        File fieldsFolder = new File(fieldFolder);
        fieldsFolder.mkdir();
        for (Field field : data.getAllFields()) {
            ComponentsReportModeller.writeToFile(fieldFolder + File.separator + field.getId() + ".htm", ComponentsReportModeller.formPage("..", ComponentsReportVisitor.visitField("..", field, result)));
        }
        ComponentsReportModeller.writeMessages(path, result);
        String cssFolder = path + "report" + File.separator + "css";
        File cssesFolder = new File(cssFolder);
        cssesFolder.mkdir();
        ComponentsReportModeller.writeToFile(cssFolder + File.separator + "basic.css", ComponentsReportVisitor.getCss("basic.css"));
        String imagesFolder = path + "report" + File.separator + "images";
        File imgsFolder = new File(imagesFolder);
        imgsFolder.mkdir();
        try {
            ComponentsReportModeller.copyFile(imagesFolder, "hdrlogo_drools50px.gif");
            ComponentsReportModeller.copyFile(imagesFolder, "jbossrules_hdrbkg_blue.gif");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeMessages(String path, VerifierResult result) {
        VerifierData data = result.getVerifierData();
        String errors = VerifierMessagesVisitor.visitVerifierMessagesCollection(Severity.ERROR.getTuple(), result.getBySeverity(Severity.ERROR), data);
        String warnings = VerifierMessagesVisitor.visitVerifierMessagesCollection(Severity.WARNING.getTuple(), result.getBySeverity(Severity.WARNING), data);
        String notes = VerifierMessagesVisitor.visitVerifierMessagesCollection(Severity.NOTE.getTuple(), result.getBySeverity(Severity.NOTE), data);
        ComponentsReportModeller.writeToFile(path + "report" + File.separator + "verifierMessages.htm", ComponentsReportModeller.formPage(".", errors + warnings + notes));
    }
}

