/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workflow.instance;

import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.definition.process.WorkflowProcess;
import org.drools.process.instance.ProcessInstance;
import org.drools.runtime.process.NodeInstance;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.drools.workflow.instance.impl.NodeInstanceImpl;
import org.drools.workflow.instance.impl.WorkflowProcessInstanceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowProcessInstanceUpgrader {
    public static void upgradeProcessInstance(WorkingMemory workingMemory, long processInstanceId, String processId, Map<Long, Long> nodeMapping) {
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)((Object)workingMemory.getProcessInstance(processInstanceId));
        if (processInstance == null) {
            throw new IllegalArgumentException("Could not find process instance " + processInstanceId);
        }
        if (processId == null) {
            throw new IllegalArgumentException("Null process id");
        }
        WorkflowProcess process = (WorkflowProcess)((Object)((InternalRuleBase)workingMemory.getRuleBase()).getProcess(processId));
        if (process == null) {
            throw new IllegalArgumentException("Could not find process " + processId);
        }
        if (processInstance.getProcessId().equals(processId)) {
            return;
        }
        ((WorkflowProcessInstanceImpl)processInstance).disconnect();
        ((ProcessInstance)((Object)processInstance)).setProcess(process);
        for (NodeInstance nodeInstance : processInstance.getNodeInstances()) {
            Long oldNodeId = nodeInstance.getNodeId();
            Long newNodeId = nodeMapping.get(oldNodeId);
            if (newNodeId == null) {
                newNodeId = oldNodeId;
            }
            if (process.getNode(newNodeId) == null) {
                throw new IllegalArgumentException("Could not find node " + newNodeId);
            }
            if (newNodeId == oldNodeId) continue;
            ((NodeInstanceImpl)nodeInstance).setNodeId(newNodeId);
        }
        ((ProcessInstance)((Object)processInstance)).setWorkingMemory((InternalWorkingMemory)workingMemory);
        ((WorkflowProcessInstanceImpl)processInstance).reconnect();
    }
}

