/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workflow.instance.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.drools.common.EventSupport;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.definition.process.Node;
import org.drools.definition.process.NodeContainer;
import org.drools.definition.process.WorkflowProcess;
import org.drools.process.instance.context.variable.VariableScopeInstance;
import org.drools.process.instance.impl.ProcessInstanceImpl;
import org.drools.runtime.process.EventListener;
import org.drools.workflow.core.node.EventNode;
import org.drools.workflow.core.node.EventNodeInterface;
import org.drools.workflow.instance.NodeInstance;
import org.drools.workflow.instance.NodeInstanceContainer;
import org.drools.workflow.instance.WorkflowProcessInstance;
import org.drools.workflow.instance.impl.NodeInstanceFactory;
import org.drools.workflow.instance.impl.NodeInstanceFactoryRegistry;
import org.drools.workflow.instance.impl.NodeInstanceImpl;
import org.drools.workflow.instance.node.EventBasedNodeInstance;
import org.drools.workflow.instance.node.EventBasedNodeInstanceInterface;
import org.drools.workflow.instance.node.EventNodeInstance;
import org.drools.workflow.instance.node.EventNodeInstanceInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkflowProcessInstanceImpl
extends ProcessInstanceImpl
implements WorkflowProcessInstance,
NodeInstanceContainer {
    private static final long serialVersionUID = 400L;
    private final List<NodeInstance> nodeInstances = new ArrayList<NodeInstance>();
    private long nodeInstanceCounter = 0L;
    private Map<String, List<EventListener>> eventListeners = new HashMap<String, List<EventListener>>();
    private Map<String, List<EventListener>> externalEventListeners = new HashMap<String, List<EventListener>>();

    @Override
    public NodeContainer getNodeContainer() {
        return this.getWorkflowProcess();
    }

    @Override
    public void addNodeInstance(NodeInstance nodeInstance) {
        ((NodeInstanceImpl)nodeInstance).setId(this.nodeInstanceCounter++);
        this.nodeInstances.add(nodeInstance);
    }

    @Override
    public void removeNodeInstance(NodeInstance nodeInstance) {
        if (((NodeInstanceImpl)nodeInstance).isInversionOfControl()) {
            this.getWorkingMemory().retract(this.getWorkingMemory().getFactHandle(nodeInstance));
        }
        this.nodeInstances.remove(nodeInstance);
    }

    @Override
    public Collection<org.drools.runtime.process.NodeInstance> getNodeInstances() {
        return new ArrayList<org.drools.runtime.process.NodeInstance>(this.getNodeInstances(false));
    }

    @Override
    public Collection<NodeInstance> getNodeInstances(boolean recursive) {
        List<NodeInstance> result = this.nodeInstances;
        if (recursive) {
            result = new ArrayList<NodeInstance>(result);
            for (NodeInstance nodeInstance : this.nodeInstances) {
                if (!(nodeInstance instanceof org.drools.runtime.process.NodeInstanceContainer)) continue;
                result.addAll(((NodeInstanceContainer)((Object)nodeInstance)).getNodeInstances(true));
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public NodeInstance getFirstNodeInstance(long nodeId) {
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (nodeInstance.getNodeId() != nodeId) continue;
            return nodeInstance;
        }
        return null;
    }

    public List<NodeInstance> getNodeInstances(long nodeId) {
        ArrayList<NodeInstance> result = new ArrayList<NodeInstance>();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (nodeInstance.getNodeId() != nodeId) continue;
            result.add(nodeInstance);
        }
        return result;
    }

    @Override
    public NodeInstance getNodeInstance(Node node) {
        NodeInstanceFactoryRegistry nodeRegistry = ((InternalRuleBase)this.getWorkingMemory().getRuleBase()).getConfiguration().getProcessNodeInstanceFactoryRegistry();
        NodeInstanceFactory conf = nodeRegistry.getProcessNodeInstanceFactory(node);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal node type: " + node.getClass());
        }
        NodeInstanceImpl nodeInstance = (NodeInstanceImpl)conf.getNodeInstance(node, this, this);
        if (nodeInstance == null) {
            throw new IllegalArgumentException("Illegal node type: " + node.getClass());
        }
        if (nodeInstance.isInversionOfControl()) {
            this.getWorkingMemory().insert(nodeInstance);
        }
        return nodeInstance;
    }

    public long getNodeInstanceCounter() {
        return this.nodeInstanceCounter;
    }

    public void internalSetNodeInstanceCounter(long nodeInstanceCounter) {
        this.nodeInstanceCounter = nodeInstanceCounter;
    }

    public WorkflowProcess getWorkflowProcess() {
        return (WorkflowProcess)this.getProcess();
    }

    @Override
    public Object getVariable(String name) {
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.getContextInstance("VariableScope");
        if (variableScopeInstance == null) {
            return null;
        }
        return variableScopeInstance.getVariable(name);
    }

    @Override
    public void setState(int state) {
        super.setState(state);
        if (state == 2 || state == 3) {
            InternalWorkingMemory workingMemory = (InternalWorkingMemory)this.getWorkingMemory();
            ((EventSupport)((Object)this.getWorkingMemory())).getRuleFlowEventSupport().fireBeforeRuleFlowProcessCompleted(this, workingMemory);
            while (!this.nodeInstances.isEmpty()) {
                NodeInstance nodeInstance = this.nodeInstances.get(0);
                nodeInstance.cancel();
            }
            this.removeEventListeners();
            workingMemory.removeProcessInstance(this);
            ((EventSupport)((Object)workingMemory)).getRuleFlowEventSupport().fireAfterRuleFlowProcessCompleted(this, workingMemory);
            String type = "processInstanceCompleted:" + this.getId();
            workingMemory.getSignalManager().signalEvent(type, this);
        }
    }

    @Override
    public void disconnect() {
        this.removeEventListeners();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (!(nodeInstance instanceof EventBasedNodeInstance)) continue;
            ((EventBasedNodeInstance)nodeInstance).removeEventListeners();
        }
        super.disconnect();
    }

    @Override
    public void reconnect() {
        super.reconnect();
        for (NodeInstance nodeInstance : this.nodeInstances) {
            if (!(nodeInstance instanceof EventBasedNodeInstanceInterface)) continue;
            ((EventBasedNodeInstanceInterface)((Object)nodeInstance)).addEventListeners();
        }
        this.addEventListeners();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("WorkflowProcessInstance");
        sb.append(this.getId());
        sb.append(" [processId=");
        sb.append(this.getProcess().getId());
        sb.append(",state=");
        sb.append(this.getState());
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        WorkflowProcessInstanceImpl workflowProcessInstanceImpl = this;
        synchronized (workflowProcessInstanceImpl) {
            this.registerExternalEventNodeListeners();
            super.start();
        }
    }

    private void registerExternalEventNodeListeners() {
        for (Node node : this.getWorkflowProcess().getNodes()) {
            if (!(node instanceof EventNode) || !"external".equals(((EventNode)node).getScope())) continue;
            this.addEventListener(((EventNode)node).getType(), new EventListener(){

                public String[] getEventTypes() {
                    return null;
                }

                public void signalEvent(String type, Object event) {
                }
            }, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalEvent(String type, Object event) {
        WorkflowProcessInstanceImpl workflowProcessInstanceImpl = this;
        synchronized (workflowProcessInstanceImpl) {
            List<EventListener> listeners = this.eventListeners.get(type);
            if (listeners != null) {
                for (EventListener listener : listeners) {
                    listener.signalEvent(type, event);
                }
            }
            if ((listeners = this.externalEventListeners.get(type)) != null) {
                for (EventListener listener : listeners) {
                    listener.signalEvent(type, event);
                }
            }
            for (Node node : this.getWorkflowProcess().getNodes()) {
                if (!(node instanceof EventNodeInterface) || !((EventNodeInterface)((Object)node)).acceptsEvent(type, event)) continue;
                if (node instanceof EventNode) {
                    EventNodeInstance eventNodeInstance = (EventNodeInstance)this.getNodeInstance(node);
                    eventNodeInstance.signalEvent(type, event);
                    continue;
                }
                List<NodeInstance> nodeInstances = this.getNodeInstances(node.getId());
                if (nodeInstances == null || nodeInstances.isEmpty()) continue;
                for (NodeInstance nodeInstance : nodeInstances) {
                    ((EventNodeInstanceInterface)((Object)nodeInstance)).signalEvent(type, event);
                }
            }
        }
    }

    @Override
    public void addEventListener(String type, EventListener listener, boolean external) {
        Map<String, List<EventListener>> eventListeners = external ? this.externalEventListeners : this.eventListeners;
        List<EventListener> listeners = eventListeners.get(type);
        if (listeners == null) {
            listeners = new CopyOnWriteArrayList<EventListener>();
            eventListeners.put(type, listeners);
            if (external) {
                this.getWorkingMemory().getSignalManager().addEventListener(type, this);
            }
        }
        listeners.add(listener);
    }

    @Override
    public void removeEventListener(String type, EventListener listener, boolean external) {
        Map<String, List<EventListener>> eventListeners = external ? this.externalEventListeners : this.eventListeners;
        List<EventListener> listeners = eventListeners.get(type);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                eventListeners.remove(type);
                if (external) {
                    this.getWorkingMemory().getSignalManager().removeEventListener(type, this);
                }
            }
        }
    }

    private void addEventListeners() {
        this.registerExternalEventNodeListeners();
    }

    private void removeEventListeners() {
        for (String type : this.externalEventListeners.keySet()) {
            this.getWorkingMemory().getSignalManager().removeEventListener(type, this);
        }
    }

    @Override
    public String[] getEventTypes() {
        return this.externalEventListeners.keySet().toArray(new String[this.externalEventListeners.size()]);
    }
}

