/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.ArrayList;
import java.util.List;
import org.mule.MuleManager;
import org.mule.interceptors.InterceptorStack;
import org.mule.interceptors.LoggingInterceptor;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.umo.UMOInterceptorStack;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.transformer.UMOTransformer;

public abstract class AbstractUMOManagerTestCase
extends AbstractMuleTestCase {
    private static boolean initialised = false;

    protected void doSetUp() throws Exception {
        if (!initialised) {
            this.getUMOManager();
            initialised = true;
        }
    }

    public abstract UMOManager getUMOManager() throws Exception;

    public void testConnectorLookup() throws Exception {
        UMOConnector connector = MuleManager.getInstance().lookupConnector("testConnector");
        AbstractUMOManagerTestCase.assertNotNull(connector);
        AbstractUMOManagerTestCase.assertEquals(1, MuleManager.getInstance().getConnectors().size());
        TestConnector connector2 = AbstractUMOManagerTestCase.getTestConnector();
        MuleManager.getInstance().registerConnector(connector2);
        AbstractUMOManagerTestCase.assertEquals(2, MuleManager.getInstance().getConnectors().size());
        AbstractUMOManagerTestCase.assertNull(MuleManager.getInstance().lookupConnector("doesnotexist"));
    }

    public void testEndpointLookup() throws Exception {
        UMOEndpoint endpoint = MuleManager.getInstance().lookupEndpoint("testEndpoint");
        AbstractUMOManagerTestCase.assertNotNull(endpoint);
        AbstractUMOManagerTestCase.assertEquals(1, MuleManager.getInstance().getEndpoints().size());
        UMOEndpoint endpoint2 = AbstractUMOManagerTestCase.getTestEndpoint("testProvider2", "sender");
        MuleManager.getInstance().registerEndpoint(endpoint2);
        AbstractUMOManagerTestCase.assertEquals(2, MuleManager.getInstance().getEndpoints().size());
        UMOEndpoint endpoint3 = MuleManager.getInstance().lookupEndpoint("doesnotexist");
        AbstractUMOManagerTestCase.assertNull(endpoint3);
    }

    public void testTransformerLookup() throws Exception {
        UMOTransformer transformer = MuleManager.getInstance().lookupTransformer("testTransformer");
        AbstractUMOManagerTestCase.assertNotNull(transformer);
        AbstractUMOManagerTestCase.assertEquals(1, MuleManager.getInstance().getTransformers().size());
        UMOTransformer transformer2 = AbstractUMOManagerTestCase.getTestTransformer();
        MuleManager.getInstance().registerTransformer(transformer2);
        AbstractUMOManagerTestCase.assertEquals(2, MuleManager.getInstance().getTransformers().size());
        UMOTransformer transformer3 = MuleManager.getInstance().lookupTransformer("doesnotexist");
        AbstractUMOManagerTestCase.assertNull(transformer3);
    }

    public void testEndpointIdentifierLookup() throws Exception {
        String endpoint = MuleManager.getInstance().lookupEndpointIdentifier("testEndpointURI", null);
        AbstractUMOManagerTestCase.assertNotNull(endpoint);
        AbstractUMOManagerTestCase.assertEquals("test://endpoint.test", endpoint);
        AbstractUMOManagerTestCase.assertEquals(1, MuleManager.getInstance().getEndpointIdentifiers().size());
        MuleManager.getInstance().registerEndpointIdentifier("testEndpoint2", "endpointUri.test.2");
        AbstractUMOManagerTestCase.assertEquals(2, MuleManager.getInstance().getEndpointIdentifiers().size());
        String endpoint2 = MuleManager.getInstance().lookupEndpointIdentifier("doesnotexist", null);
        AbstractUMOManagerTestCase.assertNull(endpoint2);
    }

    public void testManagerProperties() {
        String value = (String)MuleManager.getInstance().getProperty("envProperty1");
        AbstractUMOManagerTestCase.assertEquals("value1", value);
        AbstractUMOManagerTestCase.assertEquals(1, MuleManager.getInstance().getProperties().size());
    }

    public void testInterceptorStacks() {
        UMOInterceptorStack stack1 = MuleManager.getInstance().lookupInterceptorStack("testInterceptorStack");
        AbstractUMOManagerTestCase.assertNotNull(stack1);
        List interceptors = stack1.getInterceptors();
        AbstractUMOManagerTestCase.assertEquals(2, interceptors.size());
        InterceptorStack stack2 = new InterceptorStack();
        ArrayList<LoggingInterceptor> interceptors2 = new ArrayList<LoggingInterceptor>();
        interceptors2.add(new LoggingInterceptor());
        stack2.setInterceptors(interceptors2);
        MuleManager.getInstance().registerInterceptorStack("testInterceptors2", stack2);
        AbstractUMOManagerTestCase.assertEquals(1, MuleManager.getInstance().lookupInterceptorStack("testInterceptors2").getInterceptors().size());
        UMOInterceptorStack stack3 = MuleManager.getInstance().lookupInterceptorStack("doesnotexist");
        AbstractUMOManagerTestCase.assertNull(stack3);
    }

    public void testTrasactionSetting() throws Exception {
        AbstractUMOManagerTestCase.assertNotNull(MuleManager.getInstance().getTransactionManager());
        try {
            MuleManager.getInstance().setTransactionManager(null);
            AbstractUMOManagerTestCase.fail("cannot set tx manager once it has been set");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

