/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.model;

import org.mule.config.ConfigurationException;
import org.mule.impl.MuleDescriptor;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.umo.manager.ObjectNotFoundException;
import org.mule.umo.manager.UMOContainerContext;

public abstract class AbstractContainerContextTestCase
extends AbstractMuleTestCase {
    public void testContainerContext() throws Exception {
        UMOContainerContext container = this.getContainerContext();
        container.initialise();
        AbstractContainerContextTestCase.assertNotNull(container);
        Object result = null;
        try {
            result = container.getComponent(null);
            AbstractContainerContextTestCase.fail("Should throw ObjectNotFoundException for null key");
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
        try {
            result = container.getComponent("abcdefg123456!\u00ef\u00bf\u00bd$%^n");
            AbstractContainerContextTestCase.fail("Should throw ObjectNotFoundException for a key that doesn't exist");
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
        try {
            result = container.getComponent(Apple.class);
            AbstractContainerContextTestCase.assertNotNull("Component should exist in container", result);
        }
        catch (ObjectNotFoundException e) {
            AbstractContainerContextTestCase.fail("Component should exist in the container");
        }
    }

    public void testExternalUMOReference() throws Exception {
        UMOContainerContext container = this.getContainerContext();
        AbstractContainerContextTestCase.assertNotNull(container);
        container.initialise();
        MuleDescriptor descriptor = AbstractContainerContextTestCase.getTestDescriptor("fruit Bowl", "org.mule.tck.testmodels.fruit.FruitBowl");
        descriptor.setContainer("plexus");
        descriptor.initialise();
        FruitBowl fruitBowl = (FruitBowl)container.getComponent(this.getFruitBowlComponentName());
        AbstractContainerContextTestCase.assertNotNull(fruitBowl);
        AbstractContainerContextTestCase.assertTrue(fruitBowl.hasApple());
        AbstractContainerContextTestCase.assertTrue(fruitBowl.hasBanana());
    }

    public abstract UMOContainerContext getContainerContext() throws ConfigurationException;

    protected String getFruitBowlComponentName() {
        return FruitBowl.class.getName();
    }
}

